/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.manager.pkg.Component;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class CustomTableIconButton {
    private Item parentItem;
    private int columnIndex;
    private boolean isHidden;
    private Image normalImage;
    private Image pushImage;
    private Image hoverImage;
    private Image disabledImage;
    private Enum<ButtonState> state;
    private Point oldPoint;
    private ArrayList<IClickEventListener> clickListenerList;
    private ArrayList<IChangeStateEventListener> changeStateListenerList;
    private Image uncheckedNormalImage;
    private Image uncheckedHoverImage;
    private Image uncheckedDisabledImage;
    private Image checkedNormalImage;
    private Image checkedHoverImage;
    private Image checkedDisabledImage;
    boolean isCheckBox = false;
    boolean checkState = false;
    private WizardUIResourceHandler uiRrcHandler = WizardUIResourceHandler.getInstance();
    boolean isSelected = false;

    public CustomTableIconButton(Item treeItem, int columnIndex1, Enum<WizardUIResourceHandler.UIIcon> normal, Enum<WizardUIResourceHandler.UIIcon> hover, Enum<WizardUIResourceHandler.UIIcon> push, Enum<WizardUIResourceHandler.UIIcon> disabled) {
        this.parentItem = treeItem;
        this.columnIndex = columnIndex1;
        if (normal != null) {
            this.normalImage = this.uiRrcHandler.getImage(normal);
        }
        if (push != null) {
            this.pushImage = this.uiRrcHandler.getImage(push);
        }
        if (hover != null) {
            this.hoverImage = this.uiRrcHandler.getImage(hover);
        }
        if (disabled != null) {
            this.disabledImage = this.uiRrcHandler.getImage(disabled);
        }
        this.state = ButtonState.ICON_BTN_NORMAL;
        this.isHidden = false;
        this.clickListenerList = new ArrayList();
        this.changeStateListenerList = new ArrayList();
    }

    public CustomTableIconButton(Item treeItem, int columnIndex1, Enum<WizardUIResourceHandler.UIIcon> unchecked, Enum<WizardUIResourceHandler.UIIcon> uncheckedHover, Enum<WizardUIResourceHandler.UIIcon> uncheckedDisabled, Enum<WizardUIResourceHandler.UIIcon> checked, Enum<WizardUIResourceHandler.UIIcon> checkedHover, Enum<WizardUIResourceHandler.UIIcon> checkedDisabled) {
        this(treeItem, columnIndex1, unchecked, uncheckedHover, uncheckedHover, uncheckedDisabled);
        this.uncheckedNormalImage = this.normalImage;
        this.uncheckedHoverImage = this.hoverImage;
        this.uncheckedDisabledImage = this.disabledImage;
        if (checked != null) {
            this.checkedNormalImage = this.uiRrcHandler.getImage(checked);
        }
        if (checkedHover != null) {
            this.checkedHoverImage = this.uiRrcHandler.getImage(checkedHover);
        }
        if (checkedDisabled != null) {
            this.checkedDisabledImage = this.uiRrcHandler.getImage(checkedDisabled);
        }
        this.isCheckBox = true;
        this.checkState = false;
    }

    public void handleEvent(Enum<CustomMouseEvent> event) {
        if (this.isHidden || this.state == ButtonState.ICON_BTN_DISABLED) {
            return;
        }
        if (this.parentItem == null || this.parentItem.isDisposed()) {
            return;
        }
        if (event == CustomMouseEvent.ICON_MOUSE_OVER) {
            if (this.state == ButtonState.ICON_BTN_PUSH) {
                return;
            }
            if (this.state == ButtonState.ICON_BTN_HOVER) {
                return;
            }
            this.state = ButtonState.ICON_BTN_HOVER;
        } else {
            this.state = event == CustomMouseEvent.ICON_MOUSE_DOWN ? ButtonState.ICON_BTN_PUSH : (event == CustomMouseEvent.ICON_MOUSE_UP ? ButtonState.ICON_BTN_NORMAL : (event == CustomMouseEvent.ICON_MOUSE_EXIT ? ButtonState.ICON_BTN_NORMAL : ButtonState.ICON_BTN_NORMAL));
        }
        this.show();
    }

    private void show() {
        if (this.parentItem instanceof TreeItem) {
            Rectangle bound = this.getBounds();
            ((TreeItem)this.parentItem).getParent().redraw(bound.x, bound.y, bound.width, bound.height, true);
        } else if (this.parentItem instanceof TableItem) {
            Rectangle bound = this.getBounds();
            ((TableItem)this.parentItem).getParent().redraw(bound.x, bound.y, bound.width, bound.height, true);
        }
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Image getImage() {
        if (this.isHidden) {
            return null;
        }
        if (this.state == ButtonState.ICON_BTN_HOVER && this.hoverImage != null) {
            return this.hoverImage;
        }
        if (this.state == ButtonState.ICON_BTN_NORMAL && this.normalImage != null) {
            return this.normalImage;
        }
        if (this.state == ButtonState.ICON_BTN_PUSH && this.pushImage != null) {
            return this.pushImage;
        }
        if (this.state == ButtonState.ICON_BTN_DISABLED && this.disabledImage != null) {
            return this.disabledImage;
        }
        return this.normalImage;
    }

    private void hide() {
        if (this.parentItem instanceof TreeItem) {
            ((TreeItem)this.parentItem).setImage(this.columnIndex, null);
        } else if (this.parentItem instanceof TableItem) {
            ((TableItem)this.parentItem).setImage(this.columnIndex, null);
        }
    }

    public void setHidden(boolean val) {
        if (this.isHidden != val) {
            this.isHidden = val;
            if (!val) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setDisabled(boolean val) {
        Enum<ButtonState> oldState = this.state;
        if (!this.isHidden) {
            if (val) {
                this.state = ButtonState.ICON_BTN_DISABLED;
            } else if (this.state == ButtonState.ICON_BTN_DISABLED) {
                this.state = ButtonState.ICON_BTN_NORMAL;
            }
            if (oldState != this.state) {
                this.show();
            }
        }
    }

    public boolean isDisabled() {
        return this.state == ButtonState.ICON_BTN_DISABLED;
    }

    public void setChecked(boolean checked) {
        if (this.isCheckBox) {
            this.checkState = checked;
            if (this.checkState) {
                this.normalImage = this.checkedNormalImage;
                this.hoverImage = this.checkedHoverImage;
                this.pushImage = this.checkedHoverImage;
                this.disabledImage = this.checkedDisabledImage;
            } else {
                this.normalImage = this.uncheckedNormalImage;
                this.hoverImage = this.uncheckedHoverImage;
                this.pushImage = this.uncheckedHoverImage;
                this.disabledImage = this.uncheckedDisabledImage;
            }
            this.emitChangeStateEvent();
            if (!this.isHidden) {
                this.show();
            }
        }
    }

    public void setSelect(boolean select) {
        this.isSelected = select;
        this.state = this.isSelected ? ButtonState.ICON_BTN_PUSH : ButtonState.ICON_BTN_NORMAL;
    }

    public boolean isChecked() {
        if (this.isCheckBox) {
            return this.checkState;
        }
        return false;
    }

    public void setIcons(Enum<WizardUIResourceHandler.UIIcon> normal, Enum<WizardUIResourceHandler.UIIcon> hover, Enum<WizardUIResourceHandler.UIIcon> push, Enum<WizardUIResourceHandler.UIIcon> disabled) {
        if (normal != null) {
            this.normalImage = this.uiRrcHandler.getImage(normal);
        }
        if (hover != null) {
            this.hoverImage = this.uiRrcHandler.getImage(hover);
        }
        if (push != null) {
            this.pushImage = this.uiRrcHandler.getImage(push);
        }
        if (disabled != null) {
            this.disabledImage = this.uiRrcHandler.getImage(disabled);
        }
    }

    public Enum<ButtonState> getState() {
        return this.state;
    }

    public void handleMouseMoveEvent(Point pt) {
        Rectangle bounds = this.getBounds();
        if (bounds != null && bounds.contains(pt)) {
            this.handleEvent(CustomMouseEvent.ICON_MOUSE_OVER);
        } else if (bounds != null && this.oldPoint != null && bounds.contains(this.oldPoint) && !bounds.contains(pt)) {
            this.handleEvent(CustomMouseEvent.ICON_MOUSE_EXIT);
        }
        this.oldPoint = pt;
    }

    public void handleMouseUpEvent(MouseEvent event) {
        if (this.parentItem != null) {
            Enum<ButtonState> oldState = this.state;
            if (this.state == ButtonState.ICON_BTN_PUSH) {
                if (this.isCheckBox) {
                    this.checkState = !this.checkState;
                    this.setChecked(this.checkState);
                }
                this.handleEvent(CustomMouseEvent.ICON_MOUSE_UP);
                if (oldState == ButtonState.ICON_BTN_PUSH) {
                    this.emitMouseClickEvent();
                }
            } else {
                this.handleEvent(CustomMouseEvent.ICON_MOUSE_UP);
            }
        }
    }

    public void handleMouseDownEvent(MouseEvent event) {
        if (this.parentItem != null) {
            this.handleEvent(CustomMouseEvent.ICON_MOUSE_DOWN);
        }
    }

    public void addMouseClickEventListener(IClickEventListener listener) {
        this.clickListenerList.add(listener);
    }

    public void removeAllMouseClickEventListeners() {
        this.clickListenerList = new ArrayList();
    }

    private void emitMouseClickEvent() {
        for (IClickEventListener listener : this.clickListenerList) {
            listener.onClick(this);
        }
    }

    public void addChangeStateEventListener(IChangeStateEventListener listener) {
        this.changeStateListenerList.add(listener);
    }

    public void removeAllChangeStateEventListeners() {
        this.changeStateListenerList = new ArrayList();
    }

    private void emitChangeStateEvent() {
        for (IChangeStateEventListener listener : this.changeStateListenerList) {
            listener.onChangeState(this, this.checkState);
        }
    }

    public Component getComponentItem() {
        return (Component)this.parentItem.getData();
    }

    public Item getParentItem() {
        return this.parentItem;
    }

    public Rectangle getBounds() {
        if (this.parentItem != null && this.parentItem instanceof TableItem) {
            TableItem tabItem = (TableItem)this.parentItem;
            return tabItem.getBounds(this.columnIndex);
        }
        if (this.parentItem != null && this.parentItem instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)this.parentItem;
            Rectangle bound = treeItem.getBounds(this.columnIndex);
            if (this.normalImage == null) {
                return new Rectangle(bound.x, bound.y, 20, 20);
            }
            return bound;
        }
        return null;
    }

    public boolean isDisposed() {
        if (this.parentItem != null && this.parentItem instanceof TableItem) {
            TableItem tableItem = (TableItem)this.parentItem;
            return tableItem.isDisposed();
        }
        if (this.parentItem != null && this.parentItem instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)this.parentItem;
            return treeItem.isDisposed();
        }
        return true;
    }

    public static interface IChangeStateEventListener {
        public void onChangeState(CustomTableIconButton var1, boolean var2);
    }

    public static interface IClickEventListener {
        public void onClick(CustomTableIconButton var1);
    }

    public static enum CustomMouseEvent {
        ICON_MOUSE_OVER,
        ICON_MOUSE_DOWN,
        ICON_MOUSE_UP,
        ICON_MOUSE_EXIT;

    }

    private static enum ButtonState {
        ICON_BTN_NORMAL,
        ICON_BTN_HOVER,
        ICON_BTN_PUSH,
        ICON_BTN_DISABLED;

    }
}

