/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.OriginalCCombo;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TypedListener;

public class TizenCombo
extends OriginalCCombo {
    private static final int STATE_EDITABLE = 0;
    private static final int STATE_NORMAL = 1;
    private static final int STATE_HOVER = 2;
    private static final int STATE_DIMMED = 3;
    private boolean isUnfold = false;
    private int comboState = 1;
    public static final int LIMIT = 65535;
    private int originalStyle = 0;

    public TizenCombo(Composite parent, int style) {
        super(parent, TizenCombo.removeBorderStyle(style | 0x20000000));
        if (parent instanceof Tree) {
            return;
        }
        this.originalStyle = style;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 1;
        super.setLayout(gridLayout);
        this.text.setLayoutData(new GridData(1808));
        this.arrow.setLayoutData(new GridData(128));
        this.addEventListener();
    }

    @Override
    public int getStyle() {
        return this.originalStyle;
    }

    static int removeBorderStyle(int style) {
        return style &= 0xFFFFF7FF;
    }

    private void addEventListener() {
        this.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.comboState = 2;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                Control[] controlArray = TizenCombo.this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (child.getBounds().contains(new Point(e.x, e.y))) {
                        return;
                    }
                    ++n2;
                }
                TizenCombo.this.comboState = 1;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(15, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.comboState = 0;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(16, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.comboState = 1;
                TizenCombo.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                TizenCombo.this.paint(e);
            }
        });
        this.text.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.comboState = 0;
                TizenCombo.this.redraw();
            }
        });
        this.text.addListener(1, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.comboState = 0;
                TizenCombo.this.redraw();
            }
        });
        this.list.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.isUnfold = false;
                TizenCombo.this.redraw();
            }
        });
        this.list.addListener(15, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.isUnfold = true;
                TizenCombo.this.redraw();
            }
        });
        this.list.addListener(16, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.comboState = 1;
                TizenCombo.this.isUnfold = false;
                TizenCombo.this.redraw();
            }
        });
        this.arrow.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this.isDisposed() || !TizenCombo.this.isEnabled()) {
                    return;
                }
                TizenCombo.this.isUnfold = true;
                TizenCombo.this.redraw();
            }
        });
        this.getDisplay().addFilter(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (TizenCombo.this == null || TizenCombo.this.isDisposed() || TizenCombo.this.popup.isDisposed()) {
                    return;
                }
                if (TizenCombo.this.isHover(e.x, e.y)) {
                    return;
                }
                if (!TizenCombo.this.isDropped()) {
                    return;
                }
                TizenCombo.this.isUnfold = false;
                TizenCombo.this.dropDown(false);
            }
        });
    }

    protected boolean isHover(int x, int y) {
        return x > 0 && y > 0 && this.getBounds().width >= x && this.getBounds().height >= y;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (super.getEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.comboState = enabled ? 1 : 3;
        this.changeWidgetColor();
        this.redraw();
        this.text.setEnabled(enabled);
        this.arrow.setEnabled(enabled);
        this.list.setEnabled(enabled);
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Rectangle rect = this.getClientArea();
        this.changeWidgetColor();
        this.drawBorder(gc, rect);
    }

    private void drawBorder(GC gc, Rectangle rect) {
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.setBorderColor(gc);
        gc.drawRectangle(r);
    }

    private void setBorderColor(GC gc) {
        if (this.isUnfold) {
            gc.setForeground(TizenResourceManager.COMBO_LINE_UNFOLD_COLOR);
            return;
        }
        switch (this.comboState) {
            case 0: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_EDITABLE_COLOR);
                break;
            }
            case 1: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_NORMAL_COLOR);
                break;
            }
            case 2: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_HOVER_COLOR);
                break;
            }
            case 3: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_DIMMED_COLOR);
            }
        }
    }

    private void changeWidgetColor() {
        if (this.isUnfold) {
            this.setBackground(TizenResourceManager.COMBO_BG_UNFOLD_COLOR);
            this.text.setBackground(TizenResourceManager.COMBO_BG_UNFOLD_COLOR);
            this.text.setForeground(TizenResourceManager.COMBO_FONT_UNFOLD_COLOR);
            this.arrow.setBackground(TizenResourceManager.COMBO_BG_UNFOLD_COLOR);
            this.arrow.setForeground(TizenResourceManager.COMBO_FONT_UNFOLD_COLOR);
            return;
        }
        switch (this.comboState) {
            case 0: {
                this.setBackground(TizenResourceManager.COMBO_BG_EDITABLE_COLOR);
                this.text.setBackground(TizenResourceManager.COMBO_BG_EDITABLE_COLOR);
                this.text.setForeground(TizenResourceManager.COMBO_FONT_EDITABLE_COLOR);
                this.arrow.setBackground(TizenResourceManager.COMBO_BG_EDITABLE_COLOR);
                this.arrow.setForeground(TizenResourceManager.COMBO_LINE_EDITABLE_COLOR);
                break;
            }
            case 1: {
                this.setBackground(TizenResourceManager.COMBO_BG_NORMAL_COLOR);
                this.text.setBackground(TizenResourceManager.COMBO_BG_NORMAL_COLOR);
                this.text.setForeground(TizenResourceManager.COMBO_FONT_NORMAL_COLOR);
                this.arrow.setBackground(TizenResourceManager.COMBO_BG_NORMAL_COLOR);
                this.arrow.setForeground(TizenResourceManager.COMBO_FONT_NORMAL_COLOR);
                break;
            }
            case 2: {
                this.setBackground(TizenResourceManager.COMBO_BG_HOVER_COLOR);
                this.text.setBackground(TizenResourceManager.COMBO_BG_HOVER_COLOR);
                this.text.setForeground(TizenResourceManager.COMBO_FONT_HOVER_COLOR);
                this.arrow.setBackground(TizenResourceManager.COMBO_BG_HOVER_COLOR);
                this.arrow.setForeground(TizenResourceManager.COMBO_FONT_HOVER_COLOR);
                break;
            }
            case 3: {
                this.setBackground(TizenResourceManager.COMBO_BG_DIMMED_COLOR);
                this.text.setBackground(TizenResourceManager.COMBO_BG_DIMMED_COLOR);
                this.text.setForeground(TizenResourceManager.COMBO_FONT_DIMMED_COLOR);
                this.arrow.setBackground(TizenResourceManager.COMBO_BG_DIMMED_COLOR);
                this.arrow.setForeground(TizenResourceManager.COMBO_LINE_DIMMED_COLOR);
            }
        }
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.getStyle() & 8) != 0) {
            return 0;
        }
        return this.text.getCaretLocation().x;
    }

    public void addSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
            return;
        }
        this.addListener(49, new TypedListener(listener));
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
            return;
        }
        this.removeListener(49, listener);
    }
}

