/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.api;

import java.util.List;
import java.util.regex.Pattern;

public interface ISDKPackage {
    public String getName();

    public String getVersion();

    public String getLabel();

    public String getDescription();

    public String getFormattedDescription();

    public List<String> getOs();

    public String getBuildHostOs();

    public List<String> getInstallDependency();

    public List<String> getBuildDependency();

    public List<String> getSourceDependency();

    public String getAttribute();

    public String getSha256();

    public String getSize();

    public String getPath();

    public String getMaintainer();

    public Profile getProfile();

    public PlatformVersion getPlatformVersion();

    public boolean isExtension();

    @Deprecated
    public Extension getExtension();

    public String getExtensionProfile();

    public boolean isInstalled();

    public boolean isUpdateable();

    public Type getType();

    public boolean isMetaPkg();

    public String getPlatformPath();

    public static enum SearchPackageType {
        ALL("All"),
        META_PKG("Meta-Pkg"),
        REAL_PKG("Real-Pkg");

        private final String name;

        private SearchPackageType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static SearchPackageType getSearchPkgType(String name) {
            for (SearchPackageType p : SearchPackageType.values()) {
                if (!p.toString().equalsIgnoreCase(name)) continue;
                return p;
            }
            return null;
        }
    }

    public static enum Extension {
        NONE("None", "None"),
        UNKNOWN("Unkown", "Unkown"),
        STV("tv-samsung-public", "samsung-public"),
        SCERT("samsung-cert-ext", "cert-add-on"),
        SWEARABLE("wearable-samsung-ext", "tizen-wearable-extension");

        private final String name;
        private final Pattern pattern;

        private Extension(String name, String regex) {
            this.name = name;
            this.pattern = Pattern.compile(regex, 2);
        }

        public String toString() {
            return this.name;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public static Extension getExtension(String name) {
            for (Extension p : Extension.values()) {
                if (!p.toString().equalsIgnoreCase(name)) continue;
                return p;
            }
            return null;
        }
    }

    public static enum Type {
        UNKNOWN("Unkown", "Unkown"),
        WEB_CLI("WebAppDevelopment-CLI", "WebApp\\S*CLI"),
        WEB_IDE("WebAppDevelopment", "WebApp"),
        NATIVE_CLI("NativeAppDevelopment-CLI", "NativeApp\\S*CLI"),
        NATIVE_IDE("NativeAppDevelopment", "NativeApp"),
        EMULATOR("Emulator", "Emulator"),
        TAU("WebFramework-TAU", "TAU");

        private final String name;
        private final Pattern pattern;

        private Type(String name, String regex) {
            this.name = name;
            this.pattern = Pattern.compile(regex, 2);
        }

        public String toString() {
            return this.name;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public static Type getType(String name) {
            for (Type p : Type.values()) {
                if (!p.toString().equalsIgnoreCase(name)) continue;
                return p;
            }
            return null;
        }
    }

    public static enum PlatformVersion {
        COMMON("Common"),
        V2_3("2.3"),
        V2_3_1("2.3.1"),
        V2_3_2("2.3.2"),
        V2_4("2.4"),
        V3_0("3.0"),
        V4_0("4.0"),
        V5_0("5.0"),
        V5_5("5.5"),
        V6_0("6.0"),
        V6_5("6.5"),
        V7_0("7.0");

        private final String name;

        private PlatformVersion(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static PlatformVersion getPlatformVersion(String name) {
            for (PlatformVersion p : PlatformVersion.values()) {
                if (!p.toString().equalsIgnoreCase(name)) continue;
                return p;
            }
            return null;
        }
    }

    public static enum Profile {
        COMMON("Common"),
        MOBILE("Mobile"),
        WEARABLE("Wearable"),
        TV("TV");

        private final String name;

        private Profile(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Profile getProfile(String name) {
            for (Profile p : Profile.values()) {
                if (!p.toString().equalsIgnoreCase(name)) continue;
                return p;
            }
            return null;
        }
    }
}

