/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.service;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.tizen.library.sdkutils.api.ISDKPackage;
import org.tizen.library.sdkutils.api.impl.SDKPackage;
import org.tizen.library.sdkutils.api.impl.SDKPackageMap;
import org.tizen.library.sdkutils.packages.PackageManagerWrapper;

public class PackageService {
    private static final PackageManagerWrapper packageManager = new PackageManagerWrapper();

    private PackageService() {
    }

    public static boolean isPackageUpdatable(boolean useCache) {
        boolean isUpdatable = false;
        Map<String, SDKPackage> sdkPkgMap = PackageService.getSDKPackageInfos(null, null, null, ISDKPackage.SearchPackageType.META_PKG, false, useCache);
        if (sdkPkgMap != null) {
            for (Map.Entry<String, SDKPackage> entry : sdkPkgMap.entrySet()) {
                SDKPackage pkg = entry.getValue();
                if (!pkg.isInstalled() || !pkg.isUpdateable()) continue;
                isUpdatable = true;
                break;
            }
        }
        return isUpdatable;
    }

    public static Map<String, SDKPackage> getSDKPackageInfos(ISDKPackage.Profile profile, ISDKPackage.PlatformVersion version, String extName, ISDKPackage.SearchPackageType searchPkgType, boolean installedOnly, boolean useCache) {
        String filePath = packageManager.getSDKPackageInfoPath(useCache);
        if (filePath == null || filePath.isEmpty()) {
            System.out.println("[ERROR] [SDK-Utils] Cache file does not exist. (useCache: " + useCache + ")");
            return null;
        }
        TreeMap<String, SDKPackage> resultSdkMap = null;
        Map<String, SDKPackage> sdkPkgMap = PackageService.getSDKPackageInfoFromFile(filePath);
        if (sdkPkgMap != null) {
            resultSdkMap = new TreeMap<String, SDKPackage>();
            for (Map.Entry<String, SDKPackage> entry : sdkPkgMap.entrySet()) {
                SDKPackage pkg = entry.getValue();
                if (profile != null && !profile.equals((Object)pkg.getProfile()) || version != null && !version.equals((Object)pkg.getPlatformVersion()) || extName != null && !extName.equals(pkg.getExtName()) || searchPkgType != null && !searchPkgType.equals((Object)ISDKPackage.SearchPackageType.ALL) && (ISDKPackage.SearchPackageType.META_PKG.equals((Object)searchPkgType) && !pkg.isMetaPkg() || ISDKPackage.SearchPackageType.REAL_PKG.equals((Object)searchPkgType) && pkg.isMetaPkg()) || installedOnly && !pkg.isInstalled()) continue;
                resultSdkMap.put(pkg.getName(), pkg);
            }
        }
        return resultSdkMap;
    }

    public static Map<String, SDKPackage> getSDKPackageInfos(String packageName, boolean useCache) {
        String filePath = packageManager.getSDKPackageInfoPath(useCache);
        if (filePath == null || filePath.isEmpty()) {
            System.out.println("[ERROR] [SDK-Utils] Cache file does not exist. (useCache: " + useCache + ")");
            return null;
        }
        TreeMap<String, SDKPackage> resultSdkMap = null;
        Map<String, SDKPackage> sdkPkgMap = PackageService.getSDKPackageInfoFromFile(filePath);
        if (sdkPkgMap != null && sdkPkgMap.containsKey(packageName)) {
            resultSdkMap = new TreeMap<String, SDKPackage>();
            SDKPackage sdkPkg = sdkPkgMap.get(packageName);
            resultSdkMap.put(sdkPkg.getName(), sdkPkg);
        }
        return resultSdkMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, SDKPackage> getSDKPackageInfoFromFile(String inputPath) {
        Map<String, SDKPackage> sdkInfo = null;
        BufferedReader br = null;
        if (inputPath == null || inputPath.isEmpty()) {
            return null;
        }
        try {
            Gson gson = new Gson();
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputPath), "UTF-8"));
            SDKPackageMap sdkPkgMap = gson.fromJson((Reader)br, SDKPackageMap.class);
            sdkInfo = sdkPkgMap.getSdkPackages();
            sdkInfo = PackageService.generatePackageScenarioInfo(sdkInfo);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (RuntimeException re) {
            System.out.println("[ERROR] [SDK-Utils] " + re.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sdkInfo;
    }

    private static Map<String, SDKPackage> generatePackageScenarioInfo(Map<String, SDKPackage> pkgMaps) {
        HashMap<String, SDKPackage> sdkInfo = new HashMap<String, SDKPackage>();
        String profile_version_regex = "[a-zA-Z]+\\-(?:(\\d+)\\.)?(?:(\\d+)\\.)?(\\*|\\d+)";
        String version_regex = "(?:(\\d+)\\.)?(?:(\\d+)\\.)?(\\*|\\d+)";
        for (Map.Entry<String, SDKPackage> entry : pkgMaps.entrySet()) {
            SDKPackage sdkPkg = entry.getValue();
            if (sdkPkg == null || sdkPkg.getName() == null || sdkPkg.getName().isEmpty()) continue;
            String pkgName = sdkPkg.getName();
            String profile = null;
            String platformVersion = null;
            String type = null;
            if (sdkPkg.getExtPlatform() != null && !sdkPkg.getExtPlatform().isEmpty()) {
                sdkPkg.setProfile(PackageService.getProfileFromString(sdkPkg.getExtProfile()));
                sdkPkg.setPlatformVersion(PackageService.getPlatformVersionFromString(sdkPkg.getExtPlatform()));
                sdkPkg.setType(PackageService.getTypeFromString(sdkPkg.isMetaPkg(), sdkPkg.getExtDevelopEnv()));
                sdkPkg.setExtension(PackageService.getExtensionFromString(sdkPkg.isMetaPkg(), sdkPkg.isExtension(), sdkPkg.getExtName()));
                sdkInfo.put(pkgName, sdkPkg);
                continue;
            }
            String[] splitPkgName = pkgName.split("-", 3);
            if (splitPkgName.length >= 2) {
                String profile_version = splitPkgName[0] + "-" + splitPkgName[1];
                if (profile_version.matches(profile_version_regex)) {
                    profile = splitPkgName[0];
                    platformVersion = splitPkgName[1];
                    if (splitPkgName.length == 3) {
                        type = splitPkgName[2];
                    }
                } else if (splitPkgName[0].matches(version_regex)) {
                    platformVersion = splitPkgName[0];
                    type = splitPkgName[1];
                } else {
                    type = pkgName;
                }
            }
            sdkPkg.setProfile(PackageService.getProfileFromString(profile));
            sdkPkg.setPlatformVersion(PackageService.getPlatformVersionFromString(platformVersion));
            sdkPkg.setType(PackageService.getTypeFromString(sdkPkg.isMetaPkg(), type));
            sdkPkg.setExtension(PackageService.getExtensionFromString(sdkPkg.isMetaPkg(), sdkPkg.isExtension(), type));
            sdkInfo.put(pkgName, sdkPkg);
        }
        return sdkInfo;
    }

    private static ISDKPackage.Profile getProfileFromString(String profile) {
        ISDKPackage.Profile retProfile = ISDKPackage.Profile.COMMON;
        if (profile != null && !profile.isEmpty()) {
            if (ISDKPackage.Profile.MOBILE.toString().equalsIgnoreCase(profile)) {
                retProfile = ISDKPackage.Profile.MOBILE;
            } else if (ISDKPackage.Profile.WEARABLE.toString().equalsIgnoreCase(profile)) {
                retProfile = ISDKPackage.Profile.WEARABLE;
            } else if (ISDKPackage.Profile.TV.toString().equalsIgnoreCase(profile)) {
                retProfile = ISDKPackage.Profile.TV;
            }
        }
        return retProfile;
    }

    private static ISDKPackage.Type getTypeFromString(boolean isMetaPkg, String type) {
        if (isMetaPkg && type != null && !type.isEmpty()) {
            if (ISDKPackage.Type.NATIVE_CLI.getPattern().matcher(type).find()) {
                return ISDKPackage.Type.NATIVE_CLI;
            }
            if (ISDKPackage.Type.NATIVE_IDE.getPattern().matcher(type).find()) {
                return ISDKPackage.Type.NATIVE_IDE;
            }
            if (ISDKPackage.Type.WEB_CLI.getPattern().matcher(type).find()) {
                return ISDKPackage.Type.WEB_CLI;
            }
            if (ISDKPackage.Type.WEB_IDE.getPattern().matcher(type).find()) {
                return ISDKPackage.Type.WEB_IDE;
            }
            if (ISDKPackage.Type.EMULATOR.getPattern().matcher(type).find()) {
                return ISDKPackage.Type.EMULATOR;
            }
            if (ISDKPackage.Type.TAU.getPattern().matcher(type).find()) {
                return ISDKPackage.Type.TAU;
            }
        }
        return ISDKPackage.Type.UNKNOWN;
    }

    private static ISDKPackage.Extension getExtensionFromString(boolean isMetaPkg, boolean isExtension, String type) {
        if (!isExtension) {
            return ISDKPackage.Extension.NONE;
        }
        if (type != null && !type.isEmpty()) {
            if (ISDKPackage.Extension.STV.getPattern().matcher(type).find()) {
                return ISDKPackage.Extension.STV;
            }
            if (ISDKPackage.Extension.SCERT.getPattern().matcher(type).find()) {
                return ISDKPackage.Extension.SCERT;
            }
            if (ISDKPackage.Extension.SWEARABLE.getPattern().matcher(type).find()) {
                return ISDKPackage.Extension.SWEARABLE;
            }
        }
        return ISDKPackage.Extension.UNKNOWN;
    }

    private static ISDKPackage.PlatformVersion getPlatformVersionFromString(String platformVersion) {
        ISDKPackage.PlatformVersion retPlatformVersion = ISDKPackage.PlatformVersion.COMMON;
        if (platformVersion != null && !platformVersion.isEmpty()) {
            if (ISDKPackage.PlatformVersion.V2_3.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V2_3;
            } else if (ISDKPackage.PlatformVersion.V2_3_1.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V2_3_1;
            } else if (ISDKPackage.PlatformVersion.V2_3_2.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V2_3_2;
            } else if (ISDKPackage.PlatformVersion.V2_4.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V2_4;
            } else if (ISDKPackage.PlatformVersion.V3_0.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V3_0;
            } else if (ISDKPackage.PlatformVersion.V4_0.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V4_0;
            } else if (ISDKPackage.PlatformVersion.V5_0.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V5_0;
            } else if (ISDKPackage.PlatformVersion.V5_5.toString().equalsIgnoreCase(platformVersion)) {
                retPlatformVersion = ISDKPackage.PlatformVersion.V5_5;
            }
        }
        return retPlatformVersion;
    }
}

