/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.configuration.InstallOptionConfigView;
import org.tizen.packagemanager.ui.configuration.ProxyConfigView;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ConfigurationDialog
extends Dialog {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private static final Logger logger = Log.getLogger(ConfigurationDialog.class);
    private int buttonBarHeight;
    private List<Composite> viewLists = new ArrayList<Composite>();
    private StackLayout stackLayout;
    private Shell thisShell;
    private Composite bottomComposite;
    private Composite customComposite;
    private InstallOptionConfigView instOptionView;
    private boolean isServerChanged = false;
    private String selectedRepository = "";
    private String selectedDistribution = "";
    private String selectedSnapshotPath = "";
    private boolean isAutoUpdate = true;
    private Config.ServerType selectedServerType = null;
    private boolean isUninstallationNeeded = false;
    private boolean isRefreshNeeded = false;
    private boolean checkExtRepository = false;
    private boolean confirmed = false;
    private String originRepo = "";
    private String distributionId = "";
    private boolean isFileDialogOpened = false;
    private Label labelError;
    private Button btnConfirm;
    private Button btnCancel;
    private Button btnProxySettings;
    private ConfigurationDialog thisDialog;
    private ContentProvider contentProvider;
    private ContentProvider newContentProvider;

    public boolean isServerChanged() {
        return this.isServerChanged;
    }

    public void setServerChanged(boolean isServerChanged) {
        this.isServerChanged = isServerChanged;
    }

    public String getSelectedRepository() {
        return this.selectedRepository;
    }

    public void setSelectedRepository(String selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

    public String getSelectedDistribution() {
        return this.selectedDistribution;
    }

    public void setSelectedDistribution(String selectedDistribution) {
        this.selectedDistribution = selectedDistribution;
    }

    public String getSelectedSnapshotPath() {
        return this.selectedSnapshotPath;
    }

    public void setSelectedSnapshotPath(String selectedSnapshotPath) {
        this.selectedSnapshotPath = selectedSnapshotPath;
    }

    public boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    public void setAutoUpdate(boolean val) {
        this.isAutoUpdate = val;
    }

    public Config.ServerType getSelectedServerType() {
        return this.selectedServerType;
    }

    public void setSelectedServerType(Config.ServerType selectedServerType) {
        this.selectedServerType = selectedServerType;
    }

    public boolean isUninstallationNeeded() {
        return this.isUninstallationNeeded;
    }

    void setUninstallation() {
        this.isUninstallationNeeded = true;
    }

    public boolean isRefreshNeeded() {
        return this.isRefreshNeeded;
    }

    public void setRefreshNeeded(boolean val) {
        this.isRefreshNeeded = val;
    }

    public boolean isCheckExtRepositoryNeeded() {
        return this.checkExtRepository;
    }

    public void setCheckExtRepository(boolean val) {
        this.checkExtRepository = val;
    }

    public ConfigurationDialog(ContentProvider contentProvider, Shell parent) {
        super(parent);
        this.contentProvider = contentProvider;
        this.newContentProvider = new ContentProvider();
        try {
            this.newContentProvider.setConfig((Config)this.contentProvider.getConfig().clone(this.newContentProvider));
            this.newContentProvider.setRepoMgr(this.contentProvider.getRepoMgr().clone(this.newContentProvider));
            this.newContentProvider.setExtRepoMgr(this.contentProvider.getExtRepoMgr().clone(this.newContentProvider));
            this.newContentProvider.setPkgMgr(this.contentProvider.getPkgMgr().clone(this.newContentProvider));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thisDialog = this;
        this.setShellStyle(67680);
        parent.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
    }

    @Override
    protected void configureShell(Shell newShell) {
        newShell.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        newShell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        newShell.setText(this.uiRsrcHandler.getStringFromResource(WizardUIResourceHandler.UITerms.CONFIGURATION_DIALOG_TITLE));
        this.thisShell = newShell;
        newShell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                ConfigurationDialog.this.confirmed = false;
            }
        });
        super.configureShell(newShell);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    @Override
    protected void okPressed() {
        this.confirmed = true;
        super.okPressed();
    }

    @Override
    protected void cancelPressed() {
        this.confirmed = false;
        super.cancelPressed();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.buttonBarHeight += parent.getShell().getBounds().height - (parent.getShell().getClientArea().height - parent.getShell().getBorderWidth());
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 0;
        formLayout.marginRight = 0;
        formLayout.marginLeft = 0;
        formLayout.marginBottom = 0;
        container.setLayout(formLayout);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.setBottomComposite(container);
        this.setTabComposite(container);
        this.initDisplayView();
        return container;
    }

    private void setTabComposite(Composite container) {
        Composite tablComposite = new Composite(container, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_TAB_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, rect.x);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width;
        formData.height = rect.height;
        tablComposite.setLayoutData(formData);
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 0;
        formLayout.marginRight = 0;
        formLayout.marginLeft = 0;
        formLayout.marginBottom = 0;
        tablComposite.setLayout(formLayout);
        tablComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.setCustomComposite(tablComposite);
    }

    private void initDisplayView() {
        this.enableViewAndDisableOthers(this.instOptionView);
    }

    private void setCustomComposite(Composite container) {
        this.customComposite = new Composite(container, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_CUSTOM_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, PlatformUtil.isWindows() ? rect.x : rect.x + 4);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width - 4;
        formData.height = rect.height;
        this.customComposite.setLayoutData(formData);
        this.customComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.customComposite.setLayout(this.stackLayout);
        this.instOptionView = new InstallOptionConfigView(this.customComposite, this.uiRsrcHandler, this);
        this.viewLists.add(this.instOptionView);
    }

    private void setBottomComposite(Composite container) {
        this.bottomComposite = new Composite(container, 0);
        final Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_BOTTOM_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, 0);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width;
        formData.height = rect.height;
        this.bottomComposite.setLayoutData(formData);
        this.bottomComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.bottomComposite.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ConfigurationDialog.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                e.gc.drawLine(0, 0, rect.width, 0);
            }
        });
        this.setBottomButton(this.bottomComposite);
    }

    private void setBottomButton(Composite container) {
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        gridLayout.marginWidth = 0;
        container.setLayout(gridLayout);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_BUTTON_SIZE);
        this.btnProxySettings = new Button(container, 8);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width + 30;
        this.btnProxySettings.setLayoutData(gd);
        this.btnProxySettings.setText("Proxy settings");
        this.btnProxySettings.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnProxySettings.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnProxySettings.addSelectionListener(new SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ProxyConfigView proxyview = new ProxyConfigView(ConfigurationDialog.this.newContentProvider.getConfig(), ConfigurationDialog.this.thisShell, ConfigurationDialog.this.thisDialog);
                ConfigurationDialog.this.thisShell.setEnabled(false);
                try {
                    proxyview.open();
                }
                catch (Exception e) {
                    logger.throwing(e);
                }
                finally {
                    if (!ConfigurationDialog.this.thisShell.isDisposed()) {
                        ConfigurationDialog.this.thisShell.setEnabled(true);
                    }
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label dummy = new Label(container, 64);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rect.x;
        gd.verticalIndent = 3;
        FormData parentForm = (FormData)container.getLayoutData();
        gd.heightHint = parentForm.height;
        dummy.setLayoutData(gd);
        dummy.setText("");
        dummy.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        dummy.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
        dummy.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnConfirm = new Button(container, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width;
        this.btnConfirm.setLayoutData(gd);
        this.btnConfirm.setText("OK");
        this.btnConfirm.setFocus();
        this.btnConfirm.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnConfirm.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnConfirm.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ConfigurationDialog.this.instOptionView.onClickConfirm();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.btnCancel = new Button(container, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width;
        this.btnCancel.setLayoutData(gd);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnCancel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnCancel.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ConfigurationDialog.this.cancelPressed();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void enableViewAndDisableOthers(Composite exceptView) {
        this.stackLayout.topControl = exceptView;
        for (Composite item : this.viewLists) {
            logger.trace("enableViewAndDisableOthers : " + item.getClass().getName());
            if (item.equals(exceptView)) continue;
            item.setEnabled(false);
            item.setVisible(false);
            logger.trace("enableViewAndDisableOthers (set false) : " + item.getClass().getName());
        }
        exceptView.setVisible(true);
        exceptView.setEnabled(true);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public String getOriginRepo() {
        return this.originRepo;
    }

    public void setOriginRepo(String originRepo) {
        this.originRepo = originRepo;
    }

    public String getDistributionId() {
        return this.distributionId;
    }

    public void setDistributionId(String distributionId) {
        this.distributionId = distributionId;
    }

    public boolean isFileDialogOpened() {
        return this.isFileDialogOpened;
    }

    public void setFileDialogOpened(boolean isFileDialogOpened) {
        this.isFileDialogOpened = isFileDialogOpened;
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        if (!this.isFileDialogOpened()) {
            return super.canHandleShellCloseEvent();
        }
        return false;
    }

    public Button getConfirmButton() {
        return this.btnConfirm;
    }

    public Label getErrerLabel() {
        return this.labelError;
    }

    public void refreshInstallOption() {
        if (this.instOptionView != null && !this.instOptionView.isDisposed()) {
            this.instOptionView.refreshRepository();
        }
    }

    public ContentProvider getOrgContentProvider() {
        return this.contentProvider;
    }

    public ContentProvider getNewContentProvider() {
        return this.newContentProvider;
    }
}

