/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.filter.InstalledComponentFilter;
import org.tizen.packagemanager.ui.page.filter.ProfileTypeFilter;
import org.tizen.packagemanager.ui.page.filter.RemoveExtraComponentFilter;

public class MainTreeView
extends CommonTreeView {
    InstalledComponentFilter installedFilter = null;
    ProfileTypeFilter profileTypeFilter = new ProfileTypeFilter();
    private static final Logger logger = Log.getLogger(MainTreeView.class);

    MainTreeView(ContentProvider contentProvider, ViewController viewController, Composite parent) {
        super(contentProvider, viewController, parent, 0, logger);
        Package.ProfileType[] values;
        for (Package.ProfileType profileType : values = Package.ProfileType.values()) {
            this.profileTypeFilter.showProfile(profileType, contentProvider.getCompMgr().getFilteredProfile().contains((Object)profileType));
        }
        this.treeViewer.addFilter(this.profileTypeFilter);
        this.installedFilter = new InstalledComponentFilter();
        this.treeViewer.addFilter(this.installedFilter);
    }

    @Override
    public void showInstalledComponents(boolean isShow) {
        if (isShow) {
            this.treeViewer.removeFilter(this.installedFilter);
            this.treeViewer.addFilter(this.installedFilter);
            this.treeViewer.expandAll();
        } else {
            this.treeViewer.collapseAll();
            this.treeViewer.removeFilter(this.installedFilter);
        }
        super.showInstalledComponents(isShow);
    }

    @Override
    public void showProfile(Package.ProfileType type, boolean isShow) {
        this.profileTypeFilter.showProfile(type, isShow);
        this.contentProvider.getCompMgr().setFilteredProfile(type, isShow);
        this.treeViewer.collapseAll();
        this.treeViewer.refresh();
        super.showProfile(type, isShow);
    }

    @Override
    public void removeExtraComponents() {
        this.treeViewer.addFilter(new RemoveExtraComponentFilter());
    }
}

