/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.AccessLog;
import org.tizen.packagemanager.ui.AnalyticConfig;
import org.tizen.packagemanager.ui.UsageLog;

public class RemoteLogger {
    private static final Logger logger = Log.getLogger(RemoteLogger.class);
    private static final String DEFAULT_VERSION = "Default";
    private static final String LOGGING_URL = "https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1";
    private static final String ANALYTICS_CONFIG_FILE = "analytics.conf";
    private static final String DIR_IDE = "ide";

    private static AnalyticConfig parseConfig(Path filePath) {
        File f = new File(filePath.toString());
        AnalyticConfig config = new AnalyticConfig("", false);
        if (f.exists()) {
            Gson gson = new Gson();
            try (BufferedReader reader = Files.newBufferedReader(filePath);){
                AnalyticConfig data = gson.fromJson((Reader)reader, AnalyticConfig.class);
                if (data != null && data.id != null && data.logging != null) {
                    config.id = data.id;
                    config.logging = data.logging;
                }
            }
            catch (IOException e) {
                return config;
            }
        }
        return config;
    }

    public static Boolean isLoggingEnabled() {
        return RemoteLogger.getAnalyticsConf().logging;
    }

    public static void writeLoggingInfoToFile(Boolean log) {
        RemoteLogger.writeAnalyticsConf(RemoteLogger.getAnalyticsConf().id, log);
    }

    private static AnalyticConfig writeAnalyticsConf(String uuid, Boolean log) {
        Path filePath = Paths.get(RemoteLogger.getAnalyticsConfig(), new String[0]);
        File f = new File(filePath.toString());
        f.delete();
        AnalyticConfig config = new AnalyticConfig(uuid, log);
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(filePath.toString());){
            gson.toJson((Object)config, (Appendable)writer);
            ((Writer)writer).flush();
        }
        catch (JsonIOException | IOException e) {
            e.printStackTrace();
            return config;
        }
        return config;
    }

    public static String getIdeUserDataPath() {
        SDKInfo sdkInfoObj = new SDKInfo();
        String sdkDataPath = sdkInfoObj.getSdkDataPath();
        return sdkDataPath + File.separator + DIR_IDE;
    }

    public static String getAnalyticsConfig() {
        String dataPath = RemoteLogger.getIdeUserDataPath();
        File f = new File(dataPath);
        if (!f.exists()) {
            f.mkdirs();
        }
        Path filePath = Paths.get(dataPath, ANALYTICS_CONFIG_FILE);
        return filePath.toString();
    }

    private static AnalyticConfig getAnalyticsConf() {
        Path filePath = Paths.get(RemoteLogger.getAnalyticsConfig(), new String[0]);
        File f = new File(filePath.toString());
        AnalyticConfig config = RemoteLogger.parseConfig(filePath);
        if (config.id.isEmpty()) {
            f.delete();
            String id2 = UUID.randomUUID().toString().replaceAll("-", "");
            return RemoteLogger.writeAnalyticsConf(id2, true);
        }
        return config;
    }

    private static void postUsage(UsageLog log) throws IOException {
        URL url = new URL("https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1/postusage");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        Gson gson = new Gson();
        String json = gson.toJson(log);
        OutputStream os = conn.getOutputStream();
        os.write(json.getBytes("UTF-8"));
        os.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String result = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        logger.info(result);
    }

    private static void postAccess(AccessLog log) throws IOException {
        URL url = new URL("https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1/postaccess");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        Gson gson = new Gson();
        String json = gson.toJson(log);
        OutputStream os = conn.getOutputStream();
        os.write(json.getBytes("UTF-8"));
        os.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String result = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        logger.info(result);
    }

    public static void logAccess(String product) {
        AnalyticConfig conf = RemoteLogger.getAnalyticsConf();
        String uuid = conf.id;
        if (uuid.isEmpty()) {
            logger.info("Failed to generate UUID");
            return;
        }
        if (!conf.logging.booleanValue()) {
            logger.info("Logging is disabled by user");
            return;
        }
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timestamp = fmt.format(now);
        AccessLog log = new AccessLog();
        log.id = uuid;
        log.type = "access";
        log.product = product;
        log.timestamp = timestamp;
        try {
            log.version = RemoteLogger.getVersion();
        }
        catch (IOException e) {
            logger.info("Failed to get version");
            log.version = DEFAULT_VERSION;
        }
        try {
            RemoteLogger.postAccess(log);
        }
        catch (IOException e) {
            logger.info("Post Request failed");
        }
    }

    public static void logUsage(String product, long usage) {
        AnalyticConfig conf = RemoteLogger.getAnalyticsConf();
        String uuid = conf.id;
        if (uuid.isEmpty()) {
            logger.info("Failed to generate UUID");
            return;
        }
        if (!conf.logging.booleanValue()) {
            logger.info("Logging is disabled by user");
            return;
        }
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timestamp = fmt.format(now);
        UsageLog log = new UsageLog();
        log.id = uuid;
        log.type = "usage";
        log.product = product;
        log.timestamp = timestamp;
        log.usage = usage;
        try {
            log.version = RemoteLogger.getVersion();
        }
        catch (IOException e) {
            logger.info("Failed to get version");
            log.version = DEFAULT_VERSION;
        }
        try {
            RemoteLogger.postUsage(log);
        }
        catch (IOException e) {
            logger.info("Post Request failed");
        }
    }

    private static String getVersion() throws IOException {
        SDKInfo sdkInfoObj = new SDKInfo();
        String sdkPath = sdkInfoObj.getInstalledPath();
        Path filePath = Paths.get(sdkPath, "sdk.version");
        byte[] encoded = Files.readAllBytes(Paths.get(filePath.toString(), new String[0]));
        String content = new String(encoded, StandardCharsets.UTF_8);
        String[] data = content.split("=");
        if (data.length < 2) {
            return DEFAULT_VERSION;
        }
        data[1] = data[1].replaceAll("[\\n\\t ]", "");
        return data[1];
    }
}

