/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.svc.sdkutils.PackageInfoJSON;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.packagemanager.cli.CLIUninstallProcessMonitor;
import org.tizen.packagemanager.cli.CLIUninstallProgressMonitor;

class CLIUninstallProcess {
    private Logger logger = null;
    private ContentProvider contentProvider;

    public CLIUninstallProcess(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.logger = Log.getLogger(CLIUninstallProcess.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAllOnConsole(boolean isRefreshServer) throws Exception {
        this.killRunningProcess();
        boolean installResult = true;
        System.out.println("");
        System.out.println("*****************************************");
        System.out.println("**** Start to uninstall Tizen Studio ****");
        System.out.println("*****************************************");
        try {
            this.contentProvider.getInstController().uninstallAll(new CLIUninstallProgressMonitor(), isRefreshServer);
            this.contentProvider.getInstController().removeSDKLegacy(isRefreshServer);
        }
        catch (Exception e) {
            try {
                this.logger.throwing(e);
                System.out.println(e);
                installResult = false;
                this.contentProvider.getInstController().removeSDKLegacy(isRefreshServer);
            }
            catch (Throwable throwable) {
                this.contentProvider.getInstController().removeSDKLegacy(isRefreshServer);
                this.contentProvider.getInstController().removeSDKLegacyCLI(isRefreshServer);
                System.out.println("Uninstall has been completed");
                PackageInfoJSON.removeAllCaches(this.contentProvider.getSDKInfo());
                if (!isRefreshServer && PlatformUtil.isWindows()) {
                    String format = "Couldn't delete \"%s\" because of the directory open in console.%nPlease delete directory \"%s\" manually.";
                    String removePath = this.contentProvider.getSDKInfo().getInstalledPath();
                    System.out.println(String.format(format, removePath, removePath));
                }
                throw throwable;
            }
            this.contentProvider.getInstController().removeSDKLegacyCLI(isRefreshServer);
            System.out.println("Uninstall has been completed");
            PackageInfoJSON.removeAllCaches(this.contentProvider.getSDKInfo());
            if (!isRefreshServer && PlatformUtil.isWindows()) {
                String format = "Couldn't delete \"%s\" because of the directory open in console.%nPlease delete directory \"%s\" manually.";
                String removePath = this.contentProvider.getSDKInfo().getInstalledPath();
                System.out.println(String.format(format, removePath, removePath));
            }
        }
        this.contentProvider.getInstController().removeSDKLegacyCLI(isRefreshServer);
        System.out.println("Uninstall has been completed");
        PackageInfoJSON.removeAllCaches(this.contentProvider.getSDKInfo());
        if (!isRefreshServer && PlatformUtil.isWindows()) {
            String format = "Couldn't delete \"%s\" because of the directory open in console.%nPlease delete directory \"%s\" manually.";
            String removePath = this.contentProvider.getSDKInfo().getInstalledPath();
            System.out.println(String.format(format, removePath, removePath));
        }
        return installResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeOnConsole(List<String> packageNames) throws Exception {
        this.killRunningProcess();
        boolean installResult = true;
        System.out.println("");
        System.out.println("*****************************************");
        System.out.println("****** Start to uninstall packages ******");
        System.out.println("*****************************************");
        try {
            List<Component> componentList = this.contentProvider.getCompMgr().getComponentList();
            ArrayList<Component> removeComponenetList = new ArrayList<Component>();
            block6: for (String pkgName : packageNames) {
                for (Component component : componentList) {
                    if (!component.getPackageName().equals(pkgName) || component.getInstallState() == Component.InstallState.INSTALL) continue;
                    removeComponenetList.add(component);
                    continue block6;
                }
            }
            if (removeComponenetList.isEmpty()) {
                System.out.println("Nothing to uninstall.");
                boolean bl = true;
                return bl;
            }
            for (Component component : removeComponenetList) {
                if (!component.hasChildren()) {
                    this.startToUninstallSingleTreeItem(component);
                    continue;
                }
                this.startToUninstallAllSubTreeItem(component);
            }
        }
        catch (Exception e) {
            this.logger.throwing(e);
            System.out.println(e);
            installResult = false;
        }
        finally {
            if (!installResult) {
                throw new Exception("Uninstall has been failed.");
            }
            System.out.println("Uninstall has been completed");
        }
        return installResult;
    }

    private void startToUninstallSingleTreeItem(Component component) throws UMException {
        ArrayList<Component> selGroupComps = this.contentProvider.getCompMgr().getSelectGroupComponentsToUninstall(component);
        if (!selGroupComps.isEmpty()) {
            StringBuilder strCompNames = new StringBuilder("");
            for (Component comp : selGroupComps) {
                if (strCompNames.length() > 0) {
                    strCompNames.append(", ");
                }
                strCompNames.append("'").append(comp.getDisplayName()).append("'");
            }
        }
        this.createUninstallProcess(component, selGroupComps);
    }

    private void startToUninstallAllSubTreeItem(Component component) throws UMException {
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component component2 : component.getLeafDecendents()) {
            if (targetComponents.contains(component2) || component2.getInstallState() != Component.InstallState.UNINSTALL && component2.getInstallState() != Component.InstallState.UPDATE) continue;
            targetComponents.add(component2);
        }
        if (targetComponents.isEmpty()) {
            return;
        }
        ArrayList<Component> tempComponents = new ArrayList<Component>();
        for (Component component3 : targetComponents) {
            ArrayList<Component> selGroupComps = this.contentProvider.getCompMgr().getSelectGroupComponentsToUninstall(component3);
            for (Component selComp : selGroupComps) {
                if (tempComponents.contains(selComp)) continue;
                tempComponents.add(selComp);
            }
            if (tempComponents.contains(component3)) continue;
            tempComponents.add(component3);
        }
        ArrayList<Component> arrayList = ComponentManager.getSortedComponentsByInstallOrder(tempComponents);
        Collections.reverse(arrayList);
        this.createGroupUninstallProcess(arrayList);
    }

    private void createUninstallProcess(Component component, ArrayList<Component> selGroupComps) throws UMException {
        ArrayList<Component> dependentComps = new ArrayList<Component>();
        dependentComps.addAll(selGroupComps);
        component.setDependentComponents(dependentComps);
        ArrayList<Component> sortedDepComps = ComponentManager.getSortedComponentsByInstallOrder(component.getDependentComponents());
        Collections.reverse(sortedDepComps);
        sortedDepComps.add(component);
        for (Component removeComponent : sortedDepComps) {
            if (removeComponent.getInstallState() == Component.InstallState.INSTALL) continue;
            CLIUninstallProcessMonitor monitor = new CLIUninstallProcessMonitor(removeComponent);
            this.contentProvider.getInstController().addComponentToProcessQueue(removeComponent, monitor);
            this.contentProvider.getInstController().uninstall(removeComponent, false, monitor);
            removeComponent.setInstallState(Component.InstallState.INSTALL);
            monitor.done();
        }
    }

    private void createGroupUninstallProcess(ArrayList<Component> components) throws UMException {
        for (Component removeComponent : components) {
            if (removeComponent.getInstallState() == Component.InstallState.INSTALL) continue;
            CLIUninstallProcessMonitor monitor = new CLIUninstallProcessMonitor(removeComponent);
            this.contentProvider.getInstController().addComponentToProcessQueue(removeComponent, monitor);
            this.contentProvider.getInstController().uninstall(removeComponent, false, monitor);
            removeComponent.setInstallState(Component.InstallState.INSTALL);
            monitor.done();
        }
    }

    private void killRunningProcess() throws Exception {
        ProgramController controller = ProgramController.createProgramController(this.contentProvider.getSDKInfo());
        List<String> sdkProcessList = controller.getSDKProcessList();
        if (sdkProcessList != null && sdkProcessList.size() > 0) {
            StringBuilder msg = new StringBuilder("");
            for (String processString : sdkProcessList) {
                msg.append("\t").append(processString).append("\n");
            }
            throw new Exception(String.format("Tizen Studio programs are running under installed location.%n%sClose the running programs.", msg.toString()));
        }
    }
}

