/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    long defaultCursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 0x100) != 0) {
            n4 += 64;
            n5 += 3;
        } else {
            n4 += 3;
            n5 += 64;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        int n2 = (this.style & 0x200) != 0 ? 108 : 116;
        this.defaultCursor = OS.gdk_cursor_new(n2);
    }

    void drawBand(int n, int n2, int n3, int n4) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        long l = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        if (l == 0L) {
            return;
        }
        byte[] byArray = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        long l2 = OS.gdk_bitmap_create_from_data(l, byArray, 8, 8);
        long l3 = OS.gdk_gc_new(l);
        long l4 = OS.gdk_colormap_get_system();
        GdkColor gdkColor = new GdkColor();
        OS.gdk_color_white(l4, gdkColor);
        OS.gdk_gc_set_foreground(l3, gdkColor);
        OS.gdk_gc_set_stipple(l3, l2);
        OS.gdk_gc_set_subwindow(l3, 1L);
        OS.gdk_gc_set_fill(l3, 2);
        OS.gdk_gc_set_function(l3, 2L);
        OS.gdk_draw_rectangle(l, l3, 1, n, n2, n3, n4);
        OS.g_object_unref(l2);
        OS.g_object_unref(l3);
    }

    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        int n = gdkEventButton.button;
        if (n != 1) {
            return 0L;
        }
        if (gdkEventButton.type == 5) {
            return 0L;
        }
        if (gdkEventButton.type == 6) {
            return 0L;
        }
        long l4 = OS.GTK_WIDGET_WINDOW(l);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l4, nArray, nArray2);
        this.startX = (int)(gdkEventButton.x_root - (double)nArray[0]);
        this.startY = (int)(gdkEventButton.y_root - (double)nArray2[0]);
        int n2 = OS.GTK_WIDGET_X(this.handle);
        int n3 = OS.GTK_WIDGET_Y(this.handle);
        int n4 = OS.GTK_WIDGET_WIDTH(this.handle);
        int n5 = OS.GTK_WIDGET_HEIGHT(this.handle);
        this.lastX = n2;
        this.lastY = n3;
        Event event = new Event();
        event.time = gdkEventButton.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n4;
        event.height = n5;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - n4 - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0L;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - n4 - this.lastX;
            }
            this.parent.update(true, (this.style & 0x10000) == 0);
            this.drawBand(this.lastX, event.y, n4, n5);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, n4, n5);
            }
        }
        return l3;
    }

    long gtk_button_release_event(long l, long l2) {
        long l3 = super.gtk_button_release_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        int n = gdkEventButton.button;
        if (n != 1) {
            return 0L;
        }
        if (!this.dragging) {
            return 0L;
        }
        this.dragging = false;
        int n2 = OS.GTK_WIDGET_WIDTH(this.handle);
        int n3 = OS.GTK_WIDGET_HEIGHT(this.handle);
        Event event = new Event();
        event.time = gdkEventButton.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n2;
        event.height = n3;
        this.drawBand(this.lastX, this.lastY, n2, n3);
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - n2 - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return l3;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, n2, n3);
        }
        return l3;
    }

    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if (this.handle != 0L) {
            this.lastX = OS.GTK_WIDGET_X(this.handle);
            this.lastY = OS.GTK_WIDGET_Y(this.handle);
        }
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int n2 = 0;
                int n3 = 0;
                int n4 = 9;
                if ((gdkEventKey.state & 4) != 0) {
                    n4 = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (n == 65362 || n == 65364) break;
                    n2 = n == 65361 ? -n4 : n4;
                } else {
                    if (n == 65361 || n == 65363) break;
                    n3 = n == 65362 ? -n4 : n4;
                }
                int n5 = OS.GTK_WIDGET_WIDTH(this.handle);
                int n6 = OS.GTK_WIDGET_HEIGHT(this.handle);
                int n7 = 0;
                int n8 = OS.GTK_WIDGET_WIDTH(this.parent.handle);
                int n9 = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
                int n10 = this.lastX;
                int n11 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n10 = Math.min(Math.max(0, this.lastX + n2 - n7 - this.startX), n8 - n5);
                } else {
                    n11 = Math.min(Math.max(0, this.lastY + n3 - n7 - this.startY), n9 - n6);
                }
                if (n10 == this.lastX && n11 == this.lastY) {
                    return l3;
                }
                long l4 = OS.GTK_WIDGET_WINDOW(this.handle);
                int n12 = 516;
                long l5 = this.cursor != null ? this.cursor.handle : this.defaultCursor;
                int n13 = OS.gdk_pointer_grab(l4, false, n12, l4, l5, 0);
                Event event = new Event();
                event.time = gdkEventKey.time;
                event.x = n10;
                event.y = n11;
                event.width = n5;
                event.height = n6;
                if ((this.parent.style & 0x8000000) != 0) {
                    event.x = this.parent.getClientWidth() - n5 - event.x;
                }
                this.sendSelectionEvent(13, event, true);
                if (n13 == 0) {
                    OS.gdk_pointer_ungrab(0);
                }
                if (this.isDisposed() || !event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - n5 - this.lastX;
                }
                if ((this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, n5, n6);
                    if (this.isDisposed()) break;
                }
                int n14 = event.x;
                int n15 = event.y;
                if ((this.style & 0x200) != 0) {
                    n15 += n6 / 2;
                } else {
                    n14 += n5 / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(n14, n15));
            }
        }
        return l3;
    }

    long gtk_motion_notify_event(long l, long l2) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2;
        long l3 = super.gtk_motion_notify_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if (!this.dragging) {
            return 0L;
        }
        GdkEventMotion gdkEventMotion = new GdkEventMotion();
        OS.memmove(gdkEventMotion, l2, (long)GdkEventButton.sizeof);
        if (gdkEventMotion.is_hint != 0) {
            nArray2 = new int[1];
            nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gdk_window_get_pointer(gdkEventMotion.window, nArray2, nArray, nArray3);
            n3 = nArray2[0];
            n2 = nArray[0];
            n = nArray3[0];
        } else {
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(gdkEventMotion.window, nArray2, nArray);
            n3 = (int)(gdkEventMotion.x_root - (double)nArray2[0]);
            n2 = (int)(gdkEventMotion.y_root - (double)nArray[0]);
            n = gdkEventMotion.state;
        }
        if ((n & 0x100) == 0) {
            return 0L;
        }
        int n4 = OS.GTK_WIDGET_X(this.handle);
        int n5 = OS.GTK_WIDGET_Y(this.handle);
        int n6 = OS.GTK_WIDGET_WIDTH(this.handle);
        int n7 = OS.GTK_WIDGET_HEIGHT(this.handle);
        int n8 = 0;
        int n9 = OS.GTK_WIDGET_WIDTH(this.parent.handle);
        int n10 = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
        int n11 = this.lastX;
        int n12 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n11 = Math.min(Math.max(0, n3 + n4 - this.startX - n8), n9 - n6);
        } else {
            n12 = Math.min(Math.max(0, n2 + n5 - this.startY - n8), n10 - n7);
        }
        if (n11 == this.lastX && n12 == this.lastY) {
            return 0L;
        }
        this.drawBand(this.lastX, this.lastY, n6, n7);
        Event event = new Event();
        event.time = gdkEventMotion.time;
        event.x = n11;
        event.y = n12;
        event.width = n6;
        event.height = n7;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - n6 - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0L;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - n6 - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        this.drawBand(this.lastX, this.lastY, n6, n7);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(event.x, this.lastY, n6, n7);
        }
        return l3;
    }

    long gtk_realize(long l) {
        this.setCursor(this.cursor != null ? this.cursor.handle : 0L);
        return super.gtk_realize(l);
    }

    void hookEvents() {
        super.hookEvents();
        OS.gtk_widget_add_events(this.handle, 8);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0L) {
            OS.gdk_cursor_unref(this.defaultCursor);
        }
        this.defaultCursor = 0L;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void setCursor(long l) {
        super.setCursor(l != 0L ? l : this.defaultCursor);
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        return 0;
    }
}

