/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;

public class ShellUtil {
    private static final Logger logger = Log.getLogger(ShellUtil.class);

    private ShellUtil() {
    }

    public static int execute(String[] command) throws IMShellCommandFail {
        return ShellUtil.execute(command, null, null, new ShellParser(), null);
    }

    public static int execute(String[] command, ShellParser parser) throws IMShellCommandFail {
        return ShellUtil.execute(command, null, null, parser, null);
    }

    public static int execute(String[] command, SDKInfo sdkInfo, InstallController instController, ShellParser parser) throws IMShellCommandFail {
        Map<String, String> env = ShellUtil.setEnvironmentVariable(sdkInfo, instController);
        return ShellUtil.execute(command, env, null, parser, null);
    }

    public static int execute(String[] cmd, Map<String, String> env, File workingDir, ShellParser parser, String packageName) throws IMShellCommandFail {
        String property = System.getProperty("java.home");
        String javahome = property + File.separator + "bin;";
        String path = javahome + System.getenv("Path");
        ProcessBuilder pb = new ProcessBuilder(cmd);
        int exitCode = 0;
        if (env != null) {
            Map<String, String> pbEnv = pb.environment();
            pbEnv.putAll(env);
        }
        if (workingDir != null) {
            pb.directory(workingDir);
        }
        Process proc = null;
        try {
            proc = pb.start();
            if (parser != null) {
                parser.runParsing(proc, packageName);
            }
            exitCode = proc.waitFor();
            if (parser != null) {
                parser.setExitCode(exitCode);
            }
            int n = exitCode;
            return n;
        }
        catch (IOException e) {
            logger.trace("\tCommand exit code => " + exitCode);
            logger.error("Command exec error => " + Arrays.toString(cmd));
            throw new IMShellCommandFail();
        }
        catch (InterruptedException e) {
            logger.trace("\tCommand exit code => " + exitCode);
            logger.error("Command exec error => " + Arrays.toString(cmd));
            throw new IMShellCommandFail();
        }
        catch (Exception e) {
            logger.trace("\tCommand exit code => " + exitCode);
            logger.error("Command exec error => " + Arrays.toString(cmd));
            throw new IMShellCommandFail();
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    private static String[] addInterpreter2(String scriptFilePath) {
        String extension = PathUtil.getFileExtension(scriptFilePath);
        ArrayList<String> listCommand = new ArrayList<String>();
        if (extension.equalsIgnoreCase(".vbs")) {
            listCommand.add("wscript.exe");
            listCommand.add(scriptFilePath);
        } else if (extension.equalsIgnoreCase(".bat") || extension.equalsIgnoreCase(".exe")) {
            listCommand.add("cmd.exe");
            listCommand.add("/C");
            listCommand.add(scriptFilePath);
        } else if (extension.equalsIgnoreCase(".app")) {
            listCommand.add("open");
            listCommand.add("-a");
            listCommand.add(scriptFilePath);
        } else {
            listCommand.add(scriptFilePath);
        }
        String[] command = new String[listCommand.size()];
        for (int i = 0; i < listCommand.size(); ++i) {
            command[i] = (String)listCommand.get(i);
        }
        return command;
    }

    public static boolean executeScript(SDKInfo sdkInfo, InstallController instController, File scriptFile, String packageName, ShellParser parser) throws IMShellCommandFail, UMException {
        logger.info("Execute script starts...");
        scriptFile.setExecutable(true);
        Map<String, String> env = ShellUtil.setEnvironmentVariable(sdkInfo, instController);
        String[] command = PlatformUtil.isWindows() ? ShellUtil.addInterpreter2(scriptFile.getName()) : ShellUtil.addInterpreter2(scriptFile.getAbsolutePath());
        String current = scriptFile.getParent();
        logger.trace("\tCurrent working directory. => " + current);
        int exitCode = ShellUtil.execute(command, env, new File(current), parser, packageName);
        if (exitCode == 0) {
            return true;
        }
        if (exitCode == 1 || exitCode == 2) {
            logger.error("Exit code => " + Integer.toString(exitCode));
            return false;
        }
        if (exitCode == 99) {
            ErrorController.setInfoCode(ErrorController.InfoCode.RESTART_THE_COMPUTER);
            logger.trace("\tSet restart message.");
            return true;
        }
        logger.error("Installer.executeScript() install script error => " + scriptFile.getAbsolutePath());
        logger.error("Exit code => " + Integer.toString(exitCode));
        throw new UMException(ErrorController.ErrorCode.SCRIPT_FAILED_BY_ERROR, "Exit Code: " + Integer.toString(exitCode));
    }

    private static Map<String, String> setEnvironmentVariable(SDKInfo sdkInfo, InstallController instController) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("INSTALLED_PATH", sdkInfo.getInstalledPath());
        env.put("SDK_DATA_PATH", sdkInfo.getSdkDataPath());
        env.put("USER_DATA_PATH", sdkInfo.getSdkDataPath());
        env.put("MAKESHORTCUT_PATH", instController.getMakeShortCutPath());
        env.put("REMOVE_SHORTCUT", instController.getRemoveShortCutPath());
        env.put("TSUDO", instController.getTSudoPath());
        String dirName = sdkInfo.getInstalledPath();
        if (dirName != null) {
            dirName = dirName.substring(dirName.lastIndexOf("/") + 1);
            env.put("INSTALLED_DIR_NAME", dirName);
        }
        env.put("INSTALLMANAGER_UI", "GUI");
        if (instController.getUserPassword() != null) {
            env.put("INTERACTIVE", "false");
            env.put("SUPASS", instController.getUserPassword());
        } else {
            env.put("INTERACTIVE", "true");
        }
        return env;
    }
}

