/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.provider.progresstab;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.Package;
import org.tizen.packagemanager.ui.page.ProgressItem;
import org.tizen.packagemanager.ui.page.ProgressTableView;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ProgressNameColumnLabelProvider
extends OwnerDrawLabelProvider {
    private ProgressTableView parentView;
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private Image profileMobileImgSelect;
    private Image profileTVImgSelect;
    private Image profileWearableImgSelect;
    private Image profileRTImgSelect;
    private Image profileTizenHeadedImgSelect;
    private Image profileToolImgSelect;
    private Image profileMobileImgDisable;
    private Image profileTVImgDisable;
    private Image profileWearableImgDisable;
    private Image profileRTImgDisable;
    private Image profileTizenHeadedImgDisable;
    private Image profileToolImgDisable;
    private Font treeTextFont;
    private Color activeColor;
    private Color inactiveColor;
    private Color activeTextColor;
    private Color inactiveTextColor;
    private Color selectBgColor;

    public ProgressNameColumnLabelProvider(ProgressTableView parent) {
        this.parentView = parent;
        assert (this.parentView != null);
        this.profileMobileImgSelect = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_SELECT);
        this.profileTVImgSelect = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_SELECT);
        this.profileWearableImgSelect = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_SELECT);
        this.profileRTImgSelect = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_RT_SELECT);
        this.profileTizenHeadedImgSelect = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TIZENHEADED_SELECT);
        this.profileToolImgSelect = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_SELECT);
        this.profileMobileImgDisable = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_NORMAL);
        this.profileTVImgDisable = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_NORMAL);
        this.profileWearableImgDisable = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_NORMAL);
        this.profileRTImgDisable = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_RT_NORMAL);
        this.profileTizenHeadedImgDisable = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TIZENHEADED_NORMAL);
        this.profileToolImgDisable = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_NORMAL);
        this.treeTextFont = this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0);
        this.activeColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_PROGRESS_BG_ACTIVE);
        this.inactiveColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.activeTextColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58);
        this.inactiveTextColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_PROGRESS_TEXT_INACTIVE);
        this.selectBgColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_SKY_BLUE);
    }

    @Override
    protected void erase(Event event, Object element) {
        ProgressItem progressItem = (ProgressItem)element;
        TableItem item = (TableItem)event.item;
        Color oldBackground = event.gc.getBackground();
        if (progressItem.isActive()) {
            event.gc.setBackground(this.activeColor);
        } else {
            event.gc.setBackground(this.inactiveColor);
        }
        if ((event.detail & 2) != 0) {
            event.gc.setBackground(this.selectBgColor);
            event.detail &= 0xFFFFFFFD;
        }
        if (item != null && item.getData("isSelect") != null && ((Boolean)item.getData("isSelect")).booleanValue()) {
            event.gc.setBackground(this.selectBgColor);
        }
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    @Override
    protected void measure(Event event, Object element) {
        Rectangle nameBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_NAME);
        event.height = nameBounds.height;
    }

    @Override
    protected void paint(Event event, Object element) {
        ProgressItem progressItem = (ProgressItem)element;
        Rectangle nameMarginBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_MARGIN_NAME);
        Image targetImage = this.getComponentTypeImage(progressItem, event);
        Component component = progressItem.getComponent();
        Package topPkg = component.getRootComponent().getRecentPackage();
        String displayName = component.getDisplayName();
        if (topPkg != null && !topPkg.getLabel().equals("") && !topPkg.getLabel().equals(component.getDisplayName())) {
            displayName = topPkg.getLabel() + " - " + component.getDisplayName();
        }
        int imgOffsetY = (event.getBounds().height - targetImage.getBounds().height) / 2;
        int leftMargin = nameMarginBounds.x - nameMarginBounds.y;
        event.gc.drawImage(targetImage, event.getBounds().x + leftMargin, event.getBounds().y + imgOffsetY);
        event.gc.setFont(this.treeTextFont);
        if (progressItem.isActive()) {
            event.gc.setForeground(this.activeTextColor);
        } else {
            event.gc.setForeground(this.inactiveTextColor);
        }
        int textOffsetY = (event.getBounds().height - event.gc.textExtent((String)displayName).y) / 2;
        int textOffmarginX = nameMarginBounds.width;
        event.gc.drawText(displayName, event.getBounds().x + leftMargin + targetImage.getBounds().width + textOffmarginX, event.getBounds().y + textOffsetY, true);
    }

    private Image getComponentTypeImage(ProgressItem progressItem, Event event) {
        Image retImage = null;
        Component component = progressItem.getComponent();
        Component rootComponent = component.getRootComponent();
        boolean isSelect = false;
        TableItem item = (TableItem)event.item;
        TableItem[] selectItems = this.parentView.getTable().getSelection();
        if (selectItems != null && selectItems.length > 0 && item != null && selectItems[0].equals(item)) {
            isSelect = true;
        }
        if (item != null && item.getData("isSelect") != null && ((Boolean)item.getData("isSelect")).booleanValue()) {
            isSelect = true;
        }
        retImage = rootComponent.getProfileType() == Package.ProfileType.MOBILE ? (isSelect ? this.profileMobileImgSelect : this.profileMobileImgDisable) : (rootComponent.getProfileType() == Package.ProfileType.WEARABLE ? (isSelect ? this.profileWearableImgSelect : this.profileWearableImgDisable) : (rootComponent.getProfileType() == Package.ProfileType.TV ? (isSelect ? this.profileTVImgSelect : this.profileTVImgDisable) : (rootComponent.getProfileType() == Package.ProfileType.RT ? (isSelect ? this.profileRTImgSelect : this.profileRTImgDisable) : (rootComponent.getProfileType() == Package.ProfileType.TIZEN ? (isSelect ? this.profileTizenHeadedImgSelect : this.profileTizenHeadedImgDisable) : (isSelect ? this.profileToolImgSelect : this.profileToolImgDisable)))));
        return retImage;
    }
}

