/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.service;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.tizen.library.sdkutils.api.ISDKUtils;
import org.tizen.library.sdkutils.api.impl.SDKPackage;
import org.tizen.library.sdkutils.api.impl.SDKUtils;
import org.tizen.library.sdkutils.service.PackageService;
import org.tizen.library.sdkutils.util.PathUtil;
import org.tizen.library.sdkutils.util.PlatformUtil;
import org.tizen.library.sdkutils.util.SDKInfoUtil;
import org.tizen.library.sdkutils.util.SDKToolContents;

public class ExecutorService {
    private ExecutorService() {
    }

    public static String getSDKToolPath(ISDKUtils.SdkTool type) {
        String path = null;
        switch (type) {
            case TIZEN_STUDIO: {
                path = SDKToolContents.TIZENSTUDIO_EXECUTABLE_PATH;
                break;
            }
            case PACKAGE_MANAGER: {
                path = PathUtil.getPath(SDKToolContents.PACKAGEMANAGER_EXECUTABLE_PATH, SDKToolContents.PACKAGEMANAGER_EXECUTABLE_NAME);
                break;
            }
            case EMULATOR_MANAGER: {
                path = PathUtil.getPath(SDKToolContents.EMULATORMANAGER_EXECUTABLE_PATH, SDKToolContents.EMULATORMANAGER_EXECUTABLE_NAME);
                break;
            }
            case DYNAMIC_ANALYZER: {
                path = SDKToolContents.DYNAMICANALYZER_EXECUTABLE_PATH;
                break;
            }
            case CERTIFICATE_MANAGER: {
                path = PathUtil.getPath(SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_PATH, SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_NAME);
                break;
            }
            case DEVICE_MANAGER: {
                path = PathUtil.getPath(SDKToolContents.DEVICEMANAGER_EXECUTABLE_PATH, SDKToolContents.DEVICEMANAGER_EXECUTABLE_NAME);
                break;
            }
            case NOTIFICATION_POPUP: {
                path = SDKToolContents.NOTIFICATION_UI_EXECUTABLE_PATH;
            }
        }
        if (path != null) {
            if (path.isEmpty() || path.length() == 0) {
                path = null;
            } else {
                try {
                    File file = new File(path);
                    if (!file.exists()) {
                        path = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    path = null;
                }
            }
        }
        return path;
    }

    public static ISDKUtils.ExecuteResult execute(ISDKUtils.SdkTool type, String args) {
        if (type == null) {
            return ISDKUtils.ExecuteResult.FAIL;
        }
        if (!ExecutorService.checkPackageInstallation(type)) {
            return ISDKUtils.ExecuteResult.NOT_INSTALLED;
        }
        String sdkInstalledPath = SDKInfoUtil.findSDKInstallPath(ExecutorService.class);
        if (sdkInstalledPath == null || sdkInstalledPath.isEmpty()) {
            return ISDKUtils.ExecuteResult.FAIL;
        }
        ISDKUtils.ExecuteResult result = ISDKUtils.ExecuteResult.FAIL;
        String exePath = null;
        ProcessBuilder process = null;
        switch (type) {
            case TIZEN_STUDIO: {
                if (PlatformUtil.isWindows()) {
                    process = new ProcessBuilder("cmd", "/c", SDKToolContents.TIZENSTUDIO_EXECUTABLE_PATH);
                    break;
                }
                if (PlatformUtil.isMacOS()) {
                    process = new ProcessBuilder("open", SDKToolContents.TIZENSTUDIO_EXECUTABLE_PATH);
                    break;
                }
                process = new ProcessBuilder(SDKToolContents.TIZENSTUDIO_EXECUTABLE_PATH);
                break;
            }
            case PACKAGE_MANAGER: {
                exePath = PathUtil.getPath(SDKToolContents.PACKAGEMANAGER_EXECUTABLE_PATH, SDKToolContents.PACKAGEMANAGER_EXECUTABLE_NAME);
                if (PlatformUtil.isWindows()) {
                    process = new ProcessBuilder("cmd", "/c", exePath);
                    break;
                }
                if (PlatformUtil.isMacOS()) {
                    process = new ProcessBuilder("open", exePath);
                    break;
                }
                process = new ProcessBuilder(exePath);
                break;
            }
            case EMULATOR_MANAGER: {
                if (PlatformUtil.isWindows()) {
                    process = new ProcessBuilder("cmd", "/c", SDKToolContents.EMULATORMANAGER_EXECUTABLE_NAME);
                    process.directory(new File(SDKToolContents.EMULATORMANAGER_EXECUTABLE_PATH));
                    break;
                }
                if (PlatformUtil.isMacOS()) {
                    process = new ProcessBuilder("open", PathUtil.getPath(SDKToolContents.EMULATORMANAGER_EXECUTABLE_PATH, SDKToolContents.EMULATORMANAGER_EXECUTABLE_NAME));
                    break;
                }
                process = new ProcessBuilder(PathUtil.getPath(SDKToolContents.EMULATORMANAGER_EXECUTABLE_PATH, SDKToolContents.EMULATORMANAGER_EXECUTABLE_NAME));
                break;
            }
            case DYNAMIC_ANALYZER: {
                if (PlatformUtil.isWindows()) {
                    process = new ProcessBuilder("cmd", "/c", SDKToolContents.DYNAMICANALYZER_EXECUTABLE_PATH);
                    break;
                }
                if (PlatformUtil.isMacOS()) {
                    process = new ProcessBuilder("open", SDKToolContents.DYNAMICANALYZER_EXECUTABLE_PATH);
                    break;
                }
                process = new ProcessBuilder(SDKToolContents.DYNAMICANALYZER_EXECUTABLE_PATH);
                break;
            }
            case CERTIFICATE_MANAGER: {
                if (PlatformUtil.isWindows()) {
                    process = new ProcessBuilder("cmd", "/c", SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_NAME);
                    process.directory(new File(SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_PATH));
                    break;
                }
                if (PlatformUtil.isMacOS()) {
                    process = new ProcessBuilder("open", PathUtil.getPath(SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_PATH, SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_NAME));
                    break;
                }
                process = new ProcessBuilder(PathUtil.getPath(SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_PATH, SDKToolContents.CERTIFICATEMANAGER_EXECUTABLE_NAME));
                break;
            }
            case DEVICE_MANAGER: {
                if (PlatformUtil.isWindows()) {
                    process = new ProcessBuilder("cmd", "/c", SDKToolContents.DEVICEMANAGER_EXECUTABLE_NAME);
                    process.directory(new File(SDKToolContents.DEVICEMANAGER_EXECUTABLE_PATH));
                    break;
                }
                if (PlatformUtil.isMacOS()) {
                    process = new ProcessBuilder("open", PathUtil.getPath(SDKToolContents.DEVICEMANAGER_EXECUTABLE_PATH, SDKToolContents.DEVICEMANAGER_EXECUTABLE_NAME));
                    break;
                }
                process = new ProcessBuilder(PathUtil.getPath(SDKToolContents.DEVICEMANAGER_EXECUTABLE_PATH, SDKToolContents.DEVICEMANAGER_EXECUTABLE_NAME));
                break;
            }
            case NOTIFICATION_POPUP: {
                String java = SDKUtils.getInstance().getJavaPath();
                process = PlatformUtil.isWindows() ? new ProcessBuilder("cmd", "/c", java, "-jar", SDKToolContents.NOTIFICATION_UI_EXECUTABLE_PATH) : new ProcessBuilder(java, "-jar", SDKToolContents.NOTIFICATION_UI_EXECUTABLE_PATH);
            }
        }
        try {
            if (process != null) {
                process.start();
                result = ISDKUtils.ExecuteResult.SUCCESS;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean checkPackageInstallation(ISDKUtils.SdkTool tool) {
        boolean result = true;
        String pkgName = null;
        switch (tool) {
            case EMULATOR_MANAGER: {
                pkgName = "emulator-manager";
                break;
            }
            case TIZEN_STUDIO: {
                pkgName = "base-ide-product";
                break;
            }
            case DYNAMIC_ANALYZER: {
                pkgName = "dynamic-analyzer-product";
                break;
            }
            case CERTIFICATE_MANAGER: {
                pkgName = "certificate-manager-product";
                break;
            }
            case DEVICE_MANAGER: {
                pkgName = "device-manager-product";
                break;
            }
        }
        if (pkgName != null) {
            SDKPackage pkg;
            Map<String, SDKPackage> pkgMap = PackageService.getSDKPackageInfos(pkgName, true);
            result = pkgMap != null ? (pkg = pkgMap.get(pkgName)) != null && pkg.isInstalled() : false;
        }
        return result;
    }
}

