/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.page.BaseTabView;
import org.tizen.packagemanager.ui.page.CommonTabView;
import org.tizen.packagemanager.ui.page.PackageManagerMainWindow;
import org.tizen.packagemanager.ui.page.ProgressTabView;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ViewController {
    private StackLayout stackLayout;
    private CommonTabView mainView;
    private CommonTabView extendedView;
    private CommonTabView progressView;
    private static final Logger logger = Log.getLogger(ViewController.class);
    private List<CommonTabView> pageLists = new ArrayList<CommonTabView>();
    private boolean isConfigurationDialogOpened = false;
    private PackageManagerMainWindow.TabViewType tv = PackageManagerMainWindow.TabViewType.MAIN;
    private ContentProvider contentProvider;

    public ViewController(ContentProvider contentProvider) {
        WizardUIResourceHandler.getInstance();
        this.contentProvider = contentProvider;
    }

    public void init(PackageManagerMainWindow mainPage, Composite mainComposite, StackLayout stackLayout) {
        logger.trace("Page Master init is called.");
        this.stackLayout = stackLayout;
        this.pageLists = new ArrayList<CommonTabView>();
        this.progressView = new ProgressTabView(this.contentProvider, this, mainPage, mainComposite, 0, this);
        this.pageLists.add(this.progressView);
        this.extendedView = new BaseTabView(this.contentProvider, this, mainPage, mainComposite, 0, this, PackageManagerMainWindow.TabViewType.EXTEND);
        this.pageLists.add(this.extendedView);
        this.mainView = new BaseTabView(this.contentProvider, this, mainPage, mainComposite, 0, this, PackageManagerMainWindow.TabViewType.MAIN);
        this.pageLists.add(this.mainView);
        logger.trace("Page Master init is end.");
    }

    public void reloadPage(boolean isInit) {
        this.mainView.reload(isInit);
        this.extendedView.reload(isInit);
        this.progressView.reload(isInit);
    }

    public void enablePages(PackageManagerMainWindow.TabViewType tabView) {
        this.tv = tabView;
        logger.trace("enablePages start => " + tabView.name());
        switch (tabView) {
            case MAIN: {
                this.enablePageAndDisableOthers(this.mainView);
                this.processPostInstallPackages();
                break;
            }
            case EXTEND: {
                this.enablePageAndDisableOthers(this.extendedView);
                break;
            }
            case PROGRESS: {
                this.enablePageAndDisableOthers(this.progressView);
                break;
            }
        }
        logger.trace("enablePages end => " + tabView.name());
    }

    private void processPostInstallPackages() {
        ArrayList<String> postInstallPackage = this.contentProvider.getInstController().getAutoInstallPackage();
        if (!postInstallPackage.isEmpty()) {
            if (!this.contentProvider.getRepoMgr().isNetworkOK()) {
                ErrorController.setExitCode(ErrorController.ExitCode.NETWORK_ERROR);
                PackageManagerMainWindow.getPackageManagerWindow().getShell().close();
                return;
            }
            int installablePackages = 0;
            List<String> installedPkgNames = this.contentProvider.getPkgMgr().getInstalledPkgNames();
            ArrayList<Component> updatableComponents = this.contentProvider.getCompMgr().getUpdatableComponents();
            for (String pkgName : postInstallPackage) {
                Component componentByName = this.contentProvider.getCompMgr().getComponentByName(pkgName);
                if (componentByName == null || !componentByName.hasInstallableLeafDecendents() && !componentByName.hasUpdatableLeafDecendents() && !updatableComponents.contains(componentByName) && installedPkgNames.contains(pkgName) || this.mainView.getTreeView().onClickInstallButton(componentByName, true) == -1) continue;
                ++installablePackages;
            }
            this.contentProvider.getInstController().clearAutoInstallPackage();
            if (installablePackages > 0) {
                PackageManagerMainWindow.getPackageManagerWindow().tabRedraw(PackageManagerMainWindow.TabViewType.PROGRESS);
                this.enablePages(PackageManagerMainWindow.TabViewType.PROGRESS);
            } else {
                ErrorController.setExitCode(ErrorController.ExitCode.NOTHING_TO_INSTALL);
                PackageManagerMainWindow.getPackageManagerWindow().getShell().close();
                return;
            }
        }
    }

    private void enablePageAndDisableOthers(Composite exceptPages) {
        this.stackLayout.topControl = exceptPages;
        for (Composite composite : this.pageLists) {
            if (composite.equals(exceptPages)) continue;
            composite.setEnabled(false);
            composite.setVisible(false);
        }
        exceptPages.setVisible(true);
        exceptPages.setEnabled(true);
        logger.trace(exceptPages + " ==> enabled");
    }

    public CommonTabView getMainTabView() {
        return this.mainView;
    }

    public CommonTabView getExtendedTabView() {
        return this.extendedView;
    }

    public ProgressTabView getProgressView() {
        return (ProgressTabView)this.progressView;
    }

    public boolean isConfigurationDialogOpened() {
        return this.isConfigurationDialogOpened;
    }

    public void setConfigurationDialogOpened(boolean isDialogOpen) {
        this.isConfigurationDialogOpened = isDialogOpen;
    }

    public PackageManagerMainWindow.TabViewType getCurrent() {
        return this.tv;
    }
}

