/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.linuxtools.valgrind.ui.Messages;
import org.eclipse.linuxtools.valgrind.ui.ValgrindViewPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ValgrindUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.ui";
    public static final String VIEW_ID = "org.eclipse.linuxtools.valgrind.ui.valgrindview";
    public static final String TOOLBAR_LOC_GROUP_ID = "toolbarLocal";
    public static final String TOOLBAR_EXT_GROUP_ID = "toolbarExtensions";
    public static final String TOOL_EXT_ID = "valgrindToolViews";
    protected static final String EXT_ELEMENT = "view";
    protected static final String EXT_ATTR_ID = "definitionId";
    protected static final String EXT_ATTR_CLASS = "class";
    protected HashMap<String, IConfigurationElement> toolMap;
    private static ValgrindUIPlugin plugin;
    protected ValgrindViewPart view;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static ValgrindUIPlugin getDefault() {
        return plugin;
    }

    public void createView(final String string, final String string2) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    iWorkbenchPage.showView(ValgrindUIPlugin.VIEW_ID);
                    ValgrindUIPlugin.this.view.createDynamicContent(string, string2);
                    ValgrindUIPlugin.this.view.refreshView();
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
        });
    }

    public void refreshView() {
        if (this.view != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ValgrindUIPlugin.this.view.refreshView();
                }
            });
        }
    }

    protected void setView(ValgrindViewPart valgrindViewPart) {
        this.view = valgrindViewPart;
    }

    public ValgrindViewPart getView() {
        return this.view;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = ValgrindUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    protected void initializeToolMap() {
        this.toolMap = new HashMap();
        if (Platform.getExtensionRegistry() == null) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, TOOL_EXT_ID);
        if (iExtensionPoint == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        if (iConfigurationElementArray != null) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                if (iConfigurationElement.getName() != null && iConfigurationElement.getName().equals(EXT_ELEMENT) && (string = iConfigurationElement.getAttribute(EXT_ATTR_ID)) != null && iConfigurationElement.getAttribute(EXT_ATTR_CLASS) != null) {
                    this.toolMap.put(string, iConfigurationElement);
                }
                ++n2;
            }
        }
    }

    protected HashMap<String, IConfigurationElement> getToolMap() {
        if (this.toolMap == null) {
            this.initializeToolMap();
        }
        return this.toolMap;
    }

    public IValgrindToolView getToolView(String string) throws CoreException {
        Object object;
        IValgrindToolView iValgrindToolView = null;
        IConfigurationElement iConfigurationElement = this.getToolMap().get(string);
        if (iConfigurationElement != null && (object = iConfigurationElement.createExecutableExtension(EXT_ATTR_CLASS)) instanceof IValgrindToolView) {
            iValgrindToolView = (IValgrindToolView)object;
        }
        if (iValgrindToolView == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.getString("ValgrindUIPlugin.Cannot_retrieve_view")));
        }
        return iValgrindToolView;
    }
}

