/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.valgrind.massif.editor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.valgrind.massif.MassifOutput;
import org.eclipse.linuxtools.valgrind.massif.MassifParser;
import org.eclipse.linuxtools.valgrind.massif.MassifPidMenuAction;
import org.eclipse.linuxtools.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.valgrind.massif.MassifTreeViewer;
import org.eclipse.linuxtools.valgrind.massif.Messages;
import org.eclipse.linuxtools.valgrind.massif.birt.ChartControl;
import org.eclipse.linuxtools.valgrind.massif.birt.ChartEditorInput;
import org.eclipse.linuxtools.valgrind.massif.birt.HeapChart;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.xml.sax.SAXException;

public class MassifEditor
extends MultiPageEditorPart {
    protected static final String TITLE_STACKS = Messages.getString("MassifViewPart.Stacks");
    protected static final String TITLE_EXTRA = Messages.getString("MassifViewPart.Extra_Heap");
    protected static final String TITLE_USEFUL = Messages.getString("MassifViewPart.Useful_Heap");
    protected static final String TITLE_TOTAL = Messages.getString("MassifViewPart.Total");
    protected static final String TITLE_TIME = Messages.getString("MassifViewPart.Time");
    protected static final String TITLE_NUMBER = Messages.getString("MassifViewPart.Snapshot");
    protected static final String TREE_ACTION = "org.eclipse.linuxtools.valgrind.massif.treeAction";
    public static final String CHART_ACTION = "org.eclipse.linuxtools.valgrind.massif.chartAction";
    protected static final String EMPTY_STRING = "";
    protected static final String NO = "no";
    protected static final String YES = "yes";
    protected static final String EQUALS = "=";
    protected static final String OUT_PREFIX = "valgrind_";
    protected static final FileFilter MASSIF_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith(MassifEditor.OUT_PREFIX);
        }
    };
    public static final String OPT_MASSIF_OUTFILE = "--massif-out-file";
    public static final String OPT_HEAP = "--heap";
    public static final String OPT_HEAPADMIN = "--heap-admin";
    public static final String OPT_STACKS = "--stacks";
    public static final String OPT_DEPTH = "--depth";
    public static final String OPT_ALLOCFN = "--alloc-fn";
    public static final String OPT_THRESHOLD = "--threshold";
    public static final String OPT_PEAKINACCURACY = "--peak-inaccuracy";
    public static final String OPT_TIMEUNIT = "--time-unit";
    public static final String OPT_DETAILEDFREQ = "--detailed-freq";
    public static final String OPT_MAXSNAPSHOTS = "--max-snapshots";
    public static final String OPT_ALIGNMENT = "--alignment";
    protected MassifSnapshot[] snapshots;
    protected MassifOutput output;
    protected Integer pid = 0;
    protected Composite top;
    protected StackLayout stackLayout;
    protected TableViewer viewer;
    protected MassifTreeViewer treeViewer;
    protected MassifHeapTreeNode[] nodes;
    protected static final int COLUMN_SIZE = 125;
    protected Action treeAction;
    protected Action chartAction;
    protected MassifPidMenuAction pidAction;
    protected List<ChartEditorInput> chartInputs;
    protected ScrolledComposite scrolledComposite;
    protected Composite mainComposite;
    protected ChartControl control;
    private TextEditor sourceEditor;
    private String fileName;
    private String filePath;
    Cursor waitCursor;
    protected Chart cm = null;

    private void initialize() {
        if (Display.getCurrent() != null) {
            this.waitCursor = Display.getCurrent().getSystemCursor(1);
        }
        this.fileName = this.getEditorInput().getName();
        this.filePath = this.getEditorInput().getToolTipText();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.initialize();
    }

    public boolean isDirty() {
        return false;
    }

    public void createPages() {
        this.createMassifTablePage();
        this.createMassifTreeViewPage();
        this.createSourcePage();
        this.updateTitle();
        try {
            this.loadMassifData();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    private void createMassifTablePage() {
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        this.top = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.top.setLayout((Layout)this.stackLayout);
        this.top.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(this.top, 67588);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        String[] stringArray = new String[]{TITLE_NUMBER, TITLE_TIME, TITLE_TOTAL, TITLE_USEFUL, TITLE_EXTRA, TITLE_STACKS};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.viewer, 0);
            tableViewerColumn.getColumn().setText(stringArray[n]);
            tableViewerColumn.getColumn().setWidth(125);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().addSelectionListener(this.getHeaderListener());
            ++n;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MassifLabelProvider());
        this.setTopControl(this.viewer.getControl());
        n = this.addPage((Control)composite);
        this.setPageText(n, "Table Viewer");
    }

    private void createMassifTreeViewPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        this.top = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.top.setLayout((Layout)this.stackLayout);
        this.top.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new MassifTreeViewer(this.top);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.setTopControl(this.treeViewer.getControl());
        int n = this.addPage((Control)composite);
        this.setPageText(n, "Snapshot TreeViewer");
    }

    protected void createTitle(Composite composite, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(composite, 256);
        section.setText("Heap Memory Information");
        section.setLayoutData((Object)new GridData(768));
        formToolkit.createCompositeSeparator((Composite)section);
    }

    private String getUnitString(MassifSnapshot[] massifSnapshotArray) {
        String string;
        MassifSnapshot massifSnapshot = massifSnapshotArray[0];
        switch (massifSnapshot.getUnit()) {
            case BYTES: {
                string = "B";
                break;
            }
            case INSTRUCTIONS: {
                string = "i";
                break;
            }
            default: {
                string = "ms";
            }
        }
        return string;
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                Table table = MassifEditor.this.viewer.getTable();
                if (tableColumn.equals(table.getSortColumn())) {
                    int n = table.getSortDirection() == 128 ? 1024 : 128;
                    table.setSortDirection(n);
                } else {
                    table.setSortDirection(1024);
                }
                table.setSortColumn(tableColumn);
                MassifEditor.this.viewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        Table table = ((TableViewer)viewer).getTable();
                        int n = table.getSortDirection();
                        MassifSnapshot massifSnapshot = (MassifSnapshot)object;
                        MassifSnapshot massifSnapshot2 = (MassifSnapshot)object2;
                        TableColumn tableColumn = table.getSortColumn();
                        long l = tableColumn.getText().equals(TITLE_NUMBER) ? massifSnapshot.getNumber() - massifSnapshot2.getNumber() : (tableColumn.getText().startsWith(TITLE_TIME) ? massifSnapshot.getTime() - massifSnapshot2.getTime() : (tableColumn.getText().equals(TITLE_TOTAL) ? massifSnapshot.getTotal() - massifSnapshot2.getTotal() : (tableColumn.getText().equals(TITLE_USEFUL) ? massifSnapshot.getHeapBytes() - massifSnapshot2.getHeapBytes() : (tableColumn.getText().equals(TITLE_EXTRA) ? massifSnapshot.getHeapExtra() - massifSnapshot2.getHeapExtra() : massifSnapshot.getStacks() - massifSnapshot2.getStacks()))));
                        if (l > Integer.MAX_VALUE) {
                            l = Integer.MAX_VALUE;
                        } else if (l < Integer.MIN_VALUE) {
                            l = Integer.MIN_VALUE;
                        }
                        return (int)(n == 1024 ? l : -l);
                    }
                });
            }
        };
    }

    public IAction[] getToolbarActions() {
        return null;
    }

    protected void createChart(MassifSnapshot[] massifSnapshotArray) {
        HeapChart heapChart = new HeapChart(massifSnapshotArray);
        String string = this.fileName.toString();
        if (heapChart.getTitle() != null && heapChart.getTitle().getLabel() != null && heapChart.getTitle().getLabel().getCaption() != null) {
            heapChart.getTitle().getLabel().getCaption().setValue(string);
        }
        String string2 = this.fileName.toString();
        ChartEditorInput chartEditorInput = new ChartEditorInput(heapChart, string2, this.pid);
        this.chartInputs.add(chartEditorInput);
        this.displayChart(chartEditorInput);
    }

    protected void displayChart(final ChartEditorInput chartEditorInput) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    iWorkbenchPage.openEditor((IEditorInput)chartEditorInput, "org.eclipse.linuxtools.valgrind.massif.chartEditor");
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                }
            }
        });
    }

    protected String getInputName(String string) {
        String string2 = string.substring(0, string.indexOf("[massif]"));
        return string2.trim();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshView() {
        MassifSnapshot[] massifSnapshotArray;
        if (this.output != null && this.pid != null && (massifSnapshotArray = this.output.getSnapshots(this.pid)) != null) {
            TableColumn tableColumn;
            this.viewer.setInput((Object)massifSnapshotArray);
            String string = String.valueOf(TITLE_TIME) + " (" + this.getUnitString(massifSnapshotArray) + ")";
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                tableColumn = tableColumnArray[n2];
                if (tableColumn.getText().startsWith(TITLE_TIME)) {
                    tableColumn.setText(string);
                }
                this.viewer.getTable().layout(true);
                ++n2;
            }
            tableColumn = this.getDetailed(massifSnapshotArray);
            this.nodes = new MassifHeapTreeNode[((TableColumn)tableColumn).length];
            n2 = 0;
            while (n2 < ((TableColumn)tableColumn).length) {
                this.nodes[n2] = tableColumn[n2].getRoot();
                ++n2;
            }
            this.treeViewer.setInput(this.nodes);
            if (massifSnapshotArray.length > 0) {
                ChartEditorInput chartEditorInput = this.getChartInput(this.pid);
                if (chartEditorInput == null) {
                    this.createChart(massifSnapshotArray);
                } else {
                    this.displayChart(chartEditorInput);
                }
            }
        }
    }

    public void setTopControl(Control control) {
        this.stackLayout.topControl = control;
        this.top.layout(true);
    }

    public void setOutput(MassifOutput massifOutput) {
        this.output = massifOutput;
    }

    public void setPid(Integer n) {
        this.pid = n;
    }

    public MassifSnapshot[] getSnapshots() {
        return this.output != null && this.pid != null ? this.output.getSnapshots(this.pid) : null;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private MassifSnapshot[] getDetailed(MassifSnapshot[] massifSnapshotArray) {
        ArrayList<MassifSnapshot> arrayList = new ArrayList<MassifSnapshot>();
        MassifSnapshot[] massifSnapshotArray2 = massifSnapshotArray;
        int n = massifSnapshotArray.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot massifSnapshot = massifSnapshotArray2[n2];
            if (massifSnapshot.getType() != MassifSnapshot.SnapshotType.EMPTY) {
                arrayList.add(massifSnapshot);
            }
            ++n2;
        }
        return arrayList.toArray(new MassifSnapshot[arrayList.size()]);
    }

    private ChartEditorInput getChartInput(Integer n) {
        ChartEditorInput chartEditorInput = null;
        int n2 = 0;
        while (n2 < this.chartInputs.size()) {
            ChartEditorInput chartEditorInput2 = this.chartInputs.get(n2);
            if (chartEditorInput2.getPid().equals(n)) {
                chartEditorInput = chartEditorInput2;
            }
            ++n2;
        }
        return chartEditorInput;
    }

    private void createSourcePage() {
        try {
            this.sourceEditor = new TextEditor();
            int n = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
            this.setPageText(n, "Source");
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    private void updateTitle() {
        this.setPartName(this.fileName);
        this.setTitleToolTip(this.filePath);
    }

    private void loadMassifData() throws FileNotFoundException, ParserConfigurationException, IOException, CoreException, SAXException {
        this.loadData();
        this.refreshView();
    }

    private void loadData() throws FileNotFoundException, ParserConfigurationException, IOException, CoreException, SAXException {
        ArrayList arrayList = new ArrayList();
        this.chartInputs = new ArrayList<ChartEditorInput>();
        String string = this.filePath;
        MassifParser massifParser = new MassifParser(string);
        this.output = new MassifOutput();
        this.output.putSnapshots(massifParser.getPid(), massifParser.getSnapshots());
        this.snapshots = arrayList.toArray(new MassifSnapshot[arrayList.size()]);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected static class MassifLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        protected MassifLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            Image image = null;
            if (n == 0) {
                MassifSnapshot massifSnapshot = (MassifSnapshot)object;
                switch (massifSnapshot.getType()) {
                    case EMPTY: {
                        break;
                    }
                    case DETAILED: 
                    case PEAK: {
                        image = MassifPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/call_hierarchy.gif").createImage();
                        break;
                    }
                }
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            MassifSnapshot massifSnapshot = (MassifSnapshot)object;
            DecimalFormat decimalFormat = new DecimalFormat("#,##0");
            switch (n) {
                case 0: {
                    return decimalFormat.format(massifSnapshot.getNumber());
                }
                case 1: {
                    return decimalFormat.format(massifSnapshot.getTime());
                }
                case 2: {
                    return decimalFormat.format(massifSnapshot.getTotal());
                }
                case 3: {
                    return decimalFormat.format(massifSnapshot.getHeapBytes());
                }
                case 4: {
                    return decimalFormat.format(massifSnapshot.getHeapExtra());
                }
            }
            return decimalFormat.format(massifSnapshot.getStacks());
        }

        public Font getFont(Object object) {
            Font font = null;
            MassifSnapshot massifSnapshot = (MassifSnapshot)object;
            switch (massifSnapshot.getType()) {
                case EMPTY: 
                case DETAILED: {
                    break;
                }
                case PEAK: {
                    font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
                    break;
                }
            }
            return font;
        }
    }
}

