/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.valgrind.core.ValgrindCommand;
import org.eclipse.linuxtools.valgrind.launch.CommandManager;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.memcheck.MemcheckViewPart;
import org.eclipse.linuxtools.valgrind.memcheck.Messages;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindError;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindXMLParser;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.linuxtools.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.valgrind.ui.ValgrindViewPart;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.xml.sax.SAXException;

public class MemcheckLaunchDelegate
extends TizenLaunchDelegate
implements IValgrindLaunchDelegate {
    public static final String OPT_LEAKCHECK = "--leak-check";
    public static final String OPT_SHOWREACH = "--show-reachable";
    public static final String OPT_LEAKRES = "--leak-resolution";
    public static final String OPT_FREELIST = "--freelist-vol";
    public static final String OPT_GCCWORK = "--workaround-gcc296-bugs";
    public static final String OPT_PARTIAL = "--partial-loads-ok";
    public static final String OPT_UNDEF = "--undef-value-errors";
    protected static final String EMPTY_STRING = "";
    protected static final String NO = "no";
    protected static final String YES = "yes";
    protected static final String EQUALS = "=";
    protected ArrayList<ValgrindError> errors;
    protected ValgrindError error;

    public void launch(ValgrindCommand valgrindCommand, ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws Exception {
        try {
            String string = ValgrindUIPlugin.getDefault().getStateLocation().toOSString();
            String string2 = "/tmp/valgrind_result.xml";
            String string3 = String.valueOf(string) + File.separator + "valgrind_result.xml";
            File file = new File(string3);
            if (file.exists()) {
                file.delete();
            }
            CommandManager.pull((String)string2, (String)string3);
            this.parseOutput(string3);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.abort(Messages.getString("MemcheckLaunchDelegate.valgrind_error_message"), null, 150);
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            this.abort(Messages.getString("MemcheckLaunchDelegate.valgrind_error_message"), null, 150);
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            this.abort(Messages.getString("MemcheckLaunchDelegate.valgrind_error_message"), null, 150);
            sAXException.printStackTrace();
        }
    }

    protected void parseOutput(String string) throws ParserConfigurationException, IOException, CoreException, SAXException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(string);
                ValgrindXMLParser valgrindXMLParser = new ValgrindXMLParser(fileInputStream);
                this.errors = valgrindXMLParser.getErrors();
                ValgrindViewPart valgrindViewPart = ValgrindUIPlugin.getDefault().getView();
                IValgrindToolView iValgrindToolView = valgrindViewPart.getDynamicView();
                if (iValgrindToolView instanceof MemcheckViewPart) {
                    ((MemcheckViewPart)iValgrindToolView).setErrors(this.errors.toArray(new ValgrindError[this.errors.size()]));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                fileInputStream.close();
            }
        }
        finally {
            fileInputStream.close();
        }
    }

    public String[] getCommandArray(ValgrindCommand valgrindCommand, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--xml=yes");
        arrayList.add("--xml-file=/tmp/valgrind_result.xml");
        arrayList.add("--leak-check=yes");
        arrayList.add("--show-reachable=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", false) ? YES : NO));
        arrayList.add("--leak-resolution=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", "low"));
        arrayList.add("--freelist-vol=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", 10000000));
        arrayList.add("--workaround-gcc296-bugs=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", false) ? YES : NO));
        arrayList.add("--partial-loads-ok=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", false) ? YES : NO));
        arrayList.add("--undef-value-errors=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true) ? YES : NO));
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

