/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.ui.TizenLaunchDeviceSelectionDialog;
import org.tizen.profiler.codecoverage.CommandManager;
import org.tizen.profiler.codecoverage.ui.AnnotateSource;
import org.tizen.profiler.codecoverage.ui.ViewInitializer;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.util.DeviceUtil;

public class LaunchDelegate
extends TizenLaunchDelegate {
    boolean isOSWindows = System.getProperty("os.name").startsWith("Windows");
    private boolean isPrePostbuildStep = false;
    public static String eclipsePath = Platform.getInstallLocation().getURL().getPath();
    public static String SDK_TOOLS_FILEPATH = String.valueOf(new File(eclipsePath).getParent()) + File.separator + "tools" + File.separator;
    protected static final String LAUNCHPAD_LAUNCHER = "launch_app ";
    protected static final String LAUNCHPAD_SYNCMODE = " __AUL_SDK__ Coverage ";
    private static final String RemoveOldCoverage = "su -c \"rm -f /tmp/default.profraw\"";
    private static final String RemoveOldCoverage30 = "rm -f /tmp/default.profraw";
    protected IProject project;

    protected String getBuildConfigName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        String string = iLaunchConfiguration.getAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", "");
        if (string.isEmpty()) {
            IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)iProject).getDefaultConfiguration();
            return iConfiguration.getName();
        }
        return string;
    }

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        CommonConfigurationManager.setMiscToolOptions((String)"-fprofile-instr-generate -fcoverage-mapping");
        boolean bl = super.buildForLaunch(iLaunchConfiguration, string, iProgressMonitor);
        CommonConfigurationManager.setMiscToolOptions((String)"");
        return bl;
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (ProfileLaunchPlugin.isProfiling()) {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"Another instance of Code Coverage is running. Please rerun after terminating the application.", null);
            return;
        }
        int n = ProfileLaunchPlugin.checkTarget();
        if (n == 0) {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"No device is connected", null);
            return;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.project);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        if (iConfiguration.getName() == "Release") {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"Set Active Build Configuration to Debug", null);
            return;
        }
        IDevice iDevice = ConnectionPlugin.getDefault().getCurrentDevice();
        try {
            string2 = null;
            string2 = this.FindVersion(iDevice);
            if (string2 == null) {
                return;
            }
            if (!this.IsGreaterThanEqual(string2, "3.0")) {
                iDevice.executeShellCommand(RemoveOldCoverage30, false);
            } else {
                iDevice.executeShellCommand(RemoveOldCoverage, false);
                iDevice.executeShellCommand("su -c \"rm -f /home/developer/default.profraw\"", false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            ProfileLaunchPlugin.startProfiling();
            this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
            if (ProjectUtil.getTizenProjectType((IProject)this.project) != null) {
                if (ProjectUtil.getTizenProjectType((IProject)this.project).isNativeProject()) {
                    if (ProjectUtil.getTizenProjectType((IProject)this.project).isImeProject()) {
                        this.newCoreException("Profiling of IME application is not supported.", null);
                    }
                    iProgressMonitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 30);
                    this.activateProgressView();
                    LaunchUtils.verifyExecutableProject((IProject)ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration));
                    this.verifyCProjectConfigurationSettings(iLaunchConfiguration);
                    this.verifyDeviceReachability(iLaunchConfiguration, new SubProgressMonitor(iProgressMonitor, 9));
                    this.verifyBuildConfiguration(iLaunchConfiguration, string, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 11));
                    this.setConsole(iLaunchConfiguration);
                    this.tizenCommand = new TizenLaunchCommand(this.currentDevice, (ConsoleManager)this.launchConsole);
                    this.launchConsole.show();
                    if (string.equals("profile")) {
                        this.deployApplication(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 9));
                        iProgressMonitor.worked(1);
                        string2 = this.project.getLocation().toOSString();
                        String string3 = String.valueOf(string2) + File.separator + "Debug" + File.separator;
                        File file = new File(string3);
                        this.cleanCov(file);
                        this.launchApplicationWithCoverage(iLaunch, iLaunchConfiguration, iProgressMonitor);
                    } else {
                        this.newCoreException("The profiling failed because the application was terminated abnormally", null);
                    }
                } else {
                    ProjectUtil.getTizenProjectType((IProject)this.project).isWebProject();
                }
            }
        }
        finally {
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            String string4 = this.project.getLocation().toOSString();
            String string5 = String.valueOf(string4) + File.separator + "Debug" + File.separator;
            this.CopyCoverageInfo(iDevice, string5);
            File file = new File(string5);
            this.GenerateCovData(string5);
            this.GenerateCovReport(file);
            ViewInitializer viewInitializer = new ViewInitializer(this.project);
            viewInitializer.init(String.valueOf(string4) + File.separator + "Coverage_Report" + File.separator + "report.txt");
            AnnotateSource annotateSource = new AnnotateSource();
            annotateSource.populate(string4);
            iLaunch.terminate();
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            iLaunchManager.removeLaunch(iLaunch);
            iProgressMonitor.done();
            ProfileLaunchPlugin.stopProfiling();
        }
    }

    private IDevice[] getDeploayableDevices(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IDevice[] iDeviceArray = SmartDevelopmentBridge.getBridge().getDevices();
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        Arch arch = this.getBuildConfigurationArchitecture(iLaunchConfiguration);
        IDevice[] iDeviceArray2 = iDeviceArray;
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = iDeviceArray2[n2];
            if (iDevice.getArch() == arch) {
                arrayList.add(iDevice);
            }
            ++n2;
        }
        return arrayList.toArray(new IDevice[arrayList.size()]);
    }

    private void verifyDeviceReachability(ILaunchConfiguration iLaunchConfiguration, SubProgressMonitor subProgressMonitor) throws CoreException {
        try {
            subProgressMonitor.beginTask(TizenLaunchMessages.PREPARE_TO_LAUNCH, 1);
            subProgressMonitor.subTask(TizenLaunchMessages.PREPARE_TO_LAUNCH);
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
            final IDevice[] iDeviceArray = this.getDeploayableDevices(iLaunchConfiguration);
            IDevice iDevice = null;
            iDevice = LaunchUtils.getDeviceFromLaunchConfiguration((ILaunchConfiguration)iLaunchConfiguration, (IDevice[])iDeviceArray);
            if (iDevice == null) {
                int n = iDeviceArray.length;
                if (n == 0) {
                    this.currentDevice = null;
                } else {
                    if (n == 1) {
                        this.currentDevice = iDeviceArray[0];
                    } else {
                        SWTUtil.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                TizenLaunchDeviceSelectionDialog tizenLaunchDeviceSelectionDialog = new TizenLaunchDeviceSelectionDialog(shell, iDeviceArray);
                                LaunchDelegate.this.currentDevice = tizenLaunchDeviceSelectionDialog.open() == 0 ? tizenLaunchDeviceSelectionDialog.getSelectedDevice() : null;
                            }
                        });
                    }
                    if (this.currentDevice != null) {
                        String string = LaunchUtils.getDeviceId((IDevice)this.currentDevice);
                        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.common.launch.device.id", string);
                        iLaunchConfigurationWorkingCopy.doSave();
                    }
                }
            } else {
                this.currentDevice = iDevice;
            }
            if (this.currentDevice == null) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
            if (!DeviceUtil.isOnline((IDevice)this.currentDevice)) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private synchronized void cleanCov(File file) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja" + " " + "clean_cov";
        Runtime runtime = Runtime.getRuntime();
        String string2 = this.expandEnvVariables("${PATH}");
        String[] stringArray = new String[]{"PATH=" + string2};
        stringArray[0] = this.isOSWindows ? String.valueOf(stringArray[0]) + ";%PATH%" : String.valueOf(stringArray[0]) + ":$PATH";
        try {
            runtime.exec(string, stringArray, file).waitFor();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private synchronized void GenerateCovReport(File file) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja" + " " + "cov";
        Runtime runtime = Runtime.getRuntime();
        String string2 = this.expandEnvVariables("${PATH}");
        String[] stringArray = new String[]{"PATH=" + string2};
        stringArray[0] = this.isOSWindows ? String.valueOf(stringArray[0]) + ";%PATH%" : String.valueOf(stringArray[0]) + ":$PATH";
        try {
            runtime.exec(string, stringArray, file).waitFor();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private synchronized void GenerateCovData(String string) {
        File file = new File(String.valueOf(string) + "default.profraw");
        if (!file.exists()) {
            return;
        }
        file = new File(String.valueOf(string) + "coverage.profdata");
        if (file.exists()) {
            file.delete();
        }
        String string2 = String.valueOf(SDK_TOOLS_FILEPATH) + "llvm-3.7" + File.separator + "bin" + File.separator + "llvm-profdata merge -o " + string + "coverage.profdata " + string + "default.profraw";
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(string2).waitFor();
            Thread.sleep(500L);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    String FindVersion(IDevice iDevice) {
        String string = null;
        try {
            string = iDevice.getPlatformInfo().getPlatformVersion();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            sdbCommandRejectedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    boolean IsGreaterThanEqual(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        if (Integer.parseInt(stringArray2[0]) > Integer.parseInt(stringArray[0])) {
            return true;
        }
        if (Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) > Integer.parseInt(stringArray[1])) {
            return true;
        }
        return stringArray.length == 3 && stringArray2.length == 3 && Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) == Integer.parseInt(stringArray[1]) && Integer.parseInt(stringArray2[2]) > Integer.parseInt(stringArray[2]);
    }

    private void CopyCoverageInfo(IDevice iDevice, String string) {
        if (iDevice == null) {
            return;
        }
        String string2 = null;
        string2 = this.FindVersion(iDevice);
        if (string2 == null) {
            return;
        }
        if (!this.IsGreaterThanEqual(string2, "3.0")) {
            CommandManager.runCommand("root on");
            string = String.valueOf(string) + "default.profraw";
            boolean bl = CommandManager.pull("/tmp/default.profraw", string);
            if (!bl) {
                string = "";
            }
        } else {
            CommandManager.runCommand("root on");
            string = String.valueOf(string) + "default.profraw";
            String string3 = "su -c \"cp /tmp/default.profraw /home/developer\"";
            try {
                iDevice.executeShellCommand(string3, false);
                Thread.sleep(500L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            boolean bl = CommandManager.pull("/home/developer/default.profraw", string);
            if (!bl) {
                string = "";
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void launchApplicationWithCoverage(ILaunch var1_1, ILaunchConfiguration var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String[] runCommandReturningResult(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, String string, final String string2, final IProgressMonitor iProgressMonitor, ConsoleManager consoleManager) throws CoverageCanceledException, CoreException {
        Process process = CommandManager.runApplication(string);
        if (process == null) {
            this.newCoreException("The profiling failed because the application was terminated abnormally", null);
        }
        try {
            final IDevice iDevice = ConnectionPlugin.getDefault().getCurrentDevice();
            new Thread(){

                @Override
                public void run() {
                    while (!iProgressMonitor.isCanceled()) {
                    }
                    String string = "ps -ef | grep \"" + string2 + "\"";
                    String[] stringArray = LaunchDelegate.runCommandReturningResult(string);
                    String[] stringArray2 = stringArray[0].split(" +");
                    String string22 = null;
                    string22 = LaunchDelegate.this.FindVersion(iDevice);
                    if (string22 == null) {
                        return;
                    }
                    String string3 = null;
                    string3 = !LaunchDelegate.this.IsGreaterThanEqual(string22, "3.0") ? "kill " + stringArray2[1] : "su -c \"kill " + stringArray2[1] + "\"";
                    LaunchDelegate.runCommandReturningResult(string3);
                }
            }.start();
            process.waitFor();
            boolean bl = false;
            while (!bl) {
                String string3 = "ps -ef | grep \"" + string2 + "\"";
                String[] stringArray = LaunchDelegate.runCommandReturningResult(string3);
                int n = stringArray.length;
                String string4 = "(.*)opt(.*)" + string2 + ".bin(.*)";
                int n2 = 0;
                while (n2 < n) {
                    if (stringArray[n2].matches(string4)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (n2 != n) continue;
                bl = true;
            }
            if (!bl) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public String expandEnvVariables(String string) {
        string = string.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)");
        IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
        if (string.indexOf("$(") >= 0) {
            IEnvironmentVariable[] iEnvironmentVariableArray;
            ICConfigurationDescription iCConfigurationDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)iConfiguration);
            IEnvironmentVariableManager iEnvironmentVariableManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray2 = iEnvironmentVariableArray = iEnvironmentVariableManager.getVariables(iCConfigurationDescription, true);
            int n = iEnvironmentVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray2[n2];
                string = string.replace(String.format("$(%s)", iEnvironmentVariable.getName()), iEnvironmentVariable.getValue());
                ++n2;
            }
        }
        return this.isOSWindows && !this.isPrePostbuildStep ? string.replace("\\", "/") : string;
    }

    protected String getPluginID() {
        return "codecoverage";
    }

    protected String createLaunchStr(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return String.valueOf(iLaunchConfiguration.getName()) + " [Code Coverage] ";
    }

    static class CoverageCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

