/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class TreeViewerDoubleClickListener
implements Listener {
    IProject project;
    private static TreeViewerDoubleClickListener singleton = new TreeViewerDoubleClickListener();

    public TreeViewerDoubleClickListener(IProject iProject) {
        this.project = iProject;
    }

    public static TreeViewerDoubleClickListener getInstance() {
        return singleton;
    }

    public TreeViewerDoubleClickListener() {
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public void handleEvent(Event event) {
        Tree tree = (Tree)event.widget;
        TreeItem[] treeItemArray = tree.getSelection();
        TreeItem treeItem = treeItemArray[0].getParentItem();
        if (treeItem == null) {
            treeItem = treeItemArray[0];
        }
        String string = treeItem.getText(0);
        Path path = new Path(string);
        IFile iFile = this.project.getFile((IPath)path);
        this.openEditor(iFile);
    }

    public void openEditor(IFile iFile) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String string = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.toString()).getId();
        try {
            IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (String)string);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }
}

