/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.linuxtools.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.valgrind.massif.MassifPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;

public class MassifTreeViewer
extends TreeViewer {
    protected IDoubleClickListener doubleClickListener;
    protected ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public Object[] getChildren(Object object) {
            return ((MassifHeapTreeNode)object).getChildren();
        }

        public Object getParent(Object object) {
            return ((MassifHeapTreeNode)object).getParent();
        }

        public boolean hasChildren(Object object) {
            MassifHeapTreeNode[] massifHeapTreeNodeArray = ((MassifHeapTreeNode)object).getChildren();
            return massifHeapTreeNodeArray != null && massifHeapTreeNodeArray.length > 0;
        }

        public Object[] getElements(Object object) {
            return (Object[])object;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    };

    public MassifTreeViewer(Composite composite) {
        super(composite);
        this.setContentProvider((IContentProvider)this.contentProvider);
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((MassifHeapTreeNode)object).getText();
            }

            public Image getImage(Object object) {
                Image image = null;
                image = ((MassifHeapTreeNode)object).getParent() == null ? MassifPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/memory_view.gif").createImage() : DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME");
                return image;
            }
        });
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                MassifHeapTreeNode massifHeapTreeNode = (MassifHeapTreeNode)((TreeSelection)doubleClickEvent.getSelection()).getFirstElement();
                if (massifHeapTreeNode != null) {
                    Object object;
                    ISourceLocator iSourceLocator;
                    if (massifHeapTreeNode.hasSourceFile() && (iSourceLocator = MassifPlugin.getDefault().getSourceLocator()) instanceof ISourceLookupDirector && (object = ((ISourceLookupDirector)iSourceLocator).getSourceElement((Object)massifHeapTreeNode.getFilename())) != null && object instanceof IFile) {
                        try {
                            ProfileUIUtils.openEditorAndSelect((String)((IFile)object).getLocation().toOSString(), (int)massifHeapTreeNode.getLine());
                        }
                        catch (PartInitException partInitException) {
                            partInitException.printStackTrace();
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    if (MassifTreeViewer.this.contentProvider.hasChildren((Object)massifHeapTreeNode)) {
                        MassifTreeViewer.this.expandToLevel(massifHeapTreeNode, 1);
                    }
                }
            }
        };
        this.addDoubleClickListener(this.doubleClickListener);
    }

    public IDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }
}

