/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif.birt;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.linuxtools.valgrind.massif.MassifViewPart;
import org.eclipse.linuxtools.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ChartControl
extends Canvas
implements PaintListener,
ControlListener,
ICallBackNotifier {
    private transient boolean bIsPainting = false;
    private transient Image buffer;
    private static int X_OFFSET = 3;
    private static int Y_OFFSET = 3;
    protected Chart cm = null;
    protected GeneratedChartState state = null;
    protected IDeviceRenderer deviceRenderer = null;
    private boolean needsGeneration = true;

    public ChartControl(Composite composite, Chart chart, int n) {
        super(composite, 2048);
        this.cm = chart;
        this.setLayoutData(new GridData(1808));
        this.setBackground(Display.getDefault().getSystemColor(1));
        try {
            this.deviceRenderer = PluginSettings.instance().getDevice("dv.SWT");
            if (this.deviceRenderer == null) {
                return;
            }
            this.deviceRenderer.setProperty("device.component", (Object)this);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ChartControl.this.deviceRenderer.dispose();
                }
            });
            this.addPaintListener(this);
            this.addControlListener(this);
        }
        catch (ChartException chartException) {
            chartException.printStackTrace();
        }
    }

    public void callback(Object object, Object object2, CallBackValue callBackValue) {
        DataPointHints dataPointHints = (DataPointHints)((WrappedStructureSource)object2).getSource();
        MassifViewPart massifViewPart = (MassifViewPart)ValgrindUIPlugin.getDefault().getView().getDynamicView();
        TableViewer tableViewer = massifViewPart.getTableViewer();
        massifViewPart.setTopControl(tableViewer.getControl());
        tableViewer.setSelection((ISelection)new StructuredSelection(tableViewer.getElementAt(dataPointHints.getIndex())));
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.state.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.needsGeneration = true;
        this.redraw();
    }

    public void repaintChart() {
        this.redraw();
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.bIsPainting) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        if (rectangle2.width - 2 * X_OFFSET <= 0 || rectangle2.height - 2 * Y_OFFSET <= 0) {
            if (this.buffer != null && !this.buffer.isDisposed()) {
                this.buffer.dispose();
                this.buffer = null;
            }
            return;
        }
        if (this.cm == null) {
            this.buffer = null;
        } else {
            block16: {
                Rectangle rectangle3;
                this.bIsPainting = true;
                Image image = null;
                if (this.buffer == null) {
                    this.buffer = new Image((Device)Display.getDefault(), rectangle2);
                } else {
                    rectangle3 = this.buffer.getBounds();
                    image = this.buffer;
                    if (!rectangle2.equals((Object)rectangle3)) {
                        this.buffer = new Image((Device)Display.getDefault(), rectangle2);
                    }
                }
                rectangle3 = new GC((Drawable)this.buffer);
                rectangle3.setForeground(Display.getDefault().getSystemColor(1));
                rectangle3.fillRectangle(this.buffer.getBounds());
                Bounds bounds = BoundsImpl.create((double)X_OFFSET, (double)Y_OFFSET, (double)(rectangle2.width - 2 * X_OFFSET), (double)(rectangle2.height - 2 * Y_OFFSET));
                try {
                    try {
                        RunTimeContext runTimeContext;
                        this.deviceRenderer.setProperty("device.output.context", (Object)rectangle3);
                        bounds.scale(72.0 / (double)this.deviceRenderer.getDisplayServer().getDpiResolution());
                        Generator generator = Generator.instance();
                        if (this.needsGeneration) {
                            this.needsGeneration = false;
                            runTimeContext = new RunTimeContext();
                            this.state = generator.build(this.deviceRenderer.getDisplayServer(), this.cm, bounds, null, runTimeContext, null);
                        }
                        generator.render(this.deviceRenderer, this.state);
                        if (image != null && image != this.buffer) {
                            image.dispose();
                        }
                        runTimeContext = paintEvent.gc;
                        if (this.buffer != null) {
                            runTimeContext.drawImage(this.buffer, 0, 0);
                        }
                    }
                    catch (ChartException chartException) {
                        rectangle3.dispose();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    rectangle3.dispose();
                    throw throwable;
                }
                rectangle3.dispose();
            }
            this.bIsPainting = false;
        }
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        this.needsGeneration = true;
        this.redraw();
    }
}

