/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.event.IRenderInstruction;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.render.DeferredCache;

public class MarkerInstruction
implements IRenderInstruction {
    private final DeferredCache dc;
    private final int iInstruction;
    private final double iMarkerSize;
    private final int zOrder;
    private final PrimitiveRenderEvent pre;

    public MarkerInstruction(DeferredCache dc, PrimitiveRenderEvent pre, int iInstruction, double iMarkerSize, int zOrder) {
        this.dc = dc;
        this.pre = pre;
        this.iInstruction = iInstruction;
        this.iMarkerSize = iMarkerSize;
        this.zOrder = zOrder;
    }

    public int compareTo(Object o) {
        if (o instanceof MarkerInstruction) {
            if (((MarkerInstruction)o).zOrder != this.zOrder) {
                return this.zOrder - ((MarkerInstruction)o).zOrder;
            }
            return (int)(((MarkerInstruction)o).getMarkerSize() - this.iMarkerSize);
        }
        Bounds bo = null;
        if (o instanceof PrimitiveRenderEvent) {
            try {
                bo = ((PrimitiveRenderEvent)o).getBounds();
            }
            catch (ChartException chartException) {
                assert (false);
                return -1;
            }
        } else if (o instanceof WrappedInstruction) {
            bo = ((WrappedInstruction)o).getBounds();
        }
        return this.dc != null && this.dc.isTransposed() ? (bo == null ? 1 : PrimitiveRenderEvent.compareTransposed(this.getBounds(), bo)) : (bo == null ? 1 : PrimitiveRenderEvent.compareRegular(this.getBounds(), bo));
    }

    @Override
    public final PrimitiveRenderEvent getEvent() {
        return this.pre;
    }

    @Override
    public final int getInstruction() {
        return this.iInstruction;
    }

    public final double getMarkerSize() {
        return this.iMarkerSize;
    }

    @Override
    public final Bounds getBounds() {
        try {
            return this.pre.getBounds();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public List getModel() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isModel() {
        return false;
    }

    public final int getMarkerZOrder() {
        return this.zOrder;
    }
}

