/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindStackFrame;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValgrindError {
    protected String unique;
    protected String tid;
    protected String kind;
    protected String what;
    protected String pid;
    protected ArrayList<ValgrindStackFrame> frames;
    protected String auxwhat;
    protected ArrayList<ValgrindStackFrame> auxframes;

    public ValgrindError(Node node) throws CoreException, IOException {
        this.pid = this.findPid(node);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            NodeList nodeList2;
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("unique")) {
                this.unique = node2.getTextContent();
            } else if (node2.getNodeName().equals("tid")) {
                this.tid = node2.getTextContent();
            } else if (node2.getNodeName().equals("kind")) {
                this.kind = node2.getTextContent();
            } else if (node2.getNodeName().equals("what")) {
                this.what = node2.getTextContent();
            } else if (node2.getNodeName().equals("xwhat")) {
                nodeList2 = node2.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node3 = nodeList2.item(n2);
                    if (node3.getNodeName().equals("text")) {
                        this.what = node3.getTextContent();
                    }
                    ++n2;
                }
            } else if (node2.getNodeName().equals("stack")) {
                ArrayList<ValgrindStackFrame> arrayList;
                nodeList2 = node2.getChildNodes();
                if (this.auxwhat == null) {
                    arrayList = this.frames = new ArrayList();
                } else {
                    this.auxframes = new ArrayList();
                    arrayList = this.auxframes;
                }
                int n3 = 0;
                while (n3 < nodeList2.getLength()) {
                    Node node4 = nodeList2.item(n3);
                    if (node4.getNodeName().equals("frame")) {
                        arrayList.add(new ValgrindStackFrame(node4));
                    }
                    ++n3;
                }
            } else if (node2.getNodeName().equals("auxwhat")) {
                this.auxwhat = node2.getTextContent();
            }
            ++n;
        }
        this.createMarker();
    }

    protected void createMarker() throws CoreException, IOException {
        IMarker iMarker = null;
        if (this.frames != null) {
            int n = 0;
            while (n < this.frames.size() && iMarker == null) {
                ValgrindStackFrame valgrindStackFrame = this.frames.get(n);
                if (valgrindStackFrame.getDir() != null && valgrindStackFrame.getFile() != null && valgrindStackFrame.getLine() > 0) {
                    String string = String.valueOf(valgrindStackFrame.getDir()) + '/' + valgrindStackFrame.getFile();
                    File file = new File(string);
                    Path path = new Path(file.getAbsolutePath());
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
                    if (iFile != null && iFile.exists()) {
                        iMarker = iFile.createMarker("org.eclipse.linuxtools.valgrind.memcheck.marker");
                        iMarker.setAttribute("message", (Object)this.what);
                        iMarker.setAttribute("severity", 2);
                        iMarker.setAttribute("lineNumber", valgrindStackFrame.getLine());
                    }
                }
                ++n;
            }
        }
    }

    protected String findPid(Node node) {
        String string = null;
        NodeList nodeList = node.getOwnerDocument().getElementsByTagName("pid");
        if (nodeList.getLength() > 0) {
            string = nodeList.item(0).getTextContent();
        }
        return string;
    }

    public ArrayList<ValgrindStackFrame> getFrames() {
        return this.frames;
    }

    public String getKind() {
        return this.kind;
    }

    public String getTid() {
        return this.tid;
    }

    public String getUnique() {
        return this.unique;
    }

    public String getWhat() {
        return this.what;
    }

    public String getPid() {
        return this.pid;
    }

    public String getAuxWhat() {
        return this.auxwhat;
    }

    public ArrayList<ValgrindStackFrame> getAuxFrames() {
        return this.auxframes;
    }
}

