/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.valgrind.memcheck.editor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindError;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindXMLParser;
import org.eclipse.linuxtools.valgrind.memcheck.model.AuxErrorTreeElement;
import org.eclipse.linuxtools.valgrind.memcheck.model.ErrorTreeElement;
import org.eclipse.linuxtools.valgrind.memcheck.model.RootTreeElement;
import org.eclipse.linuxtools.valgrind.memcheck.model.StackFrameTreeElement;
import org.eclipse.linuxtools.valgrind.memcheck.model.ValgrindTreeElement;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.tizen.common.util.IOUtil;
import org.xml.sax.SAXException;

public class MemcheckEditor
extends MultiPageEditorPart {
    protected TreeViewer memoryErrorTreeViewer;
    protected Section memoryErrorSection;
    protected TreeViewer memoryLeakTreeViewer;
    protected Section memoryLeakSection;
    protected ScrolledComposite scrolledComposite;
    protected Composite mainComposite;
    protected ValgrindError[] errors;
    private static final int MAX_ERROR = 1000;
    private TextEditor sourceEditor;
    private String fileName;
    private String filePath;
    private ArrayList<String> projectfilelist;

    private void initialize() {
        this.fileName = this.getEditorInput().getName();
        this.filePath = this.getEditorInput().getToolTipText();
        this.projectfilelist = new ArrayList();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.initialize();
    }

    public boolean isDirty() {
        return false;
    }

    public void createPages() {
        this.createMemcheckPage();
        this.createSourcePage();
        this.updateTitle();
        try {
            this.loadMemcheckData();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    private void createMemcheckPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        this.scrolledComposite = new ScrolledComposite(composite, 768);
        this.scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        this.scrolledComposite.setLayoutData((Object)new GridData(1808));
        FormToolkit formToolkit = new FormToolkit(this.scrolledComposite.getDisplay());
        this.mainComposite = formToolkit.createComposite((Composite)this.scrolledComposite, 2048);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.createTitle(this.mainComposite, formToolkit);
        this.createMemoryErrorPart(this.mainComposite, formToolkit);
        this.createMemoryLeakPart(this.mainComposite, formToolkit);
        int n = this.addPage((Control)composite);
        this.setPageText(n, "Memcheck");
    }

    protected void createTitle(Composite composite, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(composite, 256);
        section.setText("Memory Error and Leak Information (max 1000 errors and leaks)");
        section.setLayoutData((Object)new GridData(768));
        formToolkit.createCompositeSeparator((Composite)section);
    }

    protected Section createSection(String string, Composite composite, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(composite, 324);
        section.setText(string);
        section.setLayoutData((Object)new GridData(768));
        return section;
    }

    protected void createMemoryErrorPart(Composite composite, FormToolkit formToolkit) {
        this.memoryErrorSection = this.createSection("Memory Error", composite, formToolkit);
        Composite composite2 = formToolkit.createComposite((Composite)this.memoryErrorSection);
        this.memoryErrorSection.setClient((Control)composite2);
        this.memoryErrorSection.addExpansionListener((IExpansionListener)new SectionExpansionListener());
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        label.setText("All reads and writes of memory are checked, and calls to malloc/new/free/delete are intercepted");
        this.createMemoryErrorTree(composite2);
    }

    protected void createMemoryErrorTree(Composite composite) {
        this.memoryErrorTreeViewer = new TreeViewer(composite, 256);
        Tree tree = this.memoryErrorTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        String[] stringArray = new String[]{"Memory error", "Function name", "Sizes", "Address", "Location", "pid", "tid"};
        int[] nArray = new int[]{125, 150, 50, 80, 405, 80, 50};
        TreeColumn[] treeColumnArray = new TreeColumn[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            treeColumnArray[n] = new TreeColumn(this.memoryErrorTreeViewer.getTree(), 16384);
            treeColumnArray[n].setText(stringArray[n]);
            treeColumnArray[n].setWidth(nArray[n]);
            treeColumnArray[n].addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent controlEvent) {
                }

                public void controlResized(ControlEvent controlEvent) {
                    MemcheckEditor.this.memoryErrorSection.layout(true);
                    MemcheckEditor.this.resizeComposite();
                }
            });
            ++n;
        }
        this.memoryErrorTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.memoryErrorTreeViewer.setLabelProvider((IBaseLabelProvider)new ErrorTreeLabelProvider());
        this.memoryErrorTreeViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(this.memoryErrorTreeViewer, this.memoryErrorSection));
        this.memoryErrorTreeViewer.addTreeListener((ITreeViewerListener)new TreeViewerListener(this.memoryErrorTreeViewer, this.memoryErrorSection));
    }

    protected void createMemoryLeakPart(Composite composite, FormToolkit formToolkit) {
        this.memoryLeakSection = this.createSection("Memory Leak", composite, formToolkit);
        Composite composite2 = formToolkit.createComposite((Composite)this.memoryLeakSection);
        this.memoryLeakSection.setClient((Control)composite2);
        this.memoryLeakSection.addExpansionListener((IExpansionListener)new SectionExpansionListener());
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        label.setText("Definitely Lost: The worst outcome is that no pointer to the block can be found.\nPossibly Lost: A pointer to the interior of the block is found.");
        this.createMemoryLeakTree(composite2);
    }

    protected void createMemoryLeakTree(Composite composite) {
        this.memoryLeakTreeViewer = new TreeViewer(composite, 256);
        Tree tree = this.memoryLeakTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        String[] stringArray = new String[]{"Memory leak", "Function name", "Blocks", "Sizes", "Address", "Location", "pid", "tid"};
        int[] nArray = new int[]{135, 100, 80, 80, 80, 325, 80, 50};
        TreeColumn[] treeColumnArray = new TreeColumn[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            treeColumnArray[n] = new TreeColumn(this.memoryLeakTreeViewer.getTree(), 16384);
            treeColumnArray[n].setText(stringArray[n]);
            treeColumnArray[n].setWidth(nArray[n]);
            treeColumnArray[n].addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent controlEvent) {
                }

                public void controlResized(ControlEvent controlEvent) {
                    MemcheckEditor.this.memoryLeakSection.layout(true);
                    MemcheckEditor.this.resizeComposite();
                }
            });
            ++n;
        }
        this.memoryLeakTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.memoryLeakTreeViewer.setLabelProvider((IBaseLabelProvider)new LeakTreeLabelProvider());
        this.memoryLeakTreeViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(this.memoryLeakTreeViewer, this.memoryLeakSection));
        this.memoryLeakTreeViewer.addTreeListener((ITreeViewerListener)new TreeViewerListener(this.memoryLeakTreeViewer, this.memoryLeakSection));
    }

    protected void resizeComposite() {
        this.scrolledComposite.setMinSize(this.mainComposite.computeSize(-1, -1));
    }

    public void getFilelistInProjects() {
        IProject[] iProjectArray;
        this.projectfilelist.clear();
        IProject[] iProjectArray2 = iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            try {
                if (iProject.isOpen()) {
                    IResource[] iResourceArray;
                    IResource[] iResourceArray2 = iResourceArray = iProject.getFolder("src").members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource iResource = iResourceArray2[n4];
                        if (iResource.getType() == 1 && (iResource.getFileExtension().equalsIgnoreCase("cpp") || iResource.getFileExtension().equalsIgnoreCase("c"))) {
                            this.projectfilelist.add(iResource.getName());
                        }
                        ++n4;
                    }
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n2;
        }
    }

    public void refreshView() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.errors != null) {
            int n10;
            Object object;
            int n11 = 1000 < this.errors.length ? 1000 : this.errors.length;
            ArrayList<ValgrindError> arrayList = new ArrayList<ValgrindError>();
            ArrayList<ValgrindError> arrayList2 = new ArrayList<ValgrindError>();
            int n12 = 0;
            while (n12 < n11) {
                if (this.errors[n12].getKind().startsWith("Invalid")) {
                    arrayList.add(this.errors[n12]);
                } else {
                    arrayList2.add(this.errors[n12]);
                }
                ++n12;
            }
            n12 = 0;
            while (n12 < arrayList.size()) {
                ValgrindError valgrindError = (ValgrindError)arrayList.get(n12);
                int n13 = 0;
                while (n13 < valgrindError.getFrames().size()) {
                    object = valgrindError.getFrames().get(n13);
                    if (((ValgrindStackFrame)object).getFile() != null) {
                        n10 = 0;
                        while (n10 < this.projectfilelist.size()) {
                            if (((ValgrindStackFrame)object).getFile().compareToIgnoreCase(this.projectfilelist.get(n10)) == 0) {
                                ++n;
                                n13 = valgrindError.getFrames().size();
                                break;
                            }
                            ++n10;
                        }
                    }
                    ++n13;
                }
                ++n12;
            }
            String string = "*** Memory Error Summary ***\n\n";
            string = String.valueOf(string) + "[ " + arrayList.size() + " ] errors \n";
            string = String.valueOf(string) + "\t from [ " + n + " ] defect \n";
            string = String.valueOf(string) + "\t from [ " + (arrayList.size() - n) + " ] system library";
            this.memoryErrorSection.setToolTipText(string);
            int n14 = 0;
            while (n14 < arrayList2.size()) {
                int n15;
                Object object2;
                int n16;
                ValgrindError valgrindError = (ValgrindError)arrayList2.get(n14);
                if (valgrindError.getKind().startsWith("Leak_DefinitelyLost")) {
                    ++n2;
                    object = valgrindError.getWhat();
                    n10 = 0;
                    if (object != null) {
                        block36: {
                            n10 = ((String)object).indexOf(" byte");
                            if (n10 >= 0) {
                                String string2 = ((String)object).substring(0, n10);
                                try {
                                    n3 += Integer.valueOf(string2).intValue();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    try {
                                        string2 = string2.replace(",", "");
                                        n3 += Integer.valueOf(string2).intValue();
                                    }
                                    catch (NumberFormatException numberFormatException2) {
                                        if (string2.indexOf(" (") < 0) break block36;
                                        string2 = string2.substring(0, string2.indexOf(" ("));
                                        n3 += Integer.valueOf(string2).intValue();
                                    }
                                }
                            }
                        }
                        n16 = ((String)object).indexOf(" in ");
                        n10 = ((String)object).indexOf(" block");
                        if (n16 >= 0 && n10 >= n16 + 3) {
                            object2 = ((String)object).substring(n16 + 3, n10).trim();
                            try {
                                n4 += Integer.valueOf((String)object2).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                object2 = ((String)object2).replace(",", "");
                                n4 += Integer.valueOf((String)object2).intValue();
                            }
                        }
                    }
                    n16 = 0;
                    while (n16 < valgrindError.getFrames().size()) {
                        object2 = valgrindError.getFrames().get(n16);
                        if (((ValgrindStackFrame)object2).getFile() != null) {
                            n15 = 0;
                            while (n15 < this.projectfilelist.size()) {
                                if (((ValgrindStackFrame)object2).getFile().compareToIgnoreCase(this.projectfilelist.get(n15)) == 0) {
                                    ++n5;
                                    n16 = valgrindError.getFrames().size();
                                    break;
                                }
                                ++n15;
                            }
                        }
                        ++n16;
                    }
                }
                if (valgrindError.getKind().startsWith("Leak_PossiblyLost")) {
                    ++n6;
                    object = valgrindError.getWhat();
                    n10 = 0;
                    if (object != null) {
                        n10 = ((String)object).indexOf(" byte");
                        if (n10 >= 0) {
                            String string3 = ((String)object).substring(0, n10);
                            try {
                                n7 += Integer.valueOf(string3).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                string3 = string3.replace(",", "");
                                n7 += Integer.valueOf(string3).intValue();
                            }
                        }
                        n16 = ((String)object).indexOf(" in ");
                        n10 = ((String)object).indexOf(" block");
                        if (n16 >= 0 && n10 >= n16 + 3) {
                            object2 = ((String)object).substring(n16 + 3, n10).trim();
                            try {
                                n8 += Integer.valueOf((String)object2).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                object2 = ((String)object2).replace(",", "");
                                n8 += Integer.valueOf((String)object2).intValue();
                            }
                        }
                    }
                    n16 = 0;
                    while (n16 < valgrindError.getFrames().size()) {
                        object2 = valgrindError.getFrames().get(n16);
                        if (((ValgrindStackFrame)object2).getFile() != null) {
                            n15 = 0;
                            while (n15 < this.projectfilelist.size()) {
                                if (((ValgrindStackFrame)object2).getFile().compareToIgnoreCase(this.projectfilelist.get(n15)) == 0) {
                                    ++n9;
                                    n16 = valgrindError.getFrames().size();
                                    break;
                                }
                                ++n15;
                            }
                        }
                        ++n16;
                    }
                }
                ++n14;
            }
            string = "*** Memory Leak Summary ***\n\n";
            string = String.valueOf(string) + "[ " + n2 + " ] definitely lost: [ " + String.format("%,d", n3) + " ] bytes in [ " + String.format("%,d", n4) + " ] blocks.\n";
            string = String.valueOf(string) + "\t from [ " + n5 + " ] defect \n";
            string = String.valueOf(string) + "\t from [ " + (n2 - n5) + " ] system library\n\n";
            string = String.valueOf(string) + "[ " + n6 + " ] possibly lost: [ " + String.format("%,d", n7) + " ] bytes in [ " + String.format("%,d", n8) + " ] blocks. \n";
            string = String.valueOf(string) + "\t from [ " + n9 + " ] defect \n";
            string = String.valueOf(string) + "\t from [ " + (n6 - n9) + " ] system library \n";
            this.memoryLeakSection.setToolTipText(string);
            RootTreeElement rootTreeElement = new RootTreeElement(arrayList.toArray(new ValgrindError[arrayList.size()]));
            RootTreeElement rootTreeElement2 = new RootTreeElement(arrayList2.toArray(new ValgrindError[arrayList2.size()]));
            this.memoryErrorTreeViewer.setInput((Object)rootTreeElement);
            this.memoryLeakTreeViewer.setInput((Object)rootTreeElement2);
            this.scrolledComposite.setContent((Control)this.mainComposite);
            this.scrolledComposite.setMinSize(this.mainComposite.computeSize(-1, -1));
            this.scrolledComposite.setExpandVertical(true);
            this.scrolledComposite.setExpandHorizontal(true);
        }
    }

    private void createSourcePage() {
        try {
            this.sourceEditor = new TextEditor();
            int n = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
            this.setPageText(n, "Source");
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    private void updateTitle() {
        this.setPartName(this.fileName);
        this.setTitleToolTip(this.filePath);
    }

    private void loadMemcheckData() throws FileNotFoundException, ParserConfigurationException, IOException, CoreException, SAXException {
        this.loadData();
        this.getFilelistInProjects();
        this.refreshView();
    }

    private void loadData() throws FileNotFoundException, ParserConfigurationException, IOException, CoreException, SAXException {
        block5: {
            ArrayList<ValgrindError> arrayList = new ArrayList<ValgrindError>();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(this.filePath);
                    ValgrindXMLParser valgrindXMLParser = new ValgrindXMLParser(fileInputStream);
                    arrayList.addAll(valgrindXMLParser.getErrors());
                    this.errors = arrayList.toArray(new ValgrindError[arrayList.size()]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    IOUtil.tryClose((Object[])new Object[]{fileInputStream});
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{fileInputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{fileInputStream});
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected class DoubleClickListener
    implements IDoubleClickListener {
        private TreeViewer viewer;
        private Section section;

        public DoubleClickListener(TreeViewer treeViewer, Section section) {
            this.viewer = treeViewer;
            this.section = section;
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            Object object = ((TreeSelection)doubleClickEvent.getSelection()).getFirstElement();
            if (object instanceof StackFrameTreeElement) {
                ValgrindStackFrame valgrindStackFrame = ((StackFrameTreeElement)object).getFrame();
                if (valgrindStackFrame.getFile() != null) {
                    String string;
                    String string2 = string = String.valueOf(valgrindStackFrame.getDir()) + '/' + valgrindStackFrame.getFile();
                    int n = valgrindStackFrame.getLine();
                    try {
                        ProfileUIUtils.openEditorAndSelect((String)string2, (int)n);
                    }
                    catch (PartInitException partInitException) {
                        partInitException.printStackTrace();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            } else {
                if (!this.viewer.isExpandable(object)) {
                    return;
                }
                if (this.viewer.getExpandedState(object)) {
                    this.viewer.collapseToLevel(object, -1);
                } else {
                    this.viewer.expandToLevel(object, 1);
                }
                this.section.layout(true);
                MemcheckEditor.this.resizeComposite();
            }
        }
    }

    protected static class ErrorTreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ErrorTreeLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return ((ValgrindTreeElement)object).getImage();
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ErrorTreeElement) {
                ErrorTreeElement errorTreeElement = (ErrorTreeElement)object;
                switch (n) {
                    case 0: {
                        return errorTreeElement.getKind().replaceFirst("Invalid", "Invalid ");
                    }
                    case 1: {
                        return errorTreeElement.getFunction();
                    }
                    case 2: {
                        String string = errorTreeElement.getWhat();
                        if (string == null) {
                            return "-";
                        }
                        int n2 = string.indexOf("size ");
                        if (n2 < 0) {
                            return "-";
                        }
                        if (string.length() >= n2 + 5) {
                            return string.substring(n2 + 5);
                        }
                        return "-";
                    }
                    case 3: {
                        return errorTreeElement.getAddress();
                    }
                    case 4: {
                        return errorTreeElement.getLocation();
                    }
                    case 5: {
                        return errorTreeElement.getPid();
                    }
                    case 6: {
                        return errorTreeElement.getTid();
                    }
                }
                return null;
            }
            if (object instanceof StackFrameTreeElement) {
                ValgrindStackFrame valgrindStackFrame = ((StackFrameTreeElement)object).getFrame();
                switch (n) {
                    case 1: {
                        return valgrindStackFrame.getFunc();
                    }
                    case 3: {
                        return valgrindStackFrame.getPC().toUpperCase().replaceFirst("X", "x");
                    }
                    case 4: {
                        if (valgrindStackFrame.getDir() == null || valgrindStackFrame.getFile() == null) {
                            return valgrindStackFrame.getObj();
                        }
                        return String.valueOf(valgrindStackFrame.getFile()) + ":" + valgrindStackFrame.getLine();
                    }
                }
                return null;
            }
            if (object instanceof AuxErrorTreeElement) {
                AuxErrorTreeElement auxErrorTreeElement = (AuxErrorTreeElement)object;
                switch (n) {
                    case 0: {
                        String string = auxErrorTreeElement.getText();
                        if (string.indexOf("size") > 0 && string.length() >= string.indexOf("size") + 5) {
                            String string2 = string.substring(string.indexOf("size") + 5);
                            if (string.indexOf(" a ") >= string.indexOf("bytes ") + 6) {
                                String string3 = string.substring(string.indexOf("bytes ") + 6, string.indexOf(" a "));
                                string3 = string2.length() >= string2.indexOf(" ") + 1 ? String.valueOf(string3) + " " + string2.substring(string2.indexOf(" ") + 1) + " area" : String.valueOf(string3) + " area";
                                return string3;
                            }
                        }
                        if (string.length() >= string.indexOf("is") + 3) {
                            return string.substring(string.indexOf("is") + 3);
                        }
                        return null;
                    }
                    case 1: {
                        return auxErrorTreeElement.getFunction();
                    }
                    case 2: {
                        String string = auxErrorTreeElement.getText();
                        if (string.indexOf("size") > 0 && string.length() >= string.indexOf("size") + 5) {
                            String string4 = string.substring(string.indexOf("size") + 5);
                            String string5 = null;
                            if (string.indexOf(" byte") >= string.indexOf("is") + 3) {
                                string5 = String.valueOf(string.substring(string.indexOf("is") + 3, string.indexOf(" byte"))) + "/";
                                if (string4.indexOf(" ") - 1 >= 0) {
                                    return String.valueOf(string5) + string4.substring(0, string4.indexOf(" ") - 1);
                                }
                            }
                        }
                        return null;
                    }
                    case 3: {
                        String string = auxErrorTreeElement.getText();
                        if (string.indexOf(" is") >= string.indexOf("Address") + 8) {
                            return string.substring(string.indexOf("Address") + 8, string.indexOf(" is")).toUpperCase().replaceFirst("X", "x");
                        }
                    }
                    case 4: {
                        return auxErrorTreeElement.getLocation();
                    }
                }
                return null;
            }
            return null;
        }
    }

    protected static class LeakTreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected LeakTreeLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return ((ValgrindTreeElement)object).getImage();
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ErrorTreeElement) {
                ErrorTreeElement errorTreeElement = (ErrorTreeElement)object;
                switch (n) {
                    case 0: {
                        return errorTreeElement.getKind().replaceFirst("Leak_", "").replaceAll("Lost", " Lost");
                    }
                    case 1: {
                        return errorTreeElement.getFunction();
                    }
                    case 2: {
                        String string = errorTreeElement.getWhat();
                        if (string != null) {
                            int n2 = string.indexOf(" in ");
                            int n3 = string.indexOf(" block");
                            if (n2 >= 0 && n3 >= n2 + 3) {
                                return string.substring(n2 + 3, n3);
                            }
                        }
                        return null;
                    }
                    case 3: {
                        int n4;
                        String string = errorTreeElement.getWhat();
                        if (string != null && (n4 = string.indexOf(" byte")) >= 0) {
                            return string.substring(0, n4);
                        }
                        return null;
                    }
                    case 4: {
                        return errorTreeElement.getAddress();
                    }
                    case 5: {
                        return errorTreeElement.getLocation();
                    }
                    case 6: {
                        return errorTreeElement.getPid();
                    }
                    case 7: {
                        return errorTreeElement.getTid();
                    }
                }
                return null;
            }
            if (object instanceof StackFrameTreeElement) {
                ValgrindStackFrame valgrindStackFrame = ((StackFrameTreeElement)object).getFrame();
                switch (n) {
                    case 1: {
                        return valgrindStackFrame.getFunc();
                    }
                    case 4: {
                        return valgrindStackFrame.getPC().toUpperCase().replaceFirst("X", "x");
                    }
                    case 5: {
                        if (valgrindStackFrame.getDir() == null || valgrindStackFrame.getFile() == null) {
                            return valgrindStackFrame.getObj();
                        }
                        return String.valueOf(valgrindStackFrame.getFile()) + ":" + valgrindStackFrame.getLine();
                    }
                }
                return null;
            }
            return null;
        }
    }

    protected class SectionExpansionListener
    implements IExpansionListener {
        protected SectionExpansionListener() {
        }

        public void expansionStateChanged(ExpansionEvent expansionEvent) {
            MemcheckEditor.this.resizeComposite();
        }

        public void expansionStateChanging(ExpansionEvent expansionEvent) {
        }
    }

    protected static class TreeContentProvider
    implements ITreeContentProvider {
        protected TreeContentProvider() {
        }

        public Object[] getChildren(Object object) {
            return ((ValgrindTreeElement)object).getChildren();
        }

        public Object getParent(Object object) {
            return ((ValgrindTreeElement)object).getParent();
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    protected class TreeViewerListener
    implements ITreeViewerListener {
        protected TreeViewer viewer;
        protected Section section;

        public TreeViewerListener(TreeViewer treeViewer, Section section) {
            this.viewer = treeViewer;
            this.section = section;
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (this.section.getClient().getDisplay() != null) {
                this.section.getClient().getDisplay().asyncExec((Runnable)new ResizingRunnable());
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (this.section.getClient().getDisplay() != null) {
                this.section.getClient().getDisplay().asyncExec((Runnable)new ResizingRunnable());
            }
        }

        protected class ResizingRunnable
        implements Runnable {
            protected ResizingRunnable() {
            }

            @Override
            public void run() {
                try {
                    while (TreeViewerListener.this.viewer.isBusy()) {
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                TreeViewerListener.this.section.layout(true);
                MemcheckEditor.this.resizeComposite();
            }
        }
    }
}

