/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.launch;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.NullStreamsProxy;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.linuxtools.valgrind.launch.CommandManager;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.sdblib.exception.SdbCommandRejectedException;

public class ValgrindRuntimeProcess
extends PlatformObject
implements IProcess {
    private static final int MAX_WAIT_FOR_DEATH_ATTEMPTS = 10;
    private static final int TIME_TO_WAIT_FOR_THREAD_DEATH = 500;
    private static final String KILLCMD_VER_UNKNOWN = "/usr/bin/profile_command killvalgrind";
    private static final String KILLCMD_VER_0_1 = "pkgcmd -k -n ";
    private ILaunch fLaunch;
    private Process fProcess;
    private int fExitValue;
    private ProcessMonitorThread fMonitor;
    private IStreamsProxy fStreamsProxy;
    private String fName;
    private String fAppId = null;
    private boolean fTerminated;
    private Map fAttributes;
    private boolean fCaptureOutput = true;

    public ValgrindRuntimeProcess(ILaunch iLaunch, Process process, String string, String string2, Map map) {
        this.setLaunch(iLaunch);
        this.initializeAttributes(map);
        this.fProcess = process;
        this.fName = string;
        this.fAppId = string2;
        this.fTerminated = true;
        try {
            this.fExitValue = process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.fTerminated = false;
        }
        String string3 = iLaunch.getAttribute("org.eclipse.debug.core.capture_output");
        this.fCaptureOutput = !"false".equals(string3);
        this.fStreamsProxy = this.createStreamsProxy();
        this.fMonitor = new ProcessMonitorThread(this);
        iLaunch.addProcess((IProcess)this);
        this.fireCreationEvent();
    }

    private void initializeAttributes(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                this.setAttribute(string, (String)entry.getValue());
            }
        }
    }

    public synchronized boolean canTerminate() {
        return !this.fTerminated;
    }

    public String getLabel() {
        return this.fName;
    }

    protected void setLaunch(ILaunch iLaunch) {
        this.fLaunch = iLaunch;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected Process getSystemProcess() {
        return this.fProcess;
    }

    public synchronized boolean isTerminated() {
        return this.fTerminated;
    }

    public static void runCommand(String string) {
        try {
            ConnectionPlugin.getDefault().getCurrentDevice().executeShellCommand(string);
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            sdbCommandRejectedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void terminate() throws DebugException {
        String string = ConnectionPlugin.getDefault().getCurrentDevice().getAppCmdProtocolVersion();
        String string2 = null;
        string2 = string.equals("unknown") ? KILLCMD_VER_UNKNOWN : KILLCMD_VER_0_1 + this.fAppId;
        CommandManager.runCommand(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminated() {
        if (this.fStreamsProxy instanceof StreamsProxy) {
            ((StreamsProxy)this.fStreamsProxy).close();
        }
        int n = -1;
        boolean bl = false;
        try {
            n = this.fProcess.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            bl = true;
        }
        ValgrindRuntimeProcess valgrindRuntimeProcess = this;
        synchronized (valgrindRuntimeProcess) {
            this.fTerminated = true;
            if (!bl) {
                this.fExitValue = n;
            }
            this.fProcess = null;
        }
        this.fireTerminateEvent();
    }

    public IStreamsProxy getStreamsProxy() {
        if (!this.fCaptureOutput) {
            return null;
        }
        return this.fStreamsProxy;
    }

    protected IStreamsProxy createStreamsProxy() {
        if (!this.fCaptureOutput) {
            return new NullStreamsProxy(this.getSystemProcess());
        }
        String string = this.getLaunch().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        return new StreamsProxy(this.getSystemProcess(), string);
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent debugEvent) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.fireDebugEventSet(new DebugEvent[]{debugEvent});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public void setAttribute(String string, String string2) {
        Object v;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        if ((v = this.fAttributes.get(string)) != null && v.equals(string2)) {
            return;
        }
        this.fAttributes.put(string, string2);
        this.fireChangeEvent();
    }

    public String getAttribute(String string) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(string);
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IProcess.class)) {
            return this;
        }
        if (clazz.equals(IDebugTarget.class)) {
            ILaunch iLaunch = this.getLaunch();
            IDebugTarget[] iDebugTargetArray = iLaunch.getDebugTargets();
            int n = 0;
            while (n < iDebugTargetArray.length) {
                if (((Object)((Object)this)).equals(iDebugTargetArray[n].getProcess())) {
                    return iDebugTargetArray[n];
                }
                ++n;
            }
            return null;
        }
        if (clazz.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        if (clazz.equals(ILaunchConfiguration.class)) {
            return this.getLaunch().getLaunchConfiguration();
        }
        return super.getAdapter(clazz);
    }

    public synchronized int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.RuntimeProcess_Exit_value_not_available_until_process_terminates__1, null));
    }

    public void startProcessMonitorThread() {
        if (this.fMonitor != null) {
            this.fMonitor.start();
        }
    }

    static class ProcessMonitorThread
    extends Thread {
        protected boolean fExit;
        protected Process fOSProcess;
        protected ValgrindRuntimeProcess fRuntimeProcess;
        protected Thread fThread;
        private final Object fThreadLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = this.fThreadLock;
            synchronized (var1_1) {
                if (this.fExit) {
                    return;
                }
                this.fThread = Thread.currentThread();
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                if (true) ** GOTO lbl30
            }
            do {
                try {
                    try {
                        this.fOSProcess.waitFor();
                    }
                    catch (InterruptedException v1) {
                        Thread.interrupted();
                        this.fOSProcess = null;
                        this.fRuntimeProcess.terminated();
                        continue;
                    }
                }
                catch (Throwable var1_2) {
                    this.fOSProcess = null;
                    this.fRuntimeProcess.terminated();
                    throw var1_2;
                }
                this.fOSProcess = null;
                this.fRuntimeProcess.terminated();
lbl30:
                // 3 sources

            } while (this.fOSProcess != null);
            this.fThread = null;
        }

        public ProcessMonitorThread(ValgrindRuntimeProcess valgrindRuntimeProcess) {
            super(DebugCoreMessages.ProcessMonitorJob_0);
            this.setDaemon(true);
            this.fRuntimeProcess = valgrindRuntimeProcess;
            this.fOSProcess = valgrindRuntimeProcess.getSystemProcess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void killThread() {
            Object object = this.fThreadLock;
            synchronized (object) {
                if (this.fThread == null) {
                    this.fExit = true;
                } else {
                    this.fThread.interrupt();
                }
            }
        }
    }
}

