/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValgrindStackFrame {
    protected String pc;
    protected String obj;
    protected String func;
    protected String dir;
    protected String file;
    protected int line;

    public ValgrindStackFrame(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("ip")) {
                this.pc = node2.getTextContent();
            } else if (node2.getNodeName().equals("obj")) {
                this.obj = node2.getTextContent();
            } else if (node2.getNodeName().equals("fn")) {
                this.func = node2.getTextContent();
            } else if (node2.getNodeName().equals("dir")) {
                this.dir = node2.getTextContent();
            } else if (node2.getNodeName().equals("file")) {
                this.file = node2.getTextContent();
            } else if (node2.getNodeName().equals("line")) {
                this.line = Integer.parseInt(node2.getTextContent());
            }
            ++n;
        }
    }

    public String getDir() {
        return this.dir;
    }

    public String getFile() {
        return this.file;
    }

    public String getFunc() {
        return this.func;
    }

    public int getLine() {
        return this.line;
    }

    public String getObj() {
        return this.obj;
    }

    public String getPC() {
        return this.pc;
    }
}

