/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import org.eclipse.linuxtools.valgrind.core.AbstractValgrindTextParser;
import org.eclipse.linuxtools.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.valgrind.massif.Messages;
import org.eclipse.osgi.util.NLS;

public class MassifParser
extends AbstractValgrindTextParser {
    private static final String CMD = "cmd";
    private static final String TIME_UNIT = "time_unit";
    private static final String SNAPSHOT = "snapshot";
    private static final String TIME = "time";
    private static final String MEM_HEAP_B = "mem_heap_B";
    private static final String MEM_HEAP_EXTRA_B = "mem_heap_extra_B";
    private static final String MEM_STACKS_B = "mem_stacks_B";
    private static final String HEAP_TREE = "heap_tree";
    private static final String INSTRUCTIONS = "i";
    private static final String MILLISECONDS = "ms";
    private static final String BYTES = "B";
    private static final String PEAK = "peak";
    private static final String DETAILED = "detailed";
    private static final String EMPTY = "empty";
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    protected Integer pid;
    protected MassifSnapshot[] snapshots;

    public MassifParser(String string) throws IOException {
        ArrayList<MassifSnapshot> arrayList = new ArrayList<MassifSnapshot>();
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), Charset.forName("UTF-8")));
                MassifSnapshot massifSnapshot = null;
                String string2 = null;
                MassifSnapshot.TimeUnit timeUnit = null;
                int n = 0;
                String string3 = "000";
                if (!this.isNumber(string3)) {
                    throw new IOException(Messages.getString("MassifParser.Cannot_parse_PID"));
                }
                this.pid = new Integer(string3);
                if (bufferedReader != null) {
                    String string4;
                    while ((string4 = bufferedReader.readLine()) != null) {
                        if (string4.startsWith("cmd:")) {
                            string2 = this.parseStrValue(string4, ": ");
                            continue;
                        }
                        if (string4.startsWith("time_unit:")) {
                            timeUnit = this.parseTimeUnit(string4);
                            continue;
                        }
                        if (string4.startsWith(SNAPSHOT)) {
                            if (massifSnapshot != null) {
                                arrayList.add(massifSnapshot);
                                ++n;
                            }
                            massifSnapshot = new MassifSnapshot(n);
                            massifSnapshot.setCmd(string2);
                            massifSnapshot.setUnit(timeUnit);
                            continue;
                        }
                        if (string4.startsWith("time=")) {
                            if (massifSnapshot == null) continue;
                            massifSnapshot.setTime(this.parseLongValue(string4, EQUALS));
                            continue;
                        }
                        if (string4.startsWith("mem_heap_B=")) {
                            if (massifSnapshot == null) continue;
                            massifSnapshot.setHeapBytes(this.parseLongValue(string4, EQUALS));
                            continue;
                        }
                        if (string4.startsWith("mem_heap_extra_B=")) {
                            if (massifSnapshot == null) continue;
                            massifSnapshot.setHeapExtra(this.parseLongValue(string4, EQUALS));
                            continue;
                        }
                        if (string4.startsWith("mem_stacks_B=")) {
                            if (massifSnapshot == null) continue;
                            massifSnapshot.setStacks(this.parseLongValue(string4, EQUALS));
                            continue;
                        }
                        if (!string4.startsWith("heap_tree=") || massifSnapshot == null) continue;
                        MassifSnapshot.SnapshotType snapshotType = this.parseSnapshotType(string4);
                        massifSnapshot.setType(snapshotType);
                        if (!snapshotType.equals((Object)MassifSnapshot.SnapshotType.DETAILED) && !snapshotType.equals((Object)MassifSnapshot.SnapshotType.PEAK)) continue;
                        MassifHeapTreeNode massifHeapTreeNode = this.parseTree(massifSnapshot, null, bufferedReader);
                        massifHeapTreeNode.setText(NLS.bind((String)Messages.getString("MassifParser.Snapshot_n"), (Object)n, (Object)massifHeapTreeNode.getText()));
                        massifSnapshot.setRoot(massifHeapTreeNode);
                    }
                }
                if (massifSnapshot != null) {
                    arrayList.add(massifSnapshot);
                }
                this.snapshots = arrayList.toArray(new MassifSnapshot[arrayList.size()]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private MassifHeapTreeNode parseTree(MassifSnapshot massifSnapshot, MassifHeapTreeNode massifHeapTreeNode, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException(Messages.getString("MassifParser.Unexpected_EOF"));
        }
        String[] stringArray = (string = string.trim()).split(SPACE);
        Integer n = this.parseNumChildren(stringArray[0]);
        if (n == null) {
            this.fail(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Long l = this.parseNumBytes(stringArray[1]);
        if (l == null) {
            this.fail(string);
        }
        double d = l.intValue() == 0 ? 0.0 : l.doubleValue() / (double)massifSnapshot.getTotal() * 100.0;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        stringBuffer.append(Double.valueOf(new DecimalFormat("##.##", decimalFormatSymbols).format(d)) + "%");
        stringBuffer.append(" (");
        stringBuffer.append(String.valueOf(new DecimalFormat("#,##0").format(l)) + BYTES);
        stringBuffer.append(")");
        int n2 = 2;
        while (n2 < stringArray.length) {
            stringBuffer.append(SPACE);
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        MassifHeapTreeNode massifHeapTreeNode2 = new MassifHeapTreeNode(massifHeapTreeNode, stringBuffer.toString());
        this.parseSourceFile(massifHeapTreeNode2, string);
        int n3 = 0;
        while (n3 < n) {
            massifHeapTreeNode2.addChild(this.parseTree(massifSnapshot, massifHeapTreeNode2, bufferedReader));
            ++n3;
        }
        return massifHeapTreeNode2;
    }

    private void parseSourceFile(MassifHeapTreeNode massifHeapTreeNode, String string) throws IOException {
        int n = string.indexOf("(");
        if (n >= 0) {
            String string2 = string.substring(n, string.length());
            if (string2.length() - 1 >= 1) {
                String string3;
                n = (string2 = string2.substring(1, string2.length() - 1)).lastIndexOf(COLON);
                if (n >= 0 && n < string2.length() && this.isNumber(string3 = string2.substring(n + 1))) {
                    int n2 = Integer.parseInt(string3);
                    String string4 = string2.substring(0, n);
                    massifHeapTreeNode.setFilename(string4);
                    massifHeapTreeNode.setLine(n2);
                }
            } else {
                this.fail(string);
            }
        }
    }

    private Long parseNumBytes(String string) {
        Long l = null;
        if (this.isNumber(string)) {
            l = Long.parseLong(string);
        }
        return l;
    }

    private Integer parseNumChildren(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        Integer n = null;
        if (string.length() >= 3 && this.isNumber(string2 = string.substring(1, string.length() - 1))) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public Integer getPid() {
        return this.pid;
    }

    public MassifSnapshot[] getSnapshots() {
        return this.snapshots;
    }

    protected MassifSnapshot.SnapshotType parseSnapshotType(String string) throws IOException {
        MassifSnapshot.SnapshotType snapshotType = null;
        String[] stringArray = string.split(EQUALS);
        if (stringArray.length > 1) {
            String string2 = stringArray[1];
            if (string2.equals(EMPTY)) {
                snapshotType = MassifSnapshot.SnapshotType.EMPTY;
            } else if (string2.equals(DETAILED)) {
                snapshotType = MassifSnapshot.SnapshotType.DETAILED;
            } else if (string2.equals(PEAK)) {
                snapshotType = MassifSnapshot.SnapshotType.PEAK;
            }
        }
        if (snapshotType == null) {
            this.fail(string);
        }
        return snapshotType;
    }

    protected MassifSnapshot.TimeUnit parseTimeUnit(String string) throws IOException {
        MassifSnapshot.TimeUnit timeUnit = null;
        String[] stringArray = string.split(": ");
        if (stringArray.length > 1) {
            String string2 = stringArray[1];
            if (string2.equals(INSTRUCTIONS)) {
                timeUnit = MassifSnapshot.TimeUnit.INSTRUCTIONS;
            } else if (string2.equals(MILLISECONDS)) {
                timeUnit = MassifSnapshot.TimeUnit.MILLISECONDS;
            } else if (string2.equals(BYTES)) {
                timeUnit = MassifSnapshot.TimeUnit.BYTES;
            }
        }
        if (timeUnit == null) {
            this.fail(string);
        }
        return timeUnit;
    }
}

