/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;
import org.tizen.profiler.codecoverage.ui.FileInfo;
import org.tizen.profiler.codecoverage.ui.PaintListener;
import org.tizen.profiler.codecoverage.ui.TreeViewerDoubleClickListener;

public class CovLaunchTab
extends ViewPart {
    public static final String ID = "codecoverage.ui.CovLaunchTab";
    private static TabFolder tabs;
    private Tree tree;
    TreeColumn firstColumn;
    TreeColumn secondColumn;
    TreeColumn thirdColumn;
    TreeColumn fourthColumn;
    TreeColumn emptyColumn;
    TreeColumn invisibleColumn;
    private static int COLUMNONE;
    private static int COLUMNTWO;
    private static int COLUMNFOUR;
    private static int COLUMNFIVE;
    Point TabSize;

    static {
        COLUMNONE = 0;
        COLUMNTWO = 1;
        COLUMNFOUR = 3;
        COLUMNFIVE = 5;
    }

    public TabFolder getTab() {
        return tabs;
    }

    public void setTab(TabFolder tabFolder) {
        tabs = tabFolder;
    }

    private void setTree(Tree tree) {
        this.tree = tree;
    }

    public void createPartControl(Composite composite) {
        TabFolder tabFolder = new TabFolder(composite, 2048);
        this.setTab(tabFolder);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("code coverage");
        this.tree = new Tree((Composite)tabs, 2816);
        this.firstColumn = new TreeColumn(this.tree, 16384);
        this.firstColumn.setText("Name");
        this.secondColumn = new TreeColumn(this.tree, 0x1000000);
        this.secondColumn.setText("Lines");
        this.thirdColumn = new TreeColumn(this.tree, 0x1000000);
        this.thirdColumn.setText("Coverage");
        this.fourthColumn = new TreeColumn(this.tree, 0x1000000);
        this.fourthColumn.setText("%");
        this.emptyColumn = new TreeColumn(this.tree, 0);
        this.invisibleColumn = new TreeColumn(this.tree, 0);
        this.setTree(this.tree);
        tabFolder.setLayout((Layout)new FillLayout());
    }

    public ArrayList<FileInfo> processLines(String string) {
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            Pattern pattern = Pattern.compile("(src.*)");
            String string2 = null;
            String[] stringArray = new String[5];
            string2 = bufferedReader.readLine();
            block2: while (string2 != null) {
                if (string2.startsWith("File")) {
                    String[] stringArray2 = string2.split("\\'");
                    Matcher matcher = pattern.matcher(stringArray2[1].trim());
                    FileInfo fileInfo = null;
                    if (matcher.find()) {
                        fileInfo = new FileInfo(matcher.group(0), 0, 0, 0, 0, true);
                    }
                    arrayList.add(fileInfo);
                    string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        if (string2.startsWith("Name") || string2.startsWith("----")) {
                            string2 = bufferedReader.readLine();
                            continue;
                        }
                        if (string2.isEmpty()) continue block2;
                        String string3 = new StringBuffer(string2).reverse().toString();
                        String[] stringArray3 = string3.split(":", 5);
                        int n = 0;
                        while (n < 5) {
                            stringArray[4 - n] = new StringBuffer(stringArray3[n]).reverse().toString();
                            ++n;
                        }
                        n = Integer.parseInt(stringArray[COLUMNTWO].trim());
                        int n2 = Integer.parseInt(stringArray[COLUMNFIVE - 1].split("\\.")[0].trim());
                        if (stringArray[COLUMNONE].trim().equals("TOTAL")) {
                            fileInfo.setLineCount(n);
                            fileInfo.setPercent(n2);
                            continue block2;
                        }
                        int n3 = Integer.parseInt(stringArray[COLUMNFOUR].trim());
                        FileInfo fileInfo2 = new FileInfo(stringArray[COLUMNONE].trim(), 0, n, n3, n2, false);
                        arrayList.add(fileInfo2);
                        string2 = bufferedReader.readLine();
                    }
                    continue;
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public void generateTree(TabFolder tabFolder, IProject iProject) throws CoreException {
        this.tree.removeAll();
        this.tree.setHeaderVisible(true);
        this.tree.removeListener(8, (Listener)TreeViewerDoubleClickListener.getInstance());
        this.TabSize = tabFolder.getSize();
        int n = this.TabSize.x;
        this.firstColumn.setWidth((int)((double)n * 0.45));
        this.secondColumn.setWidth((int)((double)n * 0.1));
        this.thirdColumn.setWidth((int)((double)n * 0.3));
        this.fourthColumn.setWidth((int)((double)n * 0.1));
        this.emptyColumn.setWidth((int)((double)n * 0.05));
        this.invisibleColumn.setWidth(0);
        ArrayList<IProject> arrayList = new ArrayList<IProject>(Arrays.asList(iProject.getReferencedProjects()));
        arrayList.add(0, iProject);
        for (IProject object2 : arrayList) {
            String string = object2.getLocation().toOSString();
            ArrayList<FileInfo> arrayList2 = this.processLines(String.valueOf(string) + File.separator + "Coverage_Report" + File.separator + "report.txt");
            int n2 = arrayList2.size();
            int n3 = 0;
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setText(COLUMNONE, object2.getName());
            while (n3 < n2) {
                FileInfo fileInfo = arrayList2.get(n3);
                if (!fileInfo.getIfParent()) continue;
                TreeItem treeItem2 = new TreeItem(treeItem, 0);
                treeItem2.setText(COLUMNONE, fileInfo.getfunctionName());
                treeItem2.setText(COLUMNTWO, Integer.toString(fileInfo.getLineCount()));
                treeItem2.setText(COLUMNFOUR, Integer.toString(fileInfo.getPercent()));
                treeItem2.setText(COLUMNFIVE, Integer.toString(fileInfo.getLineStart()));
                fileInfo = arrayList2.get(++n3);
                while (n3 < n2) {
                    fileInfo = arrayList2.get(n3);
                    if (fileInfo.getIfParent()) break;
                    TreeItem treeItem3 = new TreeItem(treeItem2, 0);
                    treeItem3.setText(COLUMNONE, fileInfo.getfunctionName());
                    treeItem3.setText(COLUMNTWO, Integer.toString(fileInfo.getLineCount()));
                    treeItem3.setText(COLUMNFOUR, Integer.toString(fileInfo.getPercent()));
                    treeItem3.setText(COLUMNFIVE, Integer.toString(fileInfo.getLineStart()));
                    ++n3;
                }
                treeItem2.setExpanded(true);
            }
            treeItem.setExpanded(false);
            if (!treeItem.getText(0).equals(iProject.getName())) continue;
            treeItem.setExpanded(true);
        }
        this.tree.addListener(42, (Listener)new PaintListener(this.tree));
        tabFolder.layout(true);
        TreeViewerDoubleClickListener treeViewerDoubleClickListener = TreeViewerDoubleClickListener.getInstance();
        treeViewerDoubleClickListener.setProject(iProject);
        this.tree.addListener(8, (Listener)treeViewerDoubleClickListener);
    }

    public void setFocus() {
    }
}

