/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif.birt;

import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.CallBackValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.valgrind.massif.birt.Messages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class HeapChart
extends ChartWithAxesImpl {
    private static String[] byteUnits = new String[]{Messages.getString("HeapChart.B"), Messages.getString("HeapChart.KiB"), Messages.getString("HeapChart.MiB"), Messages.getString("HeapChart.GiB"), Messages.getString("HeapChart.TiB")};
    private static String[] instrUnits = new String[]{Messages.getString("HeapChart.i"), Messages.getString("HeapChart.Ki"), Messages.getString("HeapChart.Mi"), Messages.getString("HeapChart.Gi"), Messages.getString("HeapChart.Ti")};
    private static String[] secondUnits = new String[]{Messages.getString("HeapChart.ms"), Messages.getString("HeapChart.s")};
    protected static final int BYTE_MULT = 1024;
    protected static final int BYTE_LIMIT = byteUnits.length - 1;
    protected static final int INSTR_MULT = 1000;
    protected static final int INSTR_LIMIT = instrUnits.length - 1;
    protected static final int MS_MULT = 1000;
    protected static final int MS_LIMIT = secondUnits.length - 1;
    protected static final int SCALING_THRESHOLD = 20;
    protected String xUnits;
    protected String yUnits;

    public HeapChart(MassifSnapshot[] massifSnapshotArray) {
        Marker marker;
        OrthogonalSampleData orthogonalSampleData;
        NumberDataSet numberDataSet;
        Legend legend;
        Plot plot;
        MassifSnapshot.TimeUnit timeUnit = massifSnapshotArray[0].getUnit();
        long l = this.getXScaling(massifSnapshotArray, timeUnit);
        long l2 = this.getYScaling(massifSnapshotArray);
        double[] dArray = new double[massifSnapshotArray.length];
        double[] dArray2 = new double[massifSnapshotArray.length];
        double[] dArray3 = new double[massifSnapshotArray.length];
        double[] dArray4 = null;
        boolean bl = this.isStackProfiled(massifSnapshotArray);
        if (bl) {
            dArray4 = new double[massifSnapshotArray.length];
        }
        double[] dArray5 = new double[massifSnapshotArray.length];
        int n = 0;
        while (n < massifSnapshotArray.length) {
            dArray[n] = (double)massifSnapshotArray[n].getTime() / (double)l;
            dArray2[n] = (double)massifSnapshotArray[n].getHeapBytes() / (double)l2;
            dArray3[n] = (double)massifSnapshotArray[n].getHeapExtra() / (double)l2;
            dArray5[n] = dArray2[n] + dArray3[n];
            if (bl) {
                dArray4[n] = (double)massifSnapshotArray[n].getStacks() / (double)l2;
                int n2 = n;
                dArray4[n2] = dArray4[n2] + dArray4[n];
            }
            ++n;
        }
        this.initialize();
        this.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        this.setType("Line Chart");
        this.setSubType("Overlay");
        Font font = JFaceResources.getDialogFont();
        FontData fontData = font.getFontData()[0];
        if (this.getTitle() != null && this.getTitle().getLabel() != null && this.getTitle().getLabel().getCaption() != null && this.getTitle().getLabel().getCaption().getFont() != null) {
            plot = this.getTitle().getLabel().getCaption().getFont();
            plot.setName(fontData.getName());
            plot.setSize((float)(fontData.getHeight() + 2));
        }
        this.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        plot = this.getPlot();
        if (plot != null) {
            plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        }
        Axis axis = this.getPrimaryBaseAxes()[0];
        axis.setType(AxisType.LINEAR_LITERAL);
        axis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        axis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        axis.getTitle().getCaption().setValue(this.xUnits);
        axis.getTitle().setVisible(true);
        FontDefinition fontDefinition = axis.getTitle().getCaption().getFont();
        fontDefinition.setName(fontData.getName());
        fontDefinition.setSize((float)fontData.getHeight());
        fontDefinition = axis.getLabel().getCaption().getFont();
        fontDefinition.setName(fontData.getName());
        fontDefinition.setSize((float)fontData.getHeight());
        Axis axis2 = this.getPrimaryOrthogonalAxis(axis);
        if (axis2 != null) {
            axis2.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
            axis2.getMajorGrid().getLineAttributes().setVisible(true);
            axis2.getTitle().getCaption().setValue(this.yUnits);
            axis2.getTitle().setVisible(true);
            legend = axis2.getTitle().getCaption().getFont();
            legend.setName(fontData.getName());
            legend.setSize((float)fontData.getHeight());
            legend = axis2.getLabel().getCaption().getFont();
            legend.setName(fontData.getName());
            legend.setSize((float)fontData.getHeight());
        }
        if ((legend = this.getLegend()) != null) {
            legend.setPosition(Position.BELOW_LITERAL);
            legend.setOrientation(Orientation.HORIZONTAL_LITERAL);
            numberDataSet = legend.getText().getFont();
            numberDataSet.setName(fontData.getName());
            numberDataSet.setSize((float)fontData.getHeight());
        }
        numberDataSet = NumberDataSetImpl.create((Object)dArray);
        NumberDataSet numberDataSet2 = NumberDataSetImpl.create((Object)dArray2);
        NumberDataSet numberDataSet3 = NumberDataSetImpl.create((Object)dArray3);
        NumberDataSet numberDataSet4 = null;
        if (bl) {
            numberDataSet4 = NumberDataSetImpl.create((Object)dArray4);
        }
        NumberDataSet numberDataSet5 = NumberDataSetImpl.create((Object)dArray5);
        SampleData sampleData = DataFactory.eINSTANCE.createSampleData();
        BaseSampleData baseSampleData = DataFactory.eINSTANCE.createBaseSampleData();
        baseSampleData.setDataSetRepresentation("");
        sampleData.getBaseSampleData().add((Object)baseSampleData);
        OrthogonalSampleData orthogonalSampleData2 = DataFactory.eINSTANCE.createOrthogonalSampleData();
        orthogonalSampleData2.setDataSetRepresentation("");
        orthogonalSampleData2.setSeriesDefinitionIndex(0);
        sampleData.getOrthogonalSampleData().add((Object)orthogonalSampleData2);
        OrthogonalSampleData orthogonalSampleData3 = DataFactory.eINSTANCE.createOrthogonalSampleData();
        orthogonalSampleData3.setDataSetRepresentation("");
        orthogonalSampleData3.setSeriesDefinitionIndex(1);
        sampleData.getOrthogonalSampleData().add((Object)orthogonalSampleData3);
        if (bl) {
            orthogonalSampleData = DataFactory.eINSTANCE.createOrthogonalSampleData();
            orthogonalSampleData.setDataSetRepresentation("");
            orthogonalSampleData.setSeriesDefinitionIndex(2);
            sampleData.getOrthogonalSampleData().add((Object)orthogonalSampleData);
        }
        orthogonalSampleData = DataFactory.eINSTANCE.createOrthogonalSampleData();
        orthogonalSampleData.setDataSetRepresentation("");
        orthogonalSampleData.setSeriesDefinitionIndex(bl ? 3 : 2);
        sampleData.getOrthogonalSampleData().add((Object)orthogonalSampleData);
        this.setSampleData(sampleData);
        Series series = SeriesImpl.create();
        series.setDataSet((DataSet)numberDataSet);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        axis.getSeriesDefinitions().add((Object)seriesDefinition);
        seriesDefinition.getSeries().add((Object)series);
        LineSeries lineSeries = (LineSeries)LineSeriesImpl.create();
        lineSeries.setDataSet((DataSet)numberDataSet2);
        lineSeries.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
        int n3 = 0;
        while (n3 < lineSeries.getMarkers().size()) {
            Marker marker2 = (Marker)lineSeries.getMarkers().get(n3);
            marker2.setType(MarkerType.DIAMOND_LITERAL);
            ++n3;
        }
        lineSeries.setPaletteLineColor(true);
        lineSeries.setSeriesIdentifier((Object)Messages.getString("HeapChart.Useful_Heap"));
        lineSeries.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)String.valueOf(lineSeries.getSeriesIdentifier())))));
        LineSeries lineSeries2 = (LineSeries)LineSeriesImpl.create();
        lineSeries2.setDataSet((DataSet)numberDataSet3);
        lineSeries2.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
        int n4 = 0;
        while (n4 < lineSeries2.getMarkers().size()) {
            marker = (Marker)lineSeries2.getMarkers().get(n4);
            marker.setType(MarkerType.DIAMOND_LITERAL);
            ++n4;
        }
        lineSeries2.setPaletteLineColor(true);
        lineSeries2.setSeriesIdentifier((Object)Messages.getString("HeapChart.Extra_Heap"));
        lineSeries2.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)String.valueOf(lineSeries2.getSeriesIdentifier())))));
        LineSeries lineSeries3 = null;
        if (bl) {
            lineSeries3 = (LineSeries)LineSeriesImpl.create();
            lineSeries3.setDataSet((DataSet)numberDataSet4);
            lineSeries3.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
            int n5 = 0;
            while (n5 < lineSeries3.getMarkers().size()) {
                Marker marker3 = (Marker)lineSeries3.getMarkers().get(n5);
                marker3.setType(MarkerType.DIAMOND_LITERAL);
                ++n5;
            }
            lineSeries3.setPaletteLineColor(true);
            lineSeries3.setSeriesIdentifier((Object)Messages.getString("HeapChart.Stacks"));
            lineSeries3.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)String.valueOf(lineSeries3.getSeriesIdentifier())))));
        }
        marker = (LineSeries)LineSeriesImpl.create();
        marker.setDataSet((DataSet)numberDataSet5);
        marker.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
        int n6 = 0;
        while (n6 < marker.getMarkers().size()) {
            Marker marker4 = (Marker)marker.getMarkers().get(n6);
            marker4.setType(MarkerType.DIAMOND_LITERAL);
            ++n6;
        }
        marker.setPaletteLineColor(true);
        marker.setSeriesIdentifier((Object)Messages.getString("HeapChart.Total_Heap"));
        marker.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)String.valueOf(marker.getSeriesIdentifier())))));
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition2.getSeriesPalette().shift(-1);
        if (axis2 != null) {
            axis2.getSeriesDefinitions().add((Object)seriesDefinition2);
        }
        seriesDefinition2.getSeries().add((Object)lineSeries);
        seriesDefinition2.getSeries().add((Object)lineSeries2);
        if (bl) {
            seriesDefinition2.getSeries().add((Object)lineSeries3);
        }
        seriesDefinition2.getSeries().add((Object)marker);
    }

    private boolean isStackProfiled(MassifSnapshot[] massifSnapshotArray) {
        return HeapChart.getMaxStack(massifSnapshotArray) > 0L;
    }

    private long getYScaling(MassifSnapshot[] massifSnapshotArray) {
        long l = HeapChart.getMaxValue(massifSnapshotArray);
        int n = 0;
        while (l > 20480L && n < BYTE_LIMIT) {
            l /= 1024L;
            ++n;
        }
        this.yUnits = byteUnits[n];
        return (long)Math.pow(1024.0, n);
    }

    private long getXScaling(MassifSnapshot[] massifSnapshotArray, MassifSnapshot.TimeUnit timeUnit) {
        String[] stringArray;
        int n;
        int n2;
        long l = massifSnapshotArray[massifSnapshotArray.length - 1].getTime();
        switch (timeUnit) {
            case BYTES: {
                n2 = 1024;
                n = BYTE_LIMIT;
                stringArray = byteUnits;
                break;
            }
            case INSTRUCTIONS: {
                n2 = 1000;
                n = INSTR_LIMIT;
                stringArray = instrUnits;
                break;
            }
            default: {
                n2 = 1000;
                n = MS_LIMIT;
                stringArray = secondUnits;
            }
        }
        int n3 = 0;
        while (l > (long)(n2 * 20) && n3 < n) {
            l /= (long)n2;
            ++n3;
        }
        this.xUnits = stringArray[n3];
        return (long)Math.pow(n2, n3);
    }

    private static long getMaxValue(MassifSnapshot[] massifSnapshotArray) {
        long l = 0L;
        MassifSnapshot[] massifSnapshotArray2 = massifSnapshotArray;
        int n = massifSnapshotArray.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot massifSnapshot = massifSnapshotArray2[n2];
            if (massifSnapshot.getTotal() > l) {
                l = massifSnapshot.getTotal();
            }
            ++n2;
        }
        return l;
    }

    private static long getMaxStack(MassifSnapshot[] massifSnapshotArray) {
        long l = 0L;
        MassifSnapshot[] massifSnapshotArray2 = massifSnapshotArray;
        int n = massifSnapshotArray.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot massifSnapshot = massifSnapshotArray2[n2];
            if (massifSnapshot.getTotal() > l) {
                l = massifSnapshot.getStacks();
            }
            ++n2;
        }
        return l;
    }

    public String getXUnits() {
        return this.xUnits;
    }

    public String getYUnits() {
        return this.yUnits;
    }

    public static String[] getByteUnits() {
        return byteUnits;
    }

    public static String[] getInstrUnits() {
        return instrUnits;
    }

    public static String[] getSecondUnits() {
        return secondUnits;
    }
}

