/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.valgrind.core.ValgrindCommand;
import org.eclipse.linuxtools.valgrind.launch.CommandManager;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.massif.MassifOutput;
import org.eclipse.linuxtools.valgrind.massif.MassifParser;
import org.eclipse.linuxtools.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.valgrind.massif.MassifViewPart;
import org.eclipse.linuxtools.valgrind.massif.Messages;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.linuxtools.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.valgrind.ui.ValgrindViewPart;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;

public class MassifLaunchDelegate
extends TizenLaunchDelegate
implements IValgrindLaunchDelegate {
    protected static final String EMPTY_STRING = "";
    protected static final String NO = "no";
    protected static final String YES = "yes";
    protected static final String EQUALS = "=";
    protected static final String LOG_PREFIX = "valgrind_";
    protected static final String LOG_FILE = "valgrind_%p.xml";
    protected static final FileFilter LOG_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith("xml");
        }
    };
    protected static final String OUT_PREFIX = "valgrind_";
    protected static final FileFilter MASSIF_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith("valgrind_");
        }
    };
    public static final String OPT_MASSIF_OUTFILE = "--massif-out-file";
    public static final String OPT_HEAP = "--heap";
    public static final String OPT_HEAPADMIN = "--heap-admin";
    public static final String OPT_STACKS = "--stacks";
    public static final String OPT_DEPTH = "--depth";
    public static final String OPT_ALLOCFN = "--alloc-fn";
    public static final String OPT_THRESHOLD = "--threshold";
    public static final String OPT_PEAKINACCURACY = "--peak-inaccuracy";
    public static final String OPT_TIMEUNIT = "--time-unit";
    public static final String OPT_DETAILEDFREQ = "--detailed-freq";
    public static final String OPT_MAXSNAPSHOTS = "--max-snapshots";
    public static final String OPT_ALIGNMENT = "--alignment";
    protected MassifOutput output;

    public void launch(ValgrindCommand valgrindCommand, ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws Exception {
        MassifPlugin.getDefault().setConfig(iLaunchConfiguration);
        MassifPlugin.getDefault().setSourceLocator(iLaunch.getSourceLocator());
        try {
            String string = ValgrindUIPlugin.getDefault().getStateLocation().toOSString();
            String string2 = "/tmp/valgrind_result.xml";
            String string3 = String.valueOf(string) + File.separator + "valgrind_result.xml";
            File file = new File(string3);
            if (file.exists()) {
                file.delete();
            }
            CommandManager.pull((String)string2, (String)string3);
            this.parseOutput(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort(Messages.getString("MassifLaunchDelegate.valgrind_error_message"), null, 150);
        }
    }

    protected void parseOutput(String string) throws IOException {
        this.output = new MassifOutput();
        MassifParser massifParser = new MassifParser(string);
        this.output.putSnapshots(massifParser.getPid(), massifParser.getSnapshots());
        ValgrindViewPart valgrindViewPart = ValgrindUIPlugin.getDefault().getView();
        IValgrindToolView iValgrindToolView = valgrindViewPart.getDynamicView();
        if (iValgrindToolView instanceof MassifViewPart) {
            ((MassifViewPart)iValgrindToolView).setOutput(this.output);
            ((MassifViewPart)iValgrindToolView).setPid(this.output.getPids()[0]);
        }
    }

    public String[] getCommandArray(ValgrindCommand valgrindCommand, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--massif-out-file=/tmp/valgrind_result.xml");
        arrayList.add("--heap=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAP", true) ? YES : NO));
        arrayList.add("--heap-admin=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAPADMIN", 8));
        arrayList.add("--stacks=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_STACKS", false) ? YES : NO));
        arrayList.add("--depth=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DEPTH", 30));
        List list = iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALLOCFN", Collections.EMPTY_LIST);
        for (String string : list) {
            arrayList.add("--alloc-fn=" + string);
        }
        arrayList.add("--threshold=" + (double)iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_THRESHOLD", 10) / 10.0);
        arrayList.add("--peak-inaccuracy=" + (double)iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PEAKINACCURACY", 10) / 10.0);
        arrayList.add("--time-unit=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_TIMEUNIT", "i"));
        arrayList.add("--detailed-freq=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DETAILEDFREQ", 10));
        arrayList.add("--max-snapshots=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_MAXSNAPSHOTS", 100));
        arrayList.add("--alignment=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT", 8));
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

