/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck.model;

import java.util.ArrayList;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindError;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.memcheck.model.ValgrindTreeElement;
import org.eclipse.swt.graphics.Image;

public class AuxErrorTreeElement
extends ValgrindTreeElement {
    protected ValgrindError error;

    public AuxErrorTreeElement(ValgrindTreeElement valgrindTreeElement, ValgrindError valgrindError) {
        this.parent = valgrindTreeElement;
        this.error = valgrindError;
        this.children = new ArrayList();
        ArrayList<ValgrindStackFrame> arrayList = valgrindError.getAuxFrames();
        if (arrayList != null) {
            this.createStackElements(arrayList);
        }
    }

    @Override
    public Image getImage() {
        return ERROR_IMG;
    }

    @Override
    public String getText() {
        return this.error.getAuxWhat();
    }

    public String getFunction() {
        if (this.error.getAuxFrames() != null) {
            return this.error.getAuxFrames().get(0).getFunc();
        }
        return null;
    }

    public String getLocation() {
        if (this.error.getAuxFrames() != null) {
            ValgrindStackFrame valgrindStackFrame = this.error.getAuxFrames().get(0);
            if (valgrindStackFrame.getDir() == null || valgrindStackFrame.getFile() == null) {
                return valgrindStackFrame.getObj();
            }
            return String.valueOf(valgrindStackFrame.getFile()) + ":" + valgrindStackFrame.getLine();
        }
        return null;
    }
}

