/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.linuxtools.valgrind.memcheck.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class MemcheckToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    public static final String MEMCHECK = "memcheck";
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.memcheck";
    protected Combo leakCheckCombo;
    protected Combo leakResCombo;
    protected Button showReachableButton;
    protected Spinner freelistSpinner;
    protected Button partialLoadsButton;
    protected Button undefValueButton;
    protected Button gccWorkaroundButton;
    protected Spinner alignmentSpinner;
    public static final String ATTR_MEMCHECK_LEAKCHECK = "org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK";
    public static final String ATTR_MEMCHECK_LEAKRES = "org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES";
    public static final String ATTR_MEMCHECK_SHOWREACH = "org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH";
    public static final String ATTR_MEMCHECK_PARTIAL = "org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL";
    public static final String ATTR_MEMCHECK_UNDEF = "org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF";
    public static final String ATTR_MEMCHECK_FREELIST = "org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST";
    public static final String ATTR_MEMCHECK_GCCWORK = "org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK";
    protected static final String EMPTY_STRING = "";
    protected static final String NO = "no";
    protected static final String YES = "yes";
    protected static final String EQUALS = "=";
    protected boolean isInitializing = false;
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MemcheckToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            MemcheckToolPage.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite3, 0);
        label.setText(Messages.getString("MemcheckToolPage.leak_check"));
        this.leakCheckCombo = new Combo(composite3, 8);
        String[] stringArray = new String[]{NO, "summary", YES, "full"};
        this.leakCheckCombo.setItems(stringArray);
        this.leakCheckCombo.addSelectionListener(this.selectListener);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new GridData(768));
        Label label2 = new Label(composite4, 0);
        label2.setText(Messages.getString("MemcheckToolPage.leak_resolution"));
        this.leakResCombo = new Combo(composite4, 8);
        String[] stringArray2 = new String[]{"low", "med", "high"};
        this.leakResCombo.setItems(stringArray2);
        this.leakResCombo.addSelectionListener(this.selectListener);
        Composite composite5 = new Composite(composite2, 0);
        composite5.setLayout((Layout)new GridLayout(2, false));
        composite5.setLayoutData((Object)new GridData(768));
        Label label3 = new Label(composite5, 0);
        label3.setText(Messages.getString("MemcheckToolPage.freelist_size"));
        this.freelistSpinner = new Spinner(composite5, 2048);
        this.freelistSpinner.setMaximum(Integer.MAX_VALUE);
        this.freelistSpinner.addModifyListener(this.modifyListener);
        this.showReachableButton = new Button(composite2, 32);
        this.showReachableButton.setLayoutData((Object)new GridData(768));
        this.showReachableButton.setText(Messages.getString("MemcheckToolPage.show_reachable"));
        this.showReachableButton.addSelectionListener(this.selectListener);
        this.partialLoadsButton = new Button(composite2, 32);
        this.partialLoadsButton.setLayoutData((Object)new GridData(768));
        this.partialLoadsButton.setText(Messages.getString("MemcheckToolPage.allow_partial"));
        this.partialLoadsButton.addSelectionListener(this.selectListener);
        this.undefValueButton = new Button(composite2, 32);
        this.undefValueButton.setLayoutData((Object)new GridData(768));
        this.undefValueButton.setText(Messages.getString("MemcheckToolPage.undef_value_errors"));
        this.undefValueButton.addSelectionListener(this.selectListener);
        Composite composite6 = new Composite(composite2, 0);
        composite6.setLayout((Layout)new GridLayout(2, false));
        composite6.setLayoutData((Object)new GridData(768));
    }

    public String getName() {
        return Messages.getString("MemcheckToolPage.Memcheck_Options");
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.isInitializing = true;
        try {
            this.initializeMemcheck(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.isInitializing = false;
    }

    protected void initializeMemcheck(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        this.leakCheckCombo.setText(iLaunchConfiguration.getAttribute(ATTR_MEMCHECK_LEAKCHECK, "summary"));
        this.leakResCombo.setText(iLaunchConfiguration.getAttribute(ATTR_MEMCHECK_LEAKRES, "low"));
        this.showReachableButton.setSelection(iLaunchConfiguration.getAttribute(ATTR_MEMCHECK_SHOWREACH, false));
        this.freelistSpinner.setSelection(iLaunchConfiguration.getAttribute(ATTR_MEMCHECK_FREELIST, 10000000));
        this.partialLoadsButton.setSelection(iLaunchConfiguration.getAttribute(ATTR_MEMCHECK_PARTIAL, false));
        this.undefValueButton.setSelection(iLaunchConfiguration.getAttribute(ATTR_MEMCHECK_UNDEF, true));
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_LEAKCHECK, this.leakCheckCombo.getText());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_LEAKRES, this.leakResCombo.getText());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_SHOWREACH, this.showReachableButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_FREELIST, this.freelistSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_PARTIAL, this.partialLoadsButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_UNDEF, this.undefValueButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        MemcheckToolPage.setDefaultToolAttributes(iLaunchConfigurationWorkingCopy);
    }

    protected static void setDefaultToolAttributes(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_LEAKCHECK, YES);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_LEAKRES, "low");
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_SHOWREACH, false);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_FREELIST, 10000000);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_PARTIAL, false);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_UNDEF, true);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MEMCHECK_GCCWORK, false);
    }

    protected void createHorizontalSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }
}

