/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.asan;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.linuxtools.asan.CommandManager;
import org.eclipse.linuxtools.asan.ProxyStream;
import org.eclipse.linuxtools.asan.ui.ViewInitializer;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.tizen.common.CommonPlugin;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.RootJob;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class LaunchDelegate
extends TizenLaunchDelegate {
    protected static final String LAUNCHPAD_LAUNCHER = "launch_app ";
    protected static final String LAUNCHPAD_SYNCMODE = " __AUL_SDK__ ASAN ";
    private static final String ASAN_SYMBOLIZER_INSTALLER_PATH = "/tools/user-demand";
    private static final String PATH_3_0_0 = "/opt/usr/home/owner/share/tmp/sdk_tools/";
    private static final String PATH_2_4_0 = "/home/developer/sdk_tools/";
    private static final String REPORT_PATH_3_0_0 = "/opt/usr/home/owner/share/tmp/sdk_tools/reportASAN.txt";
    private static final String REMOVE_TOOL_COMMAND = "rm -f %s";
    private static final String TAR_INSTALL_COMMAND = " && tar -xf %s && rm -f %s";
    private static final String RemoveOldReport24 = "su -c \"rm -f /tmp/reportASAN.txt\"";
    private static final String RemoveOldReport30 = "rm -f /opt/usr/home/owner/share/tmp/sdk_tools/reportASAN.txt";
    public static final String RDS_OPTION_ID = "org.tizen.common.option.rds";
    public static final String RDS_PREFERENCE_PAGE_ID = "org.tizen.common.preferences.rds";
    public static final String RDS_PROPERTIES_PAGE_ID = "org.tizen.common.properties.rds";
    public static final QualifiedName RDS_PROPERTIES_SPECIFIC_OPTION_NAME = new QualifiedName("org.tizen.common.properties.rds", "org.tizen.common.preferences.rds");
    protected IProject project;
    private String SBI_COMPILER_PATH;
    boolean isOSWindows = System.getProperty("os.name").startsWith("Windows");

    String FindVersion(IDevice iDevice) {
        String string = null;
        try {
            string = iDevice.getPlatformInfo().getPlatformVersion();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            sdbCommandRejectedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    boolean IsGreaterThanEqual(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        if (Integer.parseInt(stringArray2[0]) > Integer.parseInt(stringArray[0])) {
            return true;
        }
        if (Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) > Integer.parseInt(stringArray[1])) {
            return true;
        }
        return stringArray.length == 3 && stringArray2.length == 3 && Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) == Integer.parseInt(stringArray[1]) && Integer.parseInt(stringArray2[2]) > Integer.parseInt(stringArray[2]);
    }

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        this.SBI_COMPILER_PATH = this.expandEnvVariables("${SBI_COMPILER_PATH}");
        if (this.SBI_COMPILER_PATH.contains("gcc")) {
            CommonConfigurationManager.setMiscToolOptions((String)"-static-libasan -fsanitize=address -fno-omit-frame-pointer");
        } else if (iLaunchConfiguration.getType().getIdentifier().equals("%lsanProfileConfigTypeID")) {
            CommonConfigurationManager.setMiscToolOptions((String)"-fsanitize=leak");
        } else {
            CommonConfigurationManager.setMiscToolOptions((String)"-fsanitize=address");
        }
        boolean bl = super.buildForLaunch(iLaunchConfiguration, string, iProgressMonitor);
        CommonConfigurationManager.setMiscToolOptions((String)"");
        return bl;
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (ProfileLaunchPlugin.isProfiling()) {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Address Sanitizer", (String)"Another profiling is running. Please rerun after terminating the application.", null);
            return;
        }
        int n = ProfileLaunchPlugin.checkTarget();
        if (n == 0) {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Address Sanitizer", (String)"No device is connected", null);
            return;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.project);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        if (iConfiguration.getName() == "Release") {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Address Sanitizer", (String)"Set Active Build Configuration to Debug", null);
            return;
        }
        File file = null;
        String[] stringArray = null;
        String string3 = String.valueOf(InstallPathConfig.getSDKPath()) + ASAN_SYMBOLIZER_INSTALLER_PATH;
        try {
            file = new File(string3);
            if (!file.isDirectory()) {
                this.newCoreException(null, null);
            } else {
                stringArray = file.list();
                if (stringArray == null) {
                    this.newCoreException(null, null);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ProfileLaunchShortcut.showErrorDialog((String)"Address Sanitizer Warning:", (String)"Symbolizer for Address Sanitizer does not exist", null);
            return;
        }
        if (!this.installSymbolizer(string3, stringArray)) {
            if (!iLaunch.isTerminated()) {
                iLaunch.terminate();
            }
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            iLaunchManager.removeLaunch(iLaunch);
            iProgressMonitor.done();
            return;
        }
        IDevice iDevice = ConnectionPlugin.getDefault().getCurrentDevice();
        try {
            string2 = null;
            string2 = this.FindVersion(iDevice);
            if (string2 == null) {
                return;
            }
            if (!this.IsGreaterThanEqual(string2, "3.0")) {
                iDevice.executeShellCommand(RemoveOldReport30, false);
            } else {
                iDevice.executeShellCommand(RemoveOldReport24, false);
                iDevice.executeShellCommand("su -c \"rm -f /home/developer/reportASAN.txt\"", false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            ProfileLaunchPlugin.startProfiling();
            this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
            if (ProjectUtil.getTizenProjectType((IProject)this.project) != null) {
                if (ProjectUtil.getTizenProjectType((IProject)this.project).isNativeProject()) {
                    if (ProjectUtil.getTizenProjectType((IProject)this.project).isImeProject()) {
                        this.newCoreException("Profiling of IME application is not supported.", null);
                    }
                    iProgressMonitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 30);
                    this.activateProgressView();
                    LaunchUtils.verifyExecutableProject((IProject)ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration));
                    this.verifyCProjectConfigurationSettings(iLaunchConfiguration);
                    this.currentDevice = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultLaunchTarget(this.project, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 15));
                    LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)iLaunchConfiguration.getWorkingCopy(), (IDevice)this.currentDevice);
                    this.verifyBuildConfiguration(iLaunchConfiguration, string, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 11));
                    this.setConsole(iLaunchConfiguration);
                    this.tizenCommand = new TizenLaunchCommand(this.currentDevice, (ConsoleManager)this.launchConsole);
                    this.launchConsole.show();
                    string2 = CommonPlugin.getDefault().getPreferenceStore();
                    boolean bl = string2.getBoolean(RDS_OPTION_ID);
                    String string4 = this.project.getPersistentProperty(RDS_PROPERTIES_SPECIFIC_OPTION_NAME);
                    string2.setValue(RDS_OPTION_ID, false);
                    this.project.setPersistentProperty(RDS_PROPERTIES_SPECIFIC_OPTION_NAME, "false");
                    if (string.equals("profile")) {
                        this.deployApplication(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 9));
                        iProgressMonitor.worked(1);
                        this.project.setPersistentProperty(RDS_PROPERTIES_SPECIFIC_OPTION_NAME, string4);
                        string2.setValue(RDS_OPTION_ID, bl);
                        this.launchApplicationWithAsan(iLaunch, iLaunchConfiguration, iProgressMonitor);
                    } else {
                        this.newCoreException("The profiling failed because the application was terminated abnormally", null);
                    }
                } else {
                    ProjectUtil.getTizenProjectType((IProject)this.project).isWebProject();
                }
            }
        }
        finally {
            iLaunch.terminate();
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            iLaunchManager.removeLaunch(iLaunch);
            iProgressMonitor.done();
            ProfileLaunchPlugin.stopProfiling();
        }
    }

    private boolean installSymbolizer(String string, String[] stringArray) {
        int n;
        Object object;
        Object object2;
        String string2 = null;
        if (CommandManager.isEmulator()) {
            object2 = ConnectionPlugin.getDefault().getCurrentDevice().getArch();
            if (object2.getArch().equals("x86_64")) {
                object = stringArray;
                int n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String string3 = object[n];
                    if (string3.contains("x86_64") && string3.contains("symbolizer")) {
                        string2 = String.valueOf(string3);
                        break;
                    }
                    ++n;
                }
            } else {
                object = stringArray;
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String string4 = object[n];
                    if (string4.contains("i386") && string4.contains("symbolizer")) {
                        string2 = String.valueOf(string4);
                        break;
                    }
                    ++n;
                }
            }
        } else {
            String[] stringArray2 = stringArray;
            n = stringArray.length;
            int n4 = 0;
            while (n4 < n) {
                object2 = stringArray2[n4];
                if (((String)object2).contains("armel") && ((String)object2).contains("symbolizer")) {
                    string2 = String.valueOf(object2);
                    break;
                }
                ++n4;
            }
        }
        object2 = "2.4.0";
        try {
            object2 = ConnectionPlugin.getDefault().getCurrentDevice().getPlatformInfo().getPlatformVersion();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            sdbCommandRejectedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String[] stringArray3 = ((String)object2).split("\\.");
        String string5 = PATH_2_4_0;
        if (Integer.parseInt(stringArray3[0]) >= 3) {
            string5 = PATH_3_0_0;
        }
        if (!CommandManager.push(String.valueOf(string) + File.separator + string2, string5)) {
            ProfileLaunchShortcut.showErrorDialog((String)"Address Sanitizer Warning:", (String)"Failed to install Symbolizer for Address Sanitizer", null);
            return false;
        }
        String string6 = "cd " + string5;
        object = String.valueOf(string6) + TAR_INSTALL_COMMAND;
        String string7 = String.format((String)object, string2, String.valueOf(string2) + "; echo cmd_ret:$?;");
        class InstallJob
        implements RootJob {
            private boolean isSuccess = false;
            private final /* synthetic */ String val$unzipCmd;

            InstallJob(String string) {
                this.val$unzipCmd = string;
            }

            public void run() {
                try {
                    if (CommandManager.isRunSuccessfuly(CommandManager.runCommandReturningResult(this.val$unzipCmd))) {
                        this.isSuccess = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.isSuccess = false;
                    return;
                }
            }

            public boolean isSuccess() {
                return this.isSuccess;
            }
        }
        InstallJob installJob = new InstallJob(string7);
        installJob.run();
        if (installJob.isSuccess()) {
            return true;
        }
        ProfileLaunchShortcut.showErrorDialog((String)"Address Sanitizer Warning:", (String)"Failed to install Symbolizer for Address Sanitizer", null);
        return false;
    }

    /*
     * Exception decompiling
     */
    protected void launchApplicationWithAsan(ILaunch var1_1, ILaunchConfiguration var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, String string, String string2, IProgressMonitor iProgressMonitor, ConsoleManager consoleManager) throws AsanCanceledException, CoreException {
        Process process = CommandManager.runApplication(string);
        if (process == null) {
            this.newCoreException("The profiling failed because the application was terminated abnormally", null);
        }
        while (!iProgressMonitor.isCanceled() && !this.reportGenerated()) {
        }
        String string3 = this.project.getLocation().toOSString();
        IDevice iDevice = ConnectionPlugin.getDefault().getCurrentDevice();
        this.CopyAsanReport(iDevice, String.valueOf(string3) + File.separator);
        ProxyStream proxyStream = new ProxyStream(consoleManager, String.valueOf(string3) + File.separator + "reportASAN.txt");
        String string4 = proxyStream.getReport();
        ViewInitializer viewInitializer = new ViewInitializer(this.project, this.SBI_COMPILER_PATH.contains("gcc"));
        viewInitializer.init(string4);
    }

    private boolean reportGenerated() {
        String string = "ls -l /opt/usr/home/owner/share/tmp/sdk_tools/reportASAN.txt";
        String[] stringArray = CommandManager.runCommandReturningResult(string);
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        return !stringArray[0].contains("No such file or directory");
    }

    public String expandEnvVariables(String string) {
        string = string.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)");
        IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
        if (string.indexOf("$(") >= 0) {
            IEnvironmentVariable[] iEnvironmentVariableArray;
            ICConfigurationDescription iCConfigurationDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)iConfiguration);
            IEnvironmentVariableManager iEnvironmentVariableManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray2 = iEnvironmentVariableArray = iEnvironmentVariableManager.getVariables(iCConfigurationDescription, true);
            int n = iEnvironmentVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray2[n2];
                string = string.replace(String.format("$(%s)", iEnvironmentVariable.getName()), iEnvironmentVariable.getValue());
                ++n2;
            }
        }
        return this.isOSWindows ? string.replace("\\", "/") : string;
    }

    private void CopyAsanReport(IDevice iDevice, String string) {
        if (iDevice == null) {
            return;
        }
        String string2 = null;
        string2 = this.FindVersion(iDevice);
        if (string2 == null) {
            return;
        }
        if (!this.IsGreaterThanEqual(string2, "3.0")) {
            CommandManager.runCommand("root on");
            boolean bl = CommandManager.pull(REPORT_PATH_3_0_0, string);
            if (!bl) {
                string = "";
            }
        } else {
            CommandManager.runCommand("root on");
            String string3 = "su -c \"cp /tmp/reportASAN.txt /home/developer\"";
            try {
                iDevice.executeShellCommand(string3, false);
                Thread.sleep(500L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            boolean bl = CommandManager.pull("/home/developer/reportASAN.txt", string);
            if (!bl) {
                string = "";
            }
        }
    }

    static class AsanCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

