/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindError;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValgrindXMLParser {
    protected static final String END_TAG = "</valgrindoutput>";
    protected DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    protected ArrayList<ValgrindError> errors = new ArrayList();

    public ValgrindXMLParser(InputStream inputStream) throws ParserConfigurationException, IOException, CoreException, SAXException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.separateOutput(inputStream, stringBuffer, stringBuffer2);
        String string = stringBuffer2.toString().trim();
        if (string.length() > 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.core", string));
        }
        InputSource inputSource = new InputSource(new ByteArrayInputStream(stringBuffer.toString().getBytes(Charset.forName("UTF-8"))));
        Document document = this.builder.parse(inputSource);
        NodeList nodeList = document.getElementsByTagName("error");
        int n = 0;
        while (n < nodeList.getLength()) {
            this.errors.add(new ValgrindError(nodeList.item(n)));
            ++n;
        }
    }

    protected void separateOutput(InputStream inputStream, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                boolean bl = false;
                if (bufferedReader != null) {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith("<?xml")) {
                            bl = true;
                        }
                        if (bl) {
                            stringBuffer.append(String.valueOf(string) + "\n");
                        } else {
                            stringBuffer2.append(String.valueOf(string) + "\n");
                        }
                        if (!string.equals(END_TAG)) continue;
                        bl = false;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public ArrayList<ValgrindError> getErrors() {
        return this.errors;
    }
}

