/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.valgrind.ui.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.tizen.common.core.application.StatusLineMessageManager;
import org.tizen.common.util.DialogUtil;

public class ValgrindSaveFileHandler
extends AbstractHandler {
    private IViewPart part;
    private TreeViewer viewer;
    private String fileName;
    private Shell shell;
    private StatusLineMessageManager statusLine;
    private static final String title = "Save File";

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        this.part = (IViewPart)HandlerUtil.getActivePart((ExecutionEvent)executionEvent);
        if (this.part == null) {
            DialogUtil.openErrorDialog((String)"ActivePart is null.");
            return null;
        }
        this.shell = this.part.getSite().getShell();
        this.setStatusLine(new StatusLineMessageManager(this.part));
        this.setViewer((TreeViewer)this.part.getSite().getSelectionProvider());
        String string = "";
        if (this.part.getTitle().contains("memcheck")) {
            string = "memcheck";
        } else if (this.part.getTitle().contains("massif")) {
            string = "massif";
        }
        try {
            this.saveFile(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return null;
    }

    private void saveFile(String string) throws InvocationTargetException, InterruptedException {
        this.fileName = this.getSaveFileName(string);
        if (this.fileName == null) {
            return;
        }
        if (!this.fileName.endsWith("." + string)) {
            this.fileName = String.valueOf(this.fileName) + "." + string;
        }
        if (!new File(this.fileName).getParentFile().canWrite()) {
            DialogUtil.openErrorDialog((String)"You can store a file into the direcotry that has write permission. please select another directory");
            return;
        }
        this.part.getSite().getWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(ValgrindSaveFileHandler.title, 100);
                ValgrindSaveFileHandler.this.writeData();
                iProgressMonitor.done();
            }
        });
    }

    private String getSaveFileName(String string) {
        String[] stringArray = new String[]{"*." + string, "*.*"};
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setFilterExtensions(stringArray);
        fileDialog.setText(title);
        fileDialog.setOverwrite(true);
        fileDialog.setFileName("untitled." + string);
        fileDialog.setFilterPath(System.getProperty("user.home"));
        return fileDialog.open();
    }

    /*
     * Loose catch block
     */
    private void writeData() {
        PrintWriter printWriter = null;
        InputStreamReader inputStreamReader = null;
        PrintWriter printWriter2 = null;
        try {
            try {
                int n;
                printWriter = new PrintWriter(this.fileName, "UTF-8");
                String string = " ";
                String string2 = ValgrindUIPlugin.getDefault().getStateLocation().toOSString();
                if (this.part.getTitle().contains("memcheck")) {
                    string = String.valueOf(string2) + File.separator + "valgrind_result.xml";
                } else if (this.part.getTitle().contains("massif")) {
                    string = String.valueOf(string2) + File.separator + "massif_000.txt";
                }
                File file = new File(string);
                File file2 = new File(this.fileName);
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
                printWriter2 = new PrintWriter(file2, "UTF-8");
                while ((n = inputStreamReader.read()) != -1) {
                    printWriter2.write(n);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                try {
                    if (printWriter != null) {
                        printWriter.flush();
                        printWriter.close();
                    }
                    if (printWriter2 != null) {
                        printWriter2.flush();
                        printWriter2.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                try {
                    if (printWriter != null) {
                        printWriter.flush();
                        printWriter.close();
                    }
                    if (printWriter2 != null) {
                        printWriter2.flush();
                        printWriter2.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (printWriter != null) {
                        printWriter.flush();
                        printWriter.close();
                    }
                    if (printWriter2 != null) {
                        printWriter2.flush();
                        printWriter2.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                if (printWriter2 != null) {
                    printWriter2.flush();
                    printWriter2.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setStatusLine(StatusLineMessageManager statusLineMessageManager) {
        this.statusLine = statusLineMessageManager;
    }

    public StatusLineMessageManager getStatusLine() {
        return this.statusLine;
    }

    public void setViewer(TreeViewer treeViewer) {
        this.viewer = treeViewer;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

