/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.valgrind.massif.MassifOutput;
import org.eclipse.linuxtools.valgrind.massif.MassifPidMenuAction;
import org.eclipse.linuxtools.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.valgrind.massif.MassifTreeViewer;
import org.eclipse.linuxtools.valgrind.massif.Messages;
import org.eclipse.linuxtools.valgrind.massif.birt.ChartEditorInput;
import org.eclipse.linuxtools.valgrind.massif.birt.HeapChart;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.linuxtools.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MassifViewPart
extends ViewPart
implements IValgrindToolView {
    protected static final String TITLE_STACKS = Messages.getString("MassifViewPart.Stacks");
    protected static final String TITLE_EXTRA = Messages.getString("MassifViewPart.Extra_Heap");
    protected static final String TITLE_USEFUL = Messages.getString("MassifViewPart.Useful_Heap");
    protected static final String TITLE_TOTAL = Messages.getString("MassifViewPart.Total");
    protected static final String TITLE_TIME = Messages.getString("MassifViewPart.Time");
    protected static final String TITLE_NUMBER = Messages.getString("MassifViewPart.Snapshot");
    protected static final String TREE_ACTION = "org.eclipse.linuxtools.valgrind.massif.treeAction";
    public static final String CHART_ACTION = "org.eclipse.linuxtools.valgrind.massif.chartAction";
    public static final String PID_ACTION = "org.eclipse.linuxtools.valgrind.massif.pidAction";
    protected MassifOutput output;
    protected Integer pid;
    protected Composite top;
    protected StackLayout stackLayout;
    protected TableViewer viewer;
    protected MassifTreeViewer treeViewer;
    protected MassifHeapTreeNode[] nodes;
    protected static final int COLUMN_SIZE = 125;
    protected Action treeAction;
    protected Action chartAction;
    protected MassifPidMenuAction pidAction;
    protected List<ChartEditorInput> chartInputs;

    public void createPartControl(Composite composite) {
        this.chartInputs = new ArrayList<ChartEditorInput>();
        this.top = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.top.setLayout((Layout)this.stackLayout);
        this.top.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(this.top, 67588);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        String[] stringArray = new String[]{TITLE_NUMBER, TITLE_TIME, TITLE_TOTAL, TITLE_USEFUL, TITLE_EXTRA, TITLE_STACKS};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.viewer, 0);
            tableViewerColumn.getColumn().setText(stringArray[n]);
            tableViewerColumn.getColumn().setWidth(125);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().addSelectionListener(this.getHeaderListener());
            ++n;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MassifLabelProvider());
        this.treeViewer = new MassifTreeViewer(this.top);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                MassifSnapshot massifSnapshot = (MassifSnapshot)((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
                if (massifSnapshot != null && massifSnapshot.getType() != MassifSnapshot.SnapshotType.EMPTY) {
                    MassifViewPart.this.treeAction.setChecked(true);
                    MassifViewPart.this.setTopControl(MassifViewPart.this.treeViewer.getControl());
                    MassifViewPart.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)massifSnapshot.getRoot()), true);
                    MassifViewPart.this.treeViewer.expandToLevel(massifSnapshot.getRoot(), -1);
                }
            }
        });
        this.setTopControl(this.viewer.getControl());
    }

    private String getUnitString(MassifSnapshot[] massifSnapshotArray) {
        String string;
        MassifSnapshot massifSnapshot = massifSnapshotArray[0];
        switch (massifSnapshot.getUnit()) {
            case BYTES: {
                string = "B";
                break;
            }
            case INSTRUCTIONS: {
                string = "i";
                break;
            }
            default: {
                string = "ms";
            }
        }
        return string;
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                Table table = MassifViewPart.this.viewer.getTable();
                if (tableColumn.equals(table.getSortColumn())) {
                    int n = table.getSortDirection() == 128 ? 1024 : 128;
                    table.setSortDirection(n);
                } else {
                    table.setSortDirection(1024);
                }
                table.setSortColumn(tableColumn);
                MassifViewPart.this.viewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        Table table = ((TableViewer)viewer).getTable();
                        int n = table.getSortDirection();
                        MassifSnapshot massifSnapshot = (MassifSnapshot)object;
                        MassifSnapshot massifSnapshot2 = (MassifSnapshot)object2;
                        TableColumn tableColumn = table.getSortColumn();
                        long l = tableColumn.getText().equals(TITLE_NUMBER) ? massifSnapshot.getNumber() - massifSnapshot2.getNumber() : (tableColumn.getText().startsWith(TITLE_TIME) ? massifSnapshot.getTime() - massifSnapshot2.getTime() : (tableColumn.getText().equals(TITLE_TOTAL) ? massifSnapshot.getTotal() - massifSnapshot2.getTotal() : (tableColumn.getText().equals(TITLE_USEFUL) ? massifSnapshot.getHeapBytes() - massifSnapshot2.getHeapBytes() : (tableColumn.getText().equals(TITLE_EXTRA) ? massifSnapshot.getHeapExtra() - massifSnapshot2.getHeapExtra() : massifSnapshot.getStacks() - massifSnapshot2.getStacks()))));
                        if (l > Integer.MAX_VALUE) {
                            l = Integer.MAX_VALUE;
                        } else if (l < Integer.MIN_VALUE) {
                            l = Integer.MIN_VALUE;
                        }
                        return (int)(n == 1024 ? l : -l);
                    }
                });
            }
        };
    }

    public IAction[] getToolbarActions() {
        this.pidAction = new MassifPidMenuAction(this);
        this.pidAction.setId(PID_ACTION);
        this.chartAction = new Action(Messages.getString("MassifViewPart.Display_Heap_Allocation"), 1){

            public void run() {
                ChartEditorInput chartEditorInput = MassifViewPart.this.getChartInput(MassifViewPart.this.pid);
                if (chartEditorInput != null) {
                    MassifViewPart.this.displayChart(chartEditorInput);
                }
            }
        };
        this.chartAction.setId(CHART_ACTION);
        this.chartAction.setImageDescriptor(MassifPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/linecharticon.gif"));
        this.chartAction.setToolTipText(Messages.getString("MassifViewPart.Display_Heap_Allocation"));
        this.treeAction = new Action(Messages.getString("MassifViewPart.Show_Heap_Tree"), 2){

            public void run() {
                if (this.isChecked()) {
                    MassifViewPart.this.setTopControl(MassifViewPart.this.treeViewer.getControl());
                } else {
                    MassifViewPart.this.setTopControl(MassifViewPart.this.viewer.getControl());
                }
            }
        };
        this.treeAction.setId(TREE_ACTION);
        this.treeAction.setImageDescriptor(MassifPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/call_hierarchy.gif"));
        this.treeAction.setToolTipText(Messages.getString("MassifViewPart.Show_Heap_Tree"));
        return new IAction[]{this.pidAction, this.chartAction, this.treeAction};
    }

    protected void createChart(MassifSnapshot[] massifSnapshotArray) {
        HeapChart heapChart = new HeapChart(massifSnapshotArray);
        String string = String.valueOf(ValgrindUIPlugin.getDefault().getView().getContentDescription()) + " [PID: " + this.pid + "]";
        if (heapChart.getTitle() != null && heapChart.getTitle().getLabel() != null && heapChart.getTitle().getLabel().getCaption() != null) {
            heapChart.getTitle().getLabel().getCaption().setValue(string);
        }
        String string2 = this.getInputName(string);
        ChartEditorInput chartEditorInput = new ChartEditorInput(heapChart, string2, this.pid);
        this.chartInputs.add(chartEditorInput);
        this.displayChart(chartEditorInput);
    }

    protected void displayChart(final ChartEditorInput chartEditorInput) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    iWorkbenchPage.openEditor((IEditorInput)chartEditorInput, "org.eclipse.linuxtools.valgrind.massif.chartEditor");
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                }
            }
        });
    }

    protected String getInputName(String string) {
        if (string == null) {
            return new String("");
        }
        String string2 = "";
        if (string.indexOf("[massif]") >= 0) {
            string2 = string.substring(0, string.indexOf("[massif]"));
            return string2.trim();
        }
        return string2;
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshView() {
        if (this.output != null && this.pid != null) {
            MassifSnapshot[] massifSnapshotArray = this.output.getSnapshots(this.pid);
            this.pidAction.setPids(this.output.getPids());
            if (massifSnapshotArray != null) {
                TableColumn tableColumn;
                this.viewer.setInput((Object)massifSnapshotArray);
                String string = String.valueOf(TITLE_TIME) + " (" + this.getUnitString(massifSnapshotArray) + ")";
                TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    tableColumn = tableColumnArray[n2];
                    if (tableColumn.getText().startsWith(TITLE_TIME)) {
                        tableColumn.setText(string);
                    }
                    this.viewer.getTable().layout(true);
                    ++n2;
                }
                tableColumn = this.getDetailed(massifSnapshotArray);
                this.nodes = new MassifHeapTreeNode[((TableColumn)tableColumn).length];
                n2 = 0;
                while (n2 < ((TableColumn)tableColumn).length) {
                    this.nodes[n2] = tableColumn[n2].getRoot();
                    ++n2;
                }
                this.treeViewer.setInput(this.nodes);
                if (massifSnapshotArray.length > 0) {
                    ChartEditorInput chartEditorInput = this.getChartInput(this.pid);
                    if (chartEditorInput == null) {
                        this.createChart(massifSnapshotArray);
                    } else {
                        this.displayChart(chartEditorInput);
                    }
                }
            }
        }
    }

    public void setTopControl(Control control) {
        this.stackLayout.topControl = control;
        this.top.layout(true);
    }

    public void setOutput(MassifOutput massifOutput) {
        this.output = massifOutput;
    }

    public void setPid(Integer n) {
        this.pid = n;
    }

    public MassifSnapshot[] getSnapshots() {
        return this.output != null && this.pid != null ? this.output.getSnapshots(this.pid) : null;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private MassifSnapshot[] getDetailed(MassifSnapshot[] massifSnapshotArray) {
        ArrayList<MassifSnapshot> arrayList = new ArrayList<MassifSnapshot>();
        MassifSnapshot[] massifSnapshotArray2 = massifSnapshotArray;
        int n = massifSnapshotArray.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot massifSnapshot = massifSnapshotArray2[n2];
            if (massifSnapshot.getType() != MassifSnapshot.SnapshotType.EMPTY) {
                arrayList.add(massifSnapshot);
            }
            ++n2;
        }
        return arrayList.toArray(new MassifSnapshot[arrayList.size()]);
    }

    private ChartEditorInput getChartInput(Integer n) {
        ChartEditorInput chartEditorInput = null;
        int n2 = 0;
        while (n2 < this.chartInputs.size()) {
            ChartEditorInput chartEditorInput2 = this.chartInputs.get(n2);
            if (chartEditorInput2.getPid().equals(n)) {
                chartEditorInput = chartEditorInput2;
            }
            ++n2;
        }
        return chartEditorInput;
    }

    public static class MassifLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        public Image getColumnImage(Object object, int n) {
            Image image = null;
            if (n == 0) {
                MassifSnapshot massifSnapshot = (MassifSnapshot)object;
                switch (massifSnapshot.getType()) {
                    case EMPTY: {
                        break;
                    }
                    case DETAILED: 
                    case PEAK: {
                        image = MassifPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.massif", (String)"icons/call_hierarchy.gif").createImage();
                        break;
                    }
                }
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            MassifSnapshot massifSnapshot = (MassifSnapshot)object;
            DecimalFormat decimalFormat = new DecimalFormat("#,##0");
            switch (n) {
                case 0: {
                    return decimalFormat.format(massifSnapshot.getNumber());
                }
                case 1: {
                    return decimalFormat.format(massifSnapshot.getTime());
                }
                case 2: {
                    return decimalFormat.format(massifSnapshot.getTotal());
                }
                case 3: {
                    return decimalFormat.format(massifSnapshot.getHeapBytes());
                }
                case 4: {
                    return decimalFormat.format(massifSnapshot.getHeapExtra());
                }
            }
            return decimalFormat.format(massifSnapshot.getStacks());
        }

        public Font getFont(Object object) {
            Font font = null;
            MassifSnapshot massifSnapshot = (MassifSnapshot)object;
            switch (massifSnapshot.getType()) {
                case EMPTY: 
                case DETAILED: {
                    break;
                }
                case PEAK: {
                    font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
                    break;
                }
            }
            return font;
        }
    }
}

