/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.linuxtools.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.valgrind.massif.Messages;
import org.eclipse.linuxtools.valgrind.massif.PowerOfTwoSpinner;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class MassifToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    public static final String MASSIF = "massif";
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.massif";
    public static final String TIME_I = "i";
    public static final String TIME_MS = "ms";
    public static final String TIME_B = "B";
    protected Button heapButton;
    protected Spinner heapAdminSpinner;
    protected Button stacksButton;
    protected Spinner depthSpinner;
    protected org.eclipse.swt.widgets.List allocFnList;
    protected Spinner thresholdSpinner;
    protected Spinner peakInaccuracySpinner;
    protected Combo timeUnitCombo;
    protected Spinner detailedFreqSpinner;
    protected Spinner maxSnapshotsSpinner;
    protected PowerOfTwoSpinner alignmentSpinner;
    protected Button removeButton;
    public static final String ATTR_MASSIF_OUTFILE = "org.eclipse.linuxtools.valgrind.massif.MASSIF_OUTFILE";
    public static final String ATTR_MASSIF_HEAP = "org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAP";
    public static final String ATTR_MASSIF_HEAPADMIN = "org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAPADMIN";
    public static final String ATTR_MASSIF_STACKS = "org.eclipse.linuxtools.valgrind.massif.MASSIF_STACKS";
    public static final String ATTR_MASSIF_DEPTH = "org.eclipse.linuxtools.valgrind.massif.MASSIF_DEPTH";
    public static final String ATTR_MASSIF_ALLOCFN = "org.eclipse.linuxtools.valgrind.massif.MASSIF_ALLOCFN";
    public static final String ATTR_MASSIF_THRESHOLD = "org.eclipse.linuxtools.valgrind.massif.MASSIF_THRESHOLD";
    public static final String ATTR_MASSIF_PEAKINACCURACY = "org.eclipse.linuxtools.valgrind.massif.MASSIF_PEAKINACCURACY";
    public static final String ATTR_MASSIF_TIMEUNIT = "org.eclipse.linuxtools.valgrind.massif.MASSIF_TIMEUNIT";
    public static final String ATTR_MASSIF_DETAILEDFREQ = "org.eclipse.linuxtools.valgrind.massif.MASSIF_DETAILEDFREQ";
    public static final String ATTR_MASSIF_MAXSNAPSHOTS = "org.eclipse.linuxtools.valgrind.massif.MASSIF_MAXSNAPSHOTS";
    public static final String ATTR_MASSIF_ALIGNMENT = "org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT";
    protected boolean isInitializing = false;
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MassifToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            MassifToolPage.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        this.heapButton = new Button(composite3, 32);
        this.heapButton.setText(Messages.getString("MassifToolPage.profile_heap"));
        this.heapButton.addSelectionListener(this.selectListener);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite4, 0);
        label.setText(Messages.getString("MassifToolPage.administrative_bytes"));
        this.heapAdminSpinner = new Spinner(composite4, 2048);
        this.heapAdminSpinner.addModifyListener(this.modifyListener);
        Composite composite5 = new Composite(composite2, 0);
        composite5.setLayout((Layout)new GridLayout(2, false));
        this.stacksButton = new Button(composite5, 32);
        this.stacksButton.setText(Messages.getString("MassifToolPage.profile_stack"));
        this.stacksButton.addSelectionListener(this.selectListener);
        Composite composite6 = new Composite(composite2, 0);
        composite6.setLayout((Layout)new GridLayout(2, false));
        Label label2 = new Label(composite6, 0);
        label2.setText(Messages.getString("MassifToolPage.allocation_tree_depth"));
        this.depthSpinner = new Spinner(composite6, 2048);
        this.depthSpinner.addModifyListener(this.modifyListener);
        Composite composite7 = new Composite(composite2, 0);
        composite7.setLayout((Layout)new GridLayout(3, false));
        Label label3 = new Label(composite7, 0);
        label3.setText(Messages.getString("MassifToolPage.heap_allocation_threshold"));
        this.thresholdSpinner = new Spinner(composite7, 2048);
        this.thresholdSpinner.setDigits(1);
        this.thresholdSpinner.setMaximum(1000);
        this.thresholdSpinner.addModifyListener(this.modifyListener);
        Label label4 = new Label(composite7, 0);
        label4.setText("%");
        Composite composite8 = new Composite(composite2, 0);
        composite8.setLayout((Layout)new GridLayout(3, false));
        Label label5 = new Label(composite8, 0);
        label5.setText(Messages.getString("MassifToolPage.allocation_peak_inaccuracy"));
        this.peakInaccuracySpinner = new Spinner(composite8, 2048);
        this.peakInaccuracySpinner.setDigits(1);
        this.peakInaccuracySpinner.setMaximum(1000);
        this.peakInaccuracySpinner.addModifyListener(this.modifyListener);
        Label label6 = new Label(composite8, 0);
        label6.setText("%");
        Composite composite9 = new Composite(composite2, 0);
        composite9.setLayout((Layout)new GridLayout(2, false));
        Label label7 = new Label(composite9, 0);
        label7.setText(Messages.getString("MassifToolPage.time_unit"));
        this.timeUnitCombo = new Combo(composite9, 8);
        String[] stringArray = new String[]{Messages.getString("MassifToolPage.instructions"), Messages.getString("MassifToolPage.milliseconds"), Messages.getString("MassifToolPage.bytes")};
        this.timeUnitCombo.setItems(stringArray);
        this.timeUnitCombo.addSelectionListener(this.selectListener);
        Composite composite10 = new Composite(composite2, 0);
        composite10.setLayout((Layout)new GridLayout(2, false));
        Label label8 = new Label(composite10, 0);
        label8.setText(Messages.getString("MassifToolPage.detailed_snapshot_freq"));
        this.detailedFreqSpinner = new Spinner(composite10, 2048);
        this.detailedFreqSpinner.setMaximum(Integer.MAX_VALUE);
        this.detailedFreqSpinner.addModifyListener(this.modifyListener);
        Composite composite11 = new Composite(composite2, 0);
        composite11.setLayout((Layout)new GridLayout(2, false));
        Label label9 = new Label(composite11, 0);
        label9.setText(Messages.getString("MassifToolPage.max_snapshots"));
        this.maxSnapshotsSpinner = new Spinner(composite11, 2048);
        this.maxSnapshotsSpinner.setMaximum(Integer.MAX_VALUE);
        this.maxSnapshotsSpinner.addModifyListener(this.modifyListener);
        Composite composite12 = new Composite(composite2, 0);
        composite12.setLayout((Layout)new GridLayout(2, false));
        Label label10 = new Label(composite12, 0);
        label10.setText(Messages.getString("MassifToolPage.minimum_heap_block"));
        this.alignmentSpinner = new PowerOfTwoSpinner(composite12, 2048);
        this.alignmentSpinner.setMinimum(8);
        this.alignmentSpinner.setMaximum(4096);
        this.alignmentSpinner.addModifyListener(this.modifyListener);
        Composite composite13 = new Composite(composite2, 0);
        composite13.setLayout((Layout)new GridLayout(3, false));
        composite13.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label label11 = new Label(composite13, 0);
        label11.setText(Messages.getString("MassifToolPage.allocation_functions"));
        label11.setLayoutData((Object)new GridData(1, 1, false, false));
        this.createAllocFnControls(composite13);
        scrolledComposite.setContent((Control)composite2);
        scrolledComposite.setMinSize(composite2.computeSize(-1, -1));
    }

    private void createAllocFnControls(Composite composite) {
        this.allocFnList = new org.eclipse.swt.widgets.List(composite, 2818);
        FontMetrics fontMetrics = MassifPlugin.getFontMetrics((Control)this.allocFnList);
        this.allocFnList.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)50), Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)5)));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1, 1, false, false));
        Button button = new Button(composite2, 8);
        button.setText(Messages.getString("MassifToolPage.New"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MassifToolPage.this.handleNewButtonPressed();
                MassifToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText(Messages.getString("MassifToolPage.Remove"));
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MassifToolPage.this.handleRemoveButtonPressed();
                MassifToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.removeButton.setEnabled(false);
    }

    protected void handleNewButtonPressed() {
        String string;
        InputDialog inputDialog = new InputDialog(this.getShell(), Messages.getString("MassifToolPage.New_Allocation_Function"), Messages.getString("MassifToolPage.Function_name"), "", null);
        if (inputDialog.open() == 0 && !(string = inputDialog.getValue()).equals("")) {
            this.allocFnList.add(string);
            this.removeButton.setEnabled(true);
        }
    }

    protected void handleRemoveButtonPressed() {
        int[] nArray = this.allocFnList.getSelectionIndices();
        this.allocFnList.remove(nArray);
        if (this.allocFnList.getItemCount() == 0) {
            this.removeButton.setEnabled(false);
        }
    }

    public String getName() {
        return Messages.getString("MassifToolPage.Massif_Options");
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.isInitializing = true;
        try {
            this.heapButton.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_HEAP, true));
            this.heapAdminSpinner.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_HEAPADMIN, 8));
            this.stacksButton.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_STACKS, false));
            this.depthSpinner.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_DEPTH, 30));
            List list = iLaunchConfiguration.getAttribute(ATTR_MASSIF_ALLOCFN, Collections.EMPTY_LIST);
            this.allocFnList.setItems(list.toArray(new String[list.size()]));
            this.thresholdSpinner.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_THRESHOLD, 10));
            this.peakInaccuracySpinner.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_PEAKINACCURACY, 10));
            String string = iLaunchConfiguration.getAttribute(ATTR_MASSIF_TIMEUNIT, TIME_I);
            if (string.equals(TIME_I)) {
                this.timeUnitCombo.select(0);
            } else if (string.equals(TIME_MS)) {
                this.timeUnitCombo.select(1);
            } else {
                this.timeUnitCombo.select(2);
            }
            this.detailedFreqSpinner.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_DETAILEDFREQ, 10));
            this.maxSnapshotsSpinner.setSelection(iLaunchConfiguration.getAttribute(ATTR_MASSIF_MAXSNAPSHOTS, 100));
            int n = iLaunchConfiguration.getAttribute(ATTR_MASSIF_ALIGNMENT, 8);
            this.alignmentSpinner.setSelection(n);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_HEAP, this.heapButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_HEAPADMIN, this.heapAdminSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_STACKS, this.stacksButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_DEPTH, this.depthSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_ALLOCFN, Arrays.asList(this.allocFnList.getItems()));
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_THRESHOLD, this.thresholdSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_PEAKINACCURACY, this.peakInaccuracySpinner.getSelection());
        int n = this.timeUnitCombo.getSelectionIndex();
        String string = n == 0 ? TIME_I : (n == 1 ? TIME_MS : TIME_B);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_TIMEUNIT, string);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_DETAILEDFREQ, this.detailedFreqSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_MAXSNAPSHOTS, this.maxSnapshotsSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_ALIGNMENT, this.alignmentSpinner.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_HEAP, true);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_HEAPADMIN, 8);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_STACKS, false);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_DEPTH, 30);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_ALLOCFN, Collections.EMPTY_LIST);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_THRESHOLD, 10);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_PEAKINACCURACY, 10);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_TIMEUNIT, TIME_I);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_DETAILEDFREQ, 10);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_MAXSNAPSHOTS, 100);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_MASSIF_ALIGNMENT, 8);
    }

    protected void createHorizontalSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }
}

