/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.ui.TizenLaunchDeviceSelectionDialog;
import org.tizen.profiler.codecoverage.CommandManager;
import org.tizen.profiler.codecoverage.CoverageUtil;
import org.tizen.profiler.codecoverage.ui.AnnotateSource;
import org.tizen.profiler.codecoverage.ui.ViewInitializer;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.util.DeviceUtil;

public class LaunchDelegate
extends TizenLaunchDelegate {
    boolean isOSWindows = System.getProperty("os.name").startsWith("Windows");
    private boolean isPrePostbuildStep = false;
    public static String SDK_TOOLS_FILEPATH = String.valueOf(InstallPathConfig.getSDKPath()) + File.separator + "tools" + File.separator;
    protected static final String LAUNCHPAD_LAUNCHER = "launch_app ";
    protected static final String LAUNCHPAD_SYNCMODE = " __AUL_SDK__ Coverage ";
    private static final String RemoveOldCoverage = "su -c \"rm -f /tmp/default.profraw\"";
    private static final String RemoveOldCoverage30 = "rm -f /opt/usr/home/owner/share/tmp/sdk_tools/default.profraw";
    protected IProject project;
    private String SBI_COMPILER_PATH;

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        this.SBI_COMPILER_PATH = this.expandEnvVariables("${SBI_COMPILER_PATH}");
        if (this.SBI_COMPILER_PATH.contains("gcc")) {
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"Profiling for Code Coverage is not enabled in GCC complier. Please change the compiler to LLVM and rerun.", null);
            return false;
        }
        CommonConfigurationManager.setMiscToolOptions((String)"-fprofile-instr-generate -fcoverage-mapping");
        boolean bl = super.buildForLaunch(iLaunchConfiguration, string, iProgressMonitor);
        CommonConfigurationManager.setMiscToolOptions((String)"");
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void launch(ILaunchConfiguration var1_1, String var2_2, ILaunch var3_3, IProgressMonitor var4_4) throws CoreException {
        if (var4_4 == null) {
            var4_4 = new NullProgressMonitor();
        }
        this.SBI_COMPILER_PATH = this.expandEnvVariables("${SBI_COMPILER_PATH}");
        if (this.SBI_COMPILER_PATH.contains("gcc")) {
            return;
        }
        if (ProfileLaunchPlugin.isProfiling()) {
            var4_4.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"Another instance of Code Coverage is running. Please rerun after terminating the application.", null);
            return;
        }
        var5_5 = ProfileLaunchPlugin.checkTarget();
        if (var5_5 == 0) {
            var4_4.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"No device is connected", null);
            return;
        }
        var6_6 = ManagedBuildManager.getBuildInfo((IResource)this.project);
        var7_7 = var6_6.getDefaultConfiguration();
        if (var7_7.getName() == "Release") {
            var4_4.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"Set Active Build Configuration to Debug", null);
            return;
        }
        var8_8 = ConnectionPlugin.getDefault().getCurrentDevice();
        try {
            var9_9 = null;
            var9_9 = this.FindVersion(var8_8);
            if (var9_9 == null) {
                return;
            }
            if (!this.IsGreaterThanEqual(var9_9, "3.0")) {
                var8_8.executeShellCommand("rm -f /opt/usr/home/owner/share/tmp/sdk_tools/default.profraw", false);
            } else {
                var8_8.executeShellCommand("su -c \"rm -f /tmp/default.profraw\"", false);
                var8_8.executeShellCommand("su -c \"rm -f /home/developer/default.profraw\"", false);
            }
        }
        catch (IOException var9_10) {
            var9_10.printStackTrace();
        }
        try {
            ProfileLaunchPlugin.startProfiling();
            this.project = ProjectUtil.getProject((ILaunchConfiguration)var1_1);
            if (ProjectUtil.getTizenProjectType((IProject)this.project) != null) {
                if (ProjectUtil.getTizenProjectType((IProject)this.project).isNativeProject()) {
                    if (ProjectUtil.getTizenProjectType((IProject)this.project).isImeProject()) {
                        this.newCoreException("Profiling of IME application is not supported.", null);
                    }
                    var4_4.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 30);
                    this.activateProgressView();
                    LaunchUtils.verifyExecutableProject((IProject)ProjectUtil.getProject((ILaunchConfiguration)var1_1));
                    this.verifyCProjectConfigurationSettings(var1_1);
                    this.verifyDeviceReachability(var1_1, new SubProgressMonitor(var4_4, 9));
                    this.verifyBuildConfiguration(var1_1, var2_2, (IProgressMonitor)new SubProgressMonitor(var4_4, 11));
                    this.setConsole(var1_1);
                    this.tizenCommand = new TizenLaunchCommand(this.currentDevice, (ConsoleManager)this.launchConsole);
                    this.launchConsole.show();
                    if (var2_2.equals("profile")) {
                        this.deployApplication(var1_1, (IProgressMonitor)new SubProgressMonitor(var4_4, 9));
                        var4_4.worked(1);
                        var9_9 = this.project.getLocation().toOSString();
                        var10_11 = String.valueOf(var9_9) + File.separator + "Debug" + File.separator;
                        var11_12 = new File(var10_11);
                        this.cleanCov(var11_12);
                        this.launchApplicationWithCoverage(var3_3, var1_1, var4_4);
                    }
                    this.newCoreException("The profiling failed because the application was terminated abnormally", null);
                }
                ProjectUtil.getTizenProjectType((IProject)this.project).isWebProject();
            }
        }
        finally {
            var13_15 = this.project.getLocation().toOSString();
            var14_17 = String.valueOf(var13_15) + File.separator + "Debug" + File.separator;
            var15_19 = new File(var14_17);
            this.GenerateCoverageInfo(var8_8, var14_17);
            this.GenerateCovData(var14_17);
            this.GenerateCovReport(var15_19);
            var16_21 = null;
            var21_26 = var17_23 = this.project.getReferencedProjects();
            var20_29 = var17_23.length;
            var19_33 = 0;
            if (true) ** GOTO lbl90
        }
        {
        }
        do {
            var18_37 = var21_26[var19_33];
            var16_21 = String.valueOf(var18_37.getLocation().toOSString()) + File.separator + "Debug" + File.separator;
            var22_39 = new File(var16_21);
            this.CopyCoverageInfo(var14_17, var16_21);
            this.GenerateCovReport((File)var22_39);
            ++var19_33;
lbl90:
            // 2 sources

        } while (var19_33 < var20_29);
        var18_37 = new ViewInitializer(this.project);
        var18_37.init(String.valueOf(var13_15) + File.separator + "Coverage_Report" + File.separator + "report.txt");
        this.annotateAllProjects(this.project, var8_8);
        var22_39 = var17_23;
        var21_27 = var17_23.length;
        var20_29 = 0;
        while (var20_29 < var21_27) {
            var19_34 = var22_39[var20_29];
            this.annotateAllProjects(var19_34, var8_8);
            ++var20_29;
        }
        var3_3.terminate();
        var19_35 = DebugPlugin.getDefault().getLaunchManager();
        var19_35.removeLaunch(var3_3);
        var4_4.done();
        ProfileLaunchPlugin.stopProfiling();
    }

    public void CopyCoverageInfo(String string, String string2) {
        File file = new File(String.valueOf(string) + File.separator + "coverage.profdata");
        File file2 = new File(String.valueOf(string2) + File.separator + "coverage.profdata");
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void annotateAllProjects(IProject iProject, IDevice iDevice) {
        String string = iProject.getLocation().toOSString();
        AnnotateSource annotateSource = new AnnotateSource();
        annotateSource.populate(string);
    }

    protected Arch getBuildConfigurationArchitecture(IProject iProject, String string) throws CoreException {
        IConfiguration iConfiguration = this.getBuildConfiguration(string, iProject);
        IProjectLaunchCommand iProjectLaunchCommand = ProjectUtil.getProjectManifest((IProject)iProject);
        String string2 = iProjectLaunchCommand.getArchitecture(iConfiguration);
        if (LaunchUtils.isX86((String)string2)) {
            return Arch.X86;
        }
        return Arch.ARM;
    }

    protected Arch getBuildConfigurationArchitecture(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getBuildConfigName(iLaunchConfiguration);
        IProject iProject = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        return this.getBuildConfigurationArchitecture(iProject, string);
    }

    private IDevice[] getDeploayableDevices(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IDevice[] iDeviceArray = SmartDevelopmentBridge.getBridge().getDevices();
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        Arch arch = this.getBuildConfigurationArchitecture(iLaunchConfiguration);
        IDevice[] iDeviceArray2 = iDeviceArray;
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = iDeviceArray2[n2];
            if (iDevice.getArch() == arch) {
                arrayList.add(iDevice);
            }
            ++n2;
        }
        return arrayList.toArray(new IDevice[arrayList.size()]);
    }

    private void verifyDeviceReachability(ILaunchConfiguration iLaunchConfiguration, SubProgressMonitor subProgressMonitor) throws CoreException {
        try {
            subProgressMonitor.beginTask(TizenLaunchMessages.PREPARE_TO_LAUNCH, 1);
            subProgressMonitor.subTask(TizenLaunchMessages.PREPARE_TO_LAUNCH);
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
            final IDevice[] iDeviceArray = this.getDeploayableDevices(iLaunchConfiguration);
            IDevice iDevice = null;
            iDevice = LaunchUtils.getDeviceFromLaunchConfiguration((ILaunchConfiguration)iLaunchConfiguration, (IDevice[])iDeviceArray);
            if (iDevice == null) {
                int n = iDeviceArray.length;
                if (n == 0) {
                    this.currentDevice = null;
                } else {
                    if (n == 1) {
                        this.currentDevice = iDeviceArray[0];
                    } else {
                        SWTUtil.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                TizenLaunchDeviceSelectionDialog tizenLaunchDeviceSelectionDialog = new TizenLaunchDeviceSelectionDialog(shell, iDeviceArray);
                                LaunchDelegate.this.currentDevice = tizenLaunchDeviceSelectionDialog.open() == 0 ? tizenLaunchDeviceSelectionDialog.getSelectedDevice() : null;
                            }
                        });
                    }
                    if (this.currentDevice != null) {
                        String string = LaunchUtils.getDeviceId((IDevice)this.currentDevice);
                        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.common.launch.device.id", string);
                        iLaunchConfigurationWorkingCopy.doSave();
                    }
                }
            } else {
                this.currentDevice = iDevice;
            }
            if (this.currentDevice == null) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
            if (!DeviceUtil.isOnline((IDevice)this.currentDevice)) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private void cleanCov(File file) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja";
        ProcessBuilder processBuilder = new ProcessBuilder(string, "clean_cov");
        String string2 = this.expandEnvVariables("${PATH}");
        Map<String, String> map = processBuilder.environment();
        map.put("PATH", String.valueOf(string2) + File.pathSeparator + map.get("PATH"));
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void GenerateCovReport(File file) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja";
        String string2 = this.expandEnvVariables("${PATH}");
        ProcessBuilder processBuilder = new ProcessBuilder(string, "cov");
        Map<String, String> map = processBuilder.environment();
        map.put("PATH", String.valueOf(string2) + File.pathSeparator + map.get("PATH"));
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void GenerateCovData(String string) {
        File file = new File(String.valueOf(string) + "default.profraw");
        if (!file.exists()) {
            return;
        }
        file = new File(String.valueOf(string) + "coverage.profdata");
        if (file.exists()) {
            file.delete();
        }
        String string2 = String.valueOf(this.SBI_COMPILER_PATH) + File.separator + "llvm-profdata";
        ProcessBuilder processBuilder = new ProcessBuilder(string2, "merge", "-o", String.valueOf(string) + "coverage.profdata", String.valueOf(string) + "default.profraw");
        File file2 = new File(String.valueOf(string) + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    String FindVersion(IDevice iDevice) {
        String string = null;
        try {
            string = iDevice.getPlatformInfo().getPlatformVersion();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            sdbCommandRejectedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    boolean IsGreaterThanEqual(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        if (Integer.parseInt(stringArray2[0]) > Integer.parseInt(stringArray[0])) {
            return true;
        }
        if (Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) > Integer.parseInt(stringArray[1])) {
            return true;
        }
        return stringArray.length == 3 && stringArray2.length == 3 && Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) == Integer.parseInt(stringArray[1]) && Integer.parseInt(stringArray2[2]) > Integer.parseInt(stringArray[2]);
    }

    private void GenerateCoverageInfo(IDevice iDevice, String string) {
        if (iDevice == null) {
            return;
        }
        String string2 = null;
        string2 = this.FindVersion(iDevice);
        if (string2 == null) {
            return;
        }
        if (!this.IsGreaterThanEqual(string2, "3.0")) {
            CommandManager.runCommand("root on");
            boolean bl = CommandManager.pull("/opt/usr/home/owner/share/tmp/sdk_tools/default.profraw", string);
            if (!bl) {
                string = "";
            }
        } else {
            CommandManager.runCommand("root on");
            String string3 = "su -c \"cp /tmp/default.profraw /home/developer\"";
            try {
                iDevice.executeShellCommand(string3, false);
                Thread.sleep(500L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            boolean bl = CommandManager.pull("/home/developer/default.profraw", string);
            if (!bl) {
                string = "";
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void launchApplicationWithCoverage(ILaunch var1_1, ILaunchConfiguration var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, String string, String string2, IProgressMonitor iProgressMonitor, ConsoleManager consoleManager, String string3) throws CoverageCanceledException, CoreException {
        Process process = CommandManager.runApplication(string);
        if (process == null) {
            this.newCoreException("The profiling failed because the application was terminated abnormally", null);
        }
        while (!iProgressMonitor.isCanceled()) {
        }
        String string4 = "pkgcmd -un " + string3;
        CoverageUtil.runCommandReturningResult(string4);
    }

    public String expandEnvVariables(String string) {
        string = string.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)");
        IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
        if (string.indexOf("$(") >= 0) {
            IEnvironmentVariable[] iEnvironmentVariableArray;
            ICConfigurationDescription iCConfigurationDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)iConfiguration);
            IEnvironmentVariableManager iEnvironmentVariableManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray2 = iEnvironmentVariableArray = iEnvironmentVariableManager.getVariables(iCConfigurationDescription, true);
            int n = iEnvironmentVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray2[n2];
                string = string.replace(String.format("$(%s)", iEnvironmentVariable.getName()), iEnvironmentVariable.getValue());
                ++n2;
            }
        }
        return this.isOSWindows && !this.isPrePostbuildStep ? string.replace("\\", "/") : string;
    }

    static class CoverageCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

