/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.profiling.launch.Messages;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.tizen.common.util.ViewUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.sdblib.IDevice;

public abstract class ProfileLaunchShortcut
implements ILaunchShortcut {
    protected IDevice device = null;
    private boolean result;
    private final String PROJECT_SOURCE_CONTAINER = "Project Source mapping";
    private final String PLATFORM_SOURCE_CONTAINER = "Platform Source mapping";
    protected ISourceLookupDirector fLocator;

    public void launch(IEditorPart iEditorPart, String string) {
        this.searchAndLaunch(new Object[]{iEditorPart.getEditorInput()}, string);
    }

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string);
        }
    }

    public void launch(IBinary iBinary, String string) {
        ILaunchConfiguration iLaunchConfiguration = this.findLaunchConfiguration(iBinary, string);
        if (iLaunchConfiguration != null) {
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        }
    }

    public static void showErrorDialog(final String string, String string2, Exception exception) {
        String string3 = Messages.getString("ProfileLaunchShortcut.targetcheck");
        Status status = new Status(4, string3, 0, string2, (Throwable)exception);
        Display.getDefault().syncExec(new Runnable((IStatus)status){
            private final /* synthetic */ IStatus val$status;
            {
                this.val$status = iStatus;
            }

            @Override
            public void run() {
                ErrorDialog.openError(null, (String)"Profile Error", (String)string, (IStatus)this.val$status);
            }
        });
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary iBinary, String string) {
        Object[] objectArray;
        ILaunchConfigurationType iLaunchConfigurationType;
        IWorkbenchWindow iWorkbenchWindow;
        if (iBinary == null) {
            iWorkbenchWindow = ViewUtil.getWorkbenchWindow();
            if (iWorkbenchWindow != null && iWorkbenchWindow.getSelectionService() != null && (iLaunchConfigurationType = iWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection && (objectArray = ((IStructuredSelection)iLaunchConfigurationType).toArray()).length == 1) {
                IProject iProject = (IProject)objectArray[0];
                return this.createConfiguration(iProject, string);
            }
            ProfileLaunchShortcut.showErrorDialog("Cannot find a project name.", "Cannot find a project name.", null);
        }
        iWorkbenchWindow = null;
        iLaunchConfigurationType = this.getLaunchConfigType();
        objectArray = LaunchUtils.getCurrentDeployDevice();
        List<ILaunchConfiguration> list = Collections.emptyList();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            list = new ArrayList(iLaunchConfigurationArray.length);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n];
                String string2 = iLaunchConfiguration.getAttribute("org.tizen.common.launch.device.id", "");
                String string3 = LaunchUtils.getDeviceId((IDevice)objectArray);
                IPath iPath = AbstractCLaunchDelegate.getProgramPath((ILaunchConfiguration)iLaunchConfiguration);
                String string4 = AbstractCLaunchDelegate.getProjectName((ILaunchConfiguration)iLaunchConfiguration);
                if (iBinary != null) {
                    IPath iPath2 = iBinary.getResource().getProjectRelativePath();
                    if (iPath != null && iPath.equals((Object)iPath2) && string4 != null && string4.equals(iBinary.getCProject().getProject().getName()) && string2.equals(string3)) {
                        list.add(iLaunchConfiguration);
                    }
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        int n = list.size();
        if (n < 1) {
            if (iBinary != null) {
                iWorkbenchWindow = this.createConfiguration(iBinary);
            }
        } else {
            iWorkbenchWindow = n == 1 ? (ILaunchConfiguration)list.get(0) : this.chooseConfiguration(list, string);
        }
        return iWorkbenchWindow;
    }

    protected abstract ILaunchConfigurationType getLaunchConfigType();

    protected abstract void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    protected ILaunchConfiguration createConfiguration(IBinary iBinary) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            String string = iBinary.getResource().getProjectRelativePath().toString();
            ILaunchConfigurationType iLaunchConfigurationType = this.getLaunchConfigType();
            if (iLaunchConfigurationType != null) {
                IDevice iDevice = LaunchUtils.getCurrentDeployDevice();
                ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iBinary.getElementName()));
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", string);
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", iBinary.getCProject().getElementName());
                iLaunchConfigurationWorkingCopy.setMappedResources(new IResource[]{iBinary.getResource(), iBinary.getResource().getProject()});
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                this.setDefaultProfileAttributes(iLaunchConfigurationWorkingCopy);
                ICProjectDescription iCProjectDescription = CCorePlugin.getDefault().getProjectDescription(iBinary.getCProject().getProject());
                if (iCProjectDescription != null) {
                    String string2 = iCProjectDescription.getActiveConfiguration().getId();
                    iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", string2);
                    String string3 = iCProjectDescription.getActiveConfiguration().getName();
                    iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", string3);
                    LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)iLaunchConfigurationWorkingCopy, (IDevice)iDevice);
                }
                iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfiguration createConfiguration(IProject iProject, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            String string2;
            String string3 = iProject.getName();
            ILaunchConfigurationType iLaunchConfigurationType = this.getLaunchConfigType();
            IDevice iDevice = LaunchUtils.getCurrentDeployDevice();
            IProject iProject2 = iProject;
            String string4 = ProjectUtil.getLaunchConfigurationName((IProject)iProject2);
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(string4));
            if (ProjectUtil.getDefaultConfiguration((IProject)iProject) != null) {
                string2 = String.valueOf(ProjectUtil.getDefaultConfiguration((IProject)iProject).getName()) + File.separatorChar + ProjectUtil.getBinaryName((IProject)iProject);
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", string2);
            }
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", string3);
            iLaunchConfigurationWorkingCopy.setMappedResources(new IResource[]{iProject});
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            this.setDefaultProfileAttributes(iLaunchConfigurationWorkingCopy);
            string2 = CCorePlugin.getDefault().getProjectDescription(iProject);
            if (string2 != null) {
                String string5 = string2.getActiveConfiguration().getId();
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", string5);
                String string6 = string2.getActiveConfiguration().getName();
                iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", string6);
                LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)iLaunchConfigurationWorkingCopy, (IDevice)iDevice);
            }
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private void searchAndLaunch(Object[] objectArray, String string) {
        if (objectArray != null && objectArray.length > 0) {
            IBinary iBinary = null;
            this.launch(iBinary, string);
        } else {
            this.handleFail(Messages.getString("ProfileLaunchShortcut.no_project_selected"));
        }
    }

    protected void handleFail(String string) {
        MessageDialog.openError((Shell)this.getActiveWorkbenchShell(), (String)Messages.getString("ProfileLaunchShortcut.Valgrind_Launcher"), (String)string);
    }

    protected IBinary chooseBinary(List<IBinary> list, String string) {
        CElementLabelProvider cElementLabelProvider = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(iBinary.getPath().lastSegment());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        CElementLabelProvider cElementLabelProvider2 = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(String.valueOf(iBinary.getCPU()) + (iBinary.isLittleEndian() ? "le" : "be"));
                    stringBuffer.append(" - ");
                    stringBuffer.append(iBinary.getPath().toString());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(this.getActiveWorkbenchShell(), (ILabelProvider)cElementLabelProvider, (ILabelProvider)cElementLabelProvider2);
        twoPaneElementSelector.setElements(list.toArray());
        twoPaneElementSelector.setTitle(Messages.getString("ProfileLaunchShortcut.Profile_With_Valgrind"));
        twoPaneElementSelector.setMessage(Messages.getString("ProfileLaunchShortcut.Choose_a_local_application"));
        twoPaneElementSelector.setUpperListLabel(Messages.getString("ProfileLaunchShortcut.Binaries"));
        twoPaneElementSelector.setLowerListLabel(Messages.getString("ProfileLaunchShortcut.Qualifier"));
        twoPaneElementSelector.setMultipleSelection(false);
        if (twoPaneElementSelector.open() == 0) {
            return (IBinary)twoPaneElementSelector.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(Messages.getString("ProfileLaunchShortcut.Launch_Configuration_Selection"));
        elementListSelectionDialog.setMessage(Messages.getString("ProfileLaunchShortcut.Choose_a_launch_configuration"));
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected Shell getActiveWorkbenchShell() {
        return ProfileLaunchPlugin.getActiveWorkbenchShell();
    }
}

