/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck.model;

import java.util.ArrayList;
import org.eclipse.linuxtools.valgrind.memcheck.MemcheckPlugin;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.memcheck.model.StackFrameTreeElement;
import org.eclipse.swt.graphics.Image;

public abstract class ValgrindTreeElement {
    protected static final Image ERROR_IMG = ValgrindTreeElement.createErrorImage();
    protected ValgrindTreeElement parent;
    protected ArrayList<ValgrindTreeElement> children;

    private static Image createErrorImage() {
        if (MemcheckPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.memcheck", (String)"icons/warning.gif") != null) {
            return MemcheckPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.memcheck", (String)"icons/warning.gif").createImage();
        }
        return null;
    }

    public ValgrindTreeElement getParent() {
        return this.parent;
    }

    public ValgrindTreeElement[] getChildren() {
        return this.children.toArray(new ValgrindTreeElement[this.children.size()]);
    }

    public abstract String getText();

    public abstract Image getImage();

    protected void createStackElements(ArrayList<ValgrindStackFrame> arrayList) {
        if (arrayList.size() > 0) {
            this.children.add(new StackFrameTreeElement(this, arrayList.get(0), true));
            int n = 1;
            while (n < arrayList.size()) {
                this.children.add(new StackFrameTreeElement(this, arrayList.get(n)));
                ++n;
            }
        }
    }
}

