/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.ui.TizenLaunchDeviceSelectionDialog;
import org.tizen.profiler.codecoverage.CommandManager;
import org.tizen.profiler.codecoverage.CoverageUtil;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.DeviceUtil;

public class LaunchDelegate
extends TizenLaunchDelegate {
    protected static final String LAUNCHPAD_LAUNCHER = "launch_app ";
    protected static final String LAUNCHPAD_SYNCMODE = " __AUL_SDK__ Coverage ";
    private static final String RemoveOldCoverage = "su -c \"rm -f /tmp/default.profraw\"";
    private static final String RemoveOldCoverage30 = "rm -f /opt/usr/home/owner/share/tmp/sdk_tools/default.profraw";
    protected IProject project;
    private String SBI_COMPILER_PATH;
    private int apiversion;

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        IXMLStore iXMLStore = ProjectUtil.getXmlStore((IProject)this.project);
        iXMLStore.setProject(this.project);
        iXMLStore.loadXml();
        this.apiversion = (int)Double.parseDouble(iXMLStore.getApiVersion());
        this.SBI_COMPILER_PATH = CoverageUtil.expandEnvVariables("${SBI_COMPILER_PATH}", this.project);
        if (this.apiversion <= 9 && this.SBI_COMPILER_PATH.contains("llvm")) {
            CommonConfigurationManager.setMiscToolOptions((String)"-fprofile-instr-generate -fcoverage-mapping");
        } else if (this.apiversion >= 10 && this.SBI_COMPILER_PATH.contains("gcc")) {
            CommonConfigurationManager.setMiscToolOptions((String)"-fprofile-arcs -ftest-coverage --coverage");
        } else {
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"check compiler type and tizen version", null);
            return false;
        }
        boolean bl = super.buildForLaunch(iLaunchConfiguration, string, iProgressMonitor);
        CommonConfigurationManager.setMiscToolOptions((String)"");
        return bl;
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        this.SBI_COMPILER_PATH = CoverageUtil.expandEnvVariables("${SBI_COMPILER_PATH}", this.project);
        if (this.apiversion <= 9 && !this.SBI_COMPILER_PATH.contains("llvm") || this.apiversion >= 10 && !this.SBI_COMPILER_PATH.contains("gcc")) {
            return;
        }
        if (ProfileLaunchPlugin.isProfiling()) {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"Another instance of Code Coverage is running. Please rerun after terminating the application.", null);
            return;
        }
        int n = ProfileLaunchPlugin.checkTarget();
        if (n == 0) {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"No device is connected", null);
            return;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.project);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        if (iConfiguration.getName() == "Release") {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)"Cannot run Code Coverage", (String)"Set Active Build Configuration to Debug", null);
            return;
        }
        IDevice iDevice = ConnectionPlugin.getDefault().getCurrentDevice();
        try {
            string2 = null;
            string2 = CoverageUtil.FindVersion(iDevice);
            if (string2 == null) {
                return;
            }
            if (!CoverageUtil.IsGreaterThanEqual(string2, "3.0")) {
                iDevice.executeShellCommand(RemoveOldCoverage30, false);
            } else {
                iDevice.executeShellCommand(RemoveOldCoverage, false);
                iDevice.executeShellCommand("su -c \"rm -f /home/developer/default.profraw\"", false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            ProfileLaunchPlugin.startProfiling();
            this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
            if (ProjectUtil.getTizenProjectType((IProject)this.project) != null) {
                if (ProjectUtil.getTizenProjectType((IProject)this.project).isNativeProject()) {
                    if (ProjectUtil.getTizenProjectType((IProject)this.project).isImeProject()) {
                        this.newCoreException("Profiling of IME application is not supported.", null);
                    }
                    iProgressMonitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 30);
                    this.activateProgressView();
                    LaunchUtils.verifyExecutableProject((IProject)ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration));
                    this.verifyCProjectConfigurationSettings(iLaunchConfiguration);
                    this.verifyDeviceReachability(iLaunchConfiguration, new SubProgressMonitor(iProgressMonitor, 9));
                    this.verifyBuildConfiguration(iLaunchConfiguration, string, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 11));
                    this.setConsole(iLaunchConfiguration);
                    this.tizenCommand = new TizenLaunchCommand(this.currentDevice, (ConsoleManager)this.launchConsole);
                    this.launchConsole.show();
                    if (string.equals("profile")) {
                        this.deployApplication(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 9));
                        iProgressMonitor.worked(1);
                        string2 = this.project.getLocation().toOSString();
                        IManagedBuildInfo iManagedBuildInfo2 = ManagedBuildManager.getBuildInfo((IResource)this.project);
                        String string3 = iManagedBuildInfo2.getConfigurationName();
                        String string4 = String.valueOf(string2) + File.separator + string3 + File.separator;
                        File file = new File(string4);
                        CoverageUtil.cleanCov(file, this.project);
                        this.launchApplicationWithCoverage(iLaunch, iLaunchConfiguration, iProgressMonitor);
                    } else {
                        this.newCoreException("The profiling failed because the application was terminated abnormally", null);
                    }
                } else {
                    ProjectUtil.getTizenProjectType((IProject)this.project).isWebProject();
                }
            }
        }
        finally {
            CoverageUtil.generateCoverageReports(iDevice, this.project);
            iLaunch.terminate();
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            iLaunchManager.removeLaunch(iLaunch);
            iProgressMonitor.done();
            ProfileLaunchPlugin.stopProfiling();
        }
    }

    protected Arch getBuildConfigurationArchitecture(IProject iProject, String string) throws CoreException {
        IConfiguration iConfiguration = this.getBuildConfiguration(string, iProject);
        IProjectLaunchCommand iProjectLaunchCommand = ProjectUtil.getProjectManifest((IProject)iProject);
        String string2 = iProjectLaunchCommand.getArchitecture(iConfiguration);
        if (LaunchUtils.isX86((String)string2)) {
            return Arch.X86;
        }
        return Arch.ARM;
    }

    protected Arch getBuildConfigurationArchitecture(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getBuildConfigName(iLaunchConfiguration);
        IProject iProject = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        return this.getBuildConfigurationArchitecture(iProject, string);
    }

    private IDevice[] getDeploayableDevices(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IDevice[] iDeviceArray = SmartDevelopmentBridge.getBridge().getDevices();
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        Arch arch = this.getBuildConfigurationArchitecture(iLaunchConfiguration);
        IDevice[] iDeviceArray2 = iDeviceArray;
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = iDeviceArray2[n2];
            if (iDevice.getArch() == arch) {
                arrayList.add(iDevice);
            }
            ++n2;
        }
        return arrayList.toArray(new IDevice[arrayList.size()]);
    }

    private void verifyDeviceReachability(ILaunchConfiguration iLaunchConfiguration, SubProgressMonitor subProgressMonitor) throws CoreException {
        try {
            subProgressMonitor.beginTask(TizenLaunchMessages.PREPARE_TO_LAUNCH, 1);
            subProgressMonitor.subTask(TizenLaunchMessages.PREPARE_TO_LAUNCH);
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
            final IDevice[] iDeviceArray = this.getDeploayableDevices(iLaunchConfiguration);
            IDevice iDevice = null;
            iDevice = LaunchUtils.getDeviceFromLaunchConfiguration((ILaunchConfiguration)iLaunchConfiguration, (IDevice[])iDeviceArray);
            if (iDevice == null) {
                int n = iDeviceArray.length;
                if (n == 0) {
                    this.currentDevice = null;
                } else {
                    if (n == 1) {
                        this.currentDevice = iDeviceArray[0];
                    } else {
                        SWTUtil.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                TizenLaunchDeviceSelectionDialog tizenLaunchDeviceSelectionDialog = new TizenLaunchDeviceSelectionDialog(shell, iDeviceArray);
                                LaunchDelegate.this.currentDevice = tizenLaunchDeviceSelectionDialog.open() == 0 ? tizenLaunchDeviceSelectionDialog.getSelectedDevice() : null;
                            }
                        });
                    }
                    if (this.currentDevice != null) {
                        String string = LaunchUtils.getDeviceId((IDevice)this.currentDevice);
                        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.common.launch.device.id", string);
                        iLaunchConfigurationWorkingCopy.doSave();
                    }
                }
            } else {
                this.currentDevice = iDevice;
            }
            if (this.currentDevice == null) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
            if (!DeviceUtil.isOnline((IDevice)this.currentDevice)) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
        }
        finally {
            subProgressMonitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    protected void launchApplicationWithCoverage(ILaunch var1_1, ILaunchConfiguration var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, String string, String string2, IProgressMonitor iProgressMonitor, ConsoleManager consoleManager, String string3) throws CoverageCanceledException, CoreException {
        Process process = CommandManager.runApplication(string);
        if (process == null) {
            this.newCoreException("The profiling failed because the application was terminated abnormally", null);
        }
        while (!iProgressMonitor.isCanceled()) {
        }
        String string4 = "pkgcmd -un " + string3;
        CoverageUtil.runCommandReturningResult(string4);
    }

    static class CoverageCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

