/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;
import org.tizen.profiler.codecoverage.CoverageUtil;
import org.tizen.profiler.codecoverage.ui.FileInfo;
import org.tizen.profiler.codecoverage.ui.HtmlReportGenerator;
import org.tizen.profiler.codecoverage.ui.PaintListener;
import org.tizen.profiler.codecoverage.ui.ProjectInfo;
import org.tizen.profiler.codecoverage.ui.TotalReportGenerator;
import org.tizen.profiler.codecoverage.ui.TreeViewerDoubleClickListener;
import org.tizen.profiler.preference.CoveragePreferencePage;
import org.tizen.sdblib.util.IOUtil;

public class CovLaunchTab
extends ViewPart {
    public static final String ID = "codecoverage.ui.CovLaunchTab";
    private static TabFolder tabs;
    private Tree tree;
    TreeColumn firstColumn;
    TreeColumn secondColumn;
    TreeColumn thirdColumn;
    TreeColumn fourthColumn;
    TreeColumn fifthColumn;
    TreeColumn emptyColumn;
    TreeColumn invisibleColumn;
    private static int COLUMNONE;
    private static int COLUMNTWO;
    private static int COLUMNTHREE;
    private static int COLUMNFIVE;
    private static int COLUMNSIX;
    Point TabSize;

    static {
        COLUMNONE = 0;
        COLUMNTWO = 1;
        COLUMNTHREE = 2;
        COLUMNFIVE = 4;
        COLUMNSIX = 6;
    }

    public TabFolder getTab() {
        return tabs;
    }

    public void setTab(TabFolder tabFolder) {
        tabs = tabFolder;
    }

    private void setTree(Tree tree) {
        this.tree = tree;
    }

    public void createPartControl(Composite composite) {
        TabFolder tabFolder = new TabFolder(composite, 2048);
        this.setTab(tabFolder);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("code coverage");
        this.tree = new Tree((Composite)tabs, 2816);
        this.firstColumn = new TreeColumn(this.tree, 16384);
        this.firstColumn.setText("Name");
        this.secondColumn = new TreeColumn(this.tree, 0x1000000);
        this.secondColumn.setText("Lines");
        this.thirdColumn = new TreeColumn(this.tree, 0x1000000);
        this.thirdColumn.setText("Miss");
        this.fourthColumn = new TreeColumn(this.tree, 0x1000000);
        this.fourthColumn.setText("Coverage");
        this.fifthColumn = new TreeColumn(this.tree, 0x1000000);
        this.fifthColumn.setText("%");
        this.emptyColumn = new TreeColumn(this.tree, 0);
        this.invisibleColumn = new TreeColumn(this.tree, 0);
        this.setTree(this.tree);
        tabFolder.setLayout((Layout)new FillLayout());
    }

    public ProjectInfo processLines(String string, IProject iProject) {
        ProjectInfo projectInfo;
        block11: {
            projectInfo = new ProjectInfo(0, 0, 0, 0.0f, null);
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(string));
                    String string2 = iProject.getLocation().toString();
                    string2 = string2.replace('\\', '/');
                    String string3 = null;
                    String[] stringArray = new String[5];
                    string3 = bufferedReader.readLine();
                    block4: while (string3 != null) {
                        if (string3.startsWith("File ")) {
                            string3 = string3.replace('\\', '/');
                            String[] stringArray2 = string3.split("\\'");
                            FileInfo fileInfo = null;
                            String string4 = stringArray2[1].trim().substring(string2.length() + 1);
                            fileInfo = new FileInfo(string4, 0, 0, 0, 0, 0.0f, true);
                            projectInfo.addFileInfo(fileInfo);
                            string3 = bufferedReader.readLine();
                            while (string3 != null) {
                                if (string3.startsWith("Name") || string3.startsWith("----")) {
                                    string3 = bufferedReader.readLine();
                                    continue;
                                }
                                if (string3.isEmpty()) continue block4;
                                String string5 = new StringBuffer(string3).reverse().toString();
                                String[] stringArray3 = string5.split(":", 5);
                                int n = 0;
                                while (n < 5) {
                                    stringArray[4 - n] = new StringBuffer(stringArray3[n]).reverse().toString();
                                    ++n;
                                }
                                n = Integer.parseInt(stringArray[COLUMNTWO].trim());
                                int n2 = Integer.parseInt(stringArray[COLUMNTHREE].trim());
                                float f = Float.parseFloat(stringArray[COLUMNFIVE].split("%")[0].trim());
                                if (stringArray[COLUMNONE].trim().equals("TOTAL")) {
                                    fileInfo.setLineCount(n);
                                    fileInfo.setMissCount(n2);
                                    fileInfo.setPercent(f);
                                    projectInfo.setLineCount(n + projectInfo.getLineCount());
                                    projectInfo.setMissCount(n2 + projectInfo.getMissCount());
                                    continue block4;
                                }
                                int n3 = Integer.parseInt(stringArray[COLUMNFIVE - 1].trim());
                                FileInfo fileInfo2 = new FileInfo(stringArray[COLUMNONE].trim(), 0, n, n2, n3, f, false);
                                projectInfo.addFileInfo(fileInfo2);
                                string3 = bufferedReader.readLine();
                            }
                            continue;
                        }
                        string3 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    IOUtil.tryClose(bufferedReader);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(bufferedReader);
                throw throwable;
            }
            IOUtil.tryClose((Closeable)bufferedReader);
        }
        return projectInfo;
    }

    public void generateTree(TabFolder tabFolder, IProject iProject, ArrayList<IProject> arrayList) throws CoreException, IOException {
        Object object;
        ArrayList<Object> arrayList2 = new ArrayList();
        ArrayList<ProjectInfo> arrayList3 = new ArrayList<ProjectInfo>();
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        this.tree.removeAll();
        this.tree.setHeaderVisible(true);
        this.tree.removeListener(8, (Listener)TreeViewerDoubleClickListener.getInstance());
        this.TabSize = tabFolder.getSize();
        int n = this.TabSize.x;
        this.firstColumn.setWidth((int)((double)n * 0.4));
        this.secondColumn.setWidth((int)((double)n * 0.1));
        this.thirdColumn.setWidth((int)((double)n * 0.1));
        this.fourthColumn.setWidth((int)((double)n * 0.25));
        this.fifthColumn.setWidth((int)((double)n * 0.1));
        this.emptyColumn.setWidth((int)((double)n * 0.05));
        this.invisibleColumn.setWidth(0);
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        if (arrayList == null) {
            HashSet<IProject> iProject22 = new HashSet<IProject>();
            CoverageUtil.getAllReferencedProjects(iProject22, iProject);
            arrayList2 = new ArrayList<IProject>(iProject22);
        } else {
            arrayList2 = arrayList;
        }
        arrayList2.add(0, iProject);
        for (IProject iProject2 : arrayList2) {
            String string = iProject2.getLocation().toOSString();
            object = String.valueOf(string) + File.separator + "Coverage_Report" + File.separator + "report.txt";
            File file = new File((String)object);
            if (!file.exists()) continue;
            ProjectInfo projectInfo = this.processLines((String)object, iProject2);
            projectInfo.setProjName(iProject2.getName());
            arrayList3.add(projectInfo);
            ArrayList<FileInfo> arrayList4 = projectInfo.getRootInfo();
            int n4 = arrayList4.size();
            int n5 = 0;
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setText(COLUMNONE, iProject2.getName());
            int n6 = projectInfo.getLineCount();
            int n7 = projectInfo.getMissCount();
            if (n6 == 0) continue;
            float f2 = (float)((n6 - n7) * 100) / (float)n6;
            f2 = Float.valueOf(decimalFormat.format(f2)).floatValue();
            n2 += n6;
            n3 += n7;
            treeItem.setText(COLUMNTWO, Integer.toString(n6));
            treeItem.setText(COLUMNTHREE, Integer.toString(n7));
            treeItem.setText(COLUMNFIVE, Float.toString(f2));
            projectInfo.setPercent(f2);
            while (n5 < n4) {
                FileInfo fileInfo = arrayList4.get(n5);
                if (!fileInfo.getIfParent()) continue;
                TreeItem treeItem2 = new TreeItem(treeItem, 0);
                treeItem2.setText(COLUMNONE, fileInfo.getfunctionName());
                treeItem2.setText(COLUMNTWO, Integer.toString(fileInfo.getLineCount()));
                treeItem2.setText(COLUMNTHREE, Integer.toString(fileInfo.getMissCount()));
                treeItem2.setText(COLUMNFIVE, Float.toString(fileInfo.getPercent()));
                treeItem2.setText(COLUMNSIX, Integer.toString(fileInfo.getLineStart()));
                ++n5;
                while (n5 < n4) {
                    fileInfo = arrayList4.get(n5);
                    if (fileInfo.getIfParent()) break;
                    TreeItem treeItem3 = new TreeItem(treeItem2, 0);
                    treeItem3.setText(COLUMNONE, fileInfo.getfunctionName());
                    treeItem3.setText(COLUMNTWO, Integer.toString(fileInfo.getLineCount()));
                    treeItem3.setText(COLUMNTHREE, Integer.toString(fileInfo.getMissCount()));
                    treeItem3.setText(COLUMNFIVE, Float.toString(fileInfo.getPercent()));
                    treeItem3.setText(COLUMNSIX, Integer.toString(fileInfo.getLineStart()));
                    ++n5;
                }
                treeItem2.setExpanded(true);
            }
            treeItem.setExpanded(false);
            if (!treeItem.getText(0).equals(iProject.getName())) continue;
            treeItem.setExpanded(true);
        }
        this.tree.addListener(42, (Listener)new PaintListener(this.tree));
        tabFolder.layout(true);
        f = (float)((n2 - n3) * 100) / (float)n2;
        f = Float.valueOf(decimalFormat.format(f)).floatValue();
        TreeItem treeItem4 = new TreeItem(this.tree, 0);
        treeItem4 = new TreeItem(this.tree, 0);
        treeItem4.setText(COLUMNONE, "Total");
        treeItem4.setText(COLUMNTWO, Integer.toString(n2));
        treeItem4.setText(COLUMNTHREE, Integer.toString(n3));
        treeItem4.setText(COLUMNFIVE, Float.toString(f));
        TotalReportGenerator totalReportGenerator = TotalReportGenerator.getInstance();
        totalReportGenerator.generateTotalReport((IProject)arrayList2.get(0), arrayList3, n2, n3, f);
        boolean bl = CoveragePreferencePage.isHtmlEnabledOnClick();
        if (bl) {
            object = HtmlReportGenerator.getInstance();
            ((HtmlReportGenerator)object).generateHtmlReport(arrayList2, arrayList3, n2, n3, f);
        }
        object = TreeViewerDoubleClickListener.getInstance();
        ((TreeViewerDoubleClickListener)object).setProject(iProject);
        this.tree.addListener(8, (Listener)object);
    }

    public void setFocus() {
    }
}

