/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.profiler.codecoverage.CommandManager;
import org.tizen.profiler.codecoverage.ui.AnnotateSource;
import org.tizen.profiler.codecoverage.ui.ViewInitializer;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class CoverageUtil {
    private static boolean isPrePostbuildStep = false;
    private static String SDK_TOOLS_FILEPATH = String.valueOf(InstallPathConfig.getSDKPath()) + File.separator + "tools" + File.separator;
    private static boolean isOSWindows = System.getProperty("os.name").startsWith("Windows");

    /*
     * Exception decompiling
     */
    public static String[] runCommandReturningResult(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String expandEnvVariables(String string, IProject iProject) {
        string = string.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)");
        IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)iProject).getDefaultConfiguration();
        if (string.indexOf("$(") >= 0) {
            IEnvironmentVariable[] iEnvironmentVariableArray;
            ICConfigurationDescription iCConfigurationDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)iConfiguration);
            IEnvironmentVariableManager iEnvironmentVariableManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray2 = iEnvironmentVariableArray = iEnvironmentVariableManager.getVariables(iCConfigurationDescription, true);
            int n = iEnvironmentVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray2[n2];
                string = string.replace(String.format("$(%s)", iEnvironmentVariable.getName()), iEnvironmentVariable.getValue());
                ++n2;
            }
        }
        return isOSWindows && !isPrePostbuildStep ? string.replace("\\", "/") : string;
    }

    private static void GenerateCovReport(File file, IProject iProject) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja";
        String string2 = CoverageUtil.expandEnvVariables("${PATH}", iProject);
        ProcessBuilder processBuilder = new ProcessBuilder(string, "cov_report_only");
        Map<String, String> map = processBuilder.environment();
        map.put("PATH", String.valueOf(string2) + File.pathSeparator + map.get("PATH"));
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static boolean GenerateCovData(String string, IProject iProject) {
        String string2;
        File file = new File(String.valueOf(string) + "default.profraw");
        if (!file.exists()) {
            return false;
        }
        file = new File(String.valueOf(string) + "coverage.profdata");
        if (file.exists()) {
            file.delete();
        }
        if ((string2 = CoverageUtil.expandEnvVariables("${SBI_COMPILER_PATH}", iProject)).contains("gcc")) {
            return false;
        }
        String string3 = String.valueOf(string2) + File.separator + "llvm-profdata";
        ProcessBuilder processBuilder = new ProcessBuilder(string3, "merge", "-o", String.valueOf(string) + "coverage.profdata", String.valueOf(string) + "default.profraw");
        File file2 = new File(String.valueOf(string) + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }

    public static String FindVersion(IDevice iDevice) {
        String string = null;
        try {
            string = iDevice.getPlatformInfo().getPlatformVersion();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            sdbCommandRejectedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public static boolean IsGreaterThanEqual(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        if (Integer.parseInt(stringArray2[0]) > Integer.parseInt(stringArray[0])) {
            return true;
        }
        if (Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) > Integer.parseInt(stringArray[1])) {
            return true;
        }
        return stringArray.length == 3 && stringArray2.length == 3 && Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) == Integer.parseInt(stringArray[1]) && Integer.parseInt(stringArray2[2]) > Integer.parseInt(stringArray[2]);
    }

    private static void GenerateCoverageInfo(IDevice iDevice, String string) {
        if (iDevice == null) {
            return;
        }
        String string2 = null;
        string2 = CoverageUtil.FindVersion(iDevice);
        if (string2 == null) {
            return;
        }
        if (!CoverageUtil.IsGreaterThanEqual(string2, "3.0")) {
            CommandManager.runCommand("root on");
            boolean bl = CommandManager.pull("/opt/usr/home/owner/share/tmp/sdk_tools/default.profraw", string);
            if (!bl) {
                string = "";
            }
        } else {
            CommandManager.runCommand("root on");
            String string3 = "su -c \"cp /tmp/default.profraw /home/developer\"";
            try {
                iDevice.executeShellCommand(string3, false);
                Thread.sleep(500L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            boolean bl = CommandManager.pull("/home/developer/default.profraw", string);
            if (!bl) {
                string = "";
            }
        }
    }

    public static void CopyCoverageInfo(String string, String string2) {
        File file = new File(String.valueOf(string) + File.separator + "coverage.profdata");
        File file2 = new File(String.valueOf(string2) + File.separator + "coverage.profdata");
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void annotateAllProjects(IProject iProject, IDevice iDevice) {
        String string = iProject.getLocation().toOSString();
        AnnotateSource annotateSource = new AnnotateSource();
        annotateSource.populate(string);
    }

    public static void getAllReferencedProjects(Set<IProject> set, IProject iProject) throws CoreException {
        IProject[] iProjectArray = iProject.getReferencedProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!set.contains(iProjectArray[n]) && iProjectArray[n].exists() && iProjectArray[n].isOpen()) {
                set.add(iProjectArray[n]);
                CoverageUtil.getAllReferencedProjects(set, iProjectArray[n]);
            }
            ++n;
        }
    }

    public static void ClearReport(IProject iProject) {
        String string = String.valueOf(iProject.getLocation().toOSString()) + File.separator + "Coverage_Report";
        File file = new File(string);
        try {
            if (file.exists()) {
                FileUtils.deleteDirectory((File)file);
            }
            file.mkdirs();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void ClearReports(ArrayList<IProject> arrayList) {
        arrayList.parallelStream().forEach(iProject -> CoverageUtil.ClearReport(iProject));
    }

    public static void generateCoverageReports(IDevice iDevice, IProject iProject) throws CoreException {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        CoverageUtil.getAllReferencedProjects(hashSet, iProject);
        ArrayList<IProject> arrayList = new ArrayList<IProject>(hashSet);
        CoverageUtil.ClearReport(iProject);
        CoverageUtil.ClearReports(arrayList);
        String string = iProject.getLocation().toOSString();
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        String string2 = iManagedBuildInfo.getConfigurationName();
        String string3 = String.valueOf(string) + File.separator + string2 + File.separator;
        File file = new File(string3);
        CoverageUtil.GenerateCoverageInfo(iDevice, string3);
        if (!CoverageUtil.GenerateCovData(string3, iProject)) {
            throw new CoreException((IStatus)new Status(4, "", "Coverage Data not generated. Check the toolchain selected or if coverage is enabled."));
        }
        CoverageUtil.GenerateCovReport(file, iProject);
        arrayList.parallelStream().forEach(iProject2 -> {
            String string3 = String.valueOf(iProject2.getLocation().toOSString()) + File.separator + string2 + File.separator;
            File file = new File(string3);
            CoverageUtil.CopyCoverageInfo(string3, string3);
            CoverageUtil.GenerateCovReport(file, iProject);
        });
        ViewInitializer viewInitializer = new ViewInitializer(iProject);
        viewInitializer.init(String.valueOf(string) + File.separator + "Coverage_Report" + File.separator + "report.txt", arrayList);
    }

    public static void cleanCov(File file, IProject iProject) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja";
        ProcessBuilder processBuilder = new ProcessBuilder(string, "clean_cov");
        String string2 = CoverageUtil.expandEnvVariables("${PATH}", iProject);
        Map<String, String> map = processBuilder.environment();
        map.put("PATH", String.valueOf(string2) + File.pathSeparator + map.get("PATH"));
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static boolean isUnitTestProject(IProject iProject) {
        String[] stringArray = null;
        try {
            stringArray = iProject.getDescription().getNatureIds();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if ("org.tizen.tizentest.nature".equals(string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

