/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.tizen.common.TizenProjectType;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.profiler.codecoverage.CoverageUtil;

public class TestProjectUtil {
    private static TestProjectUtil instance = new TestProjectUtil();

    public static TestProjectUtil getTestProjectUtilInstance() {
        return instance;
    }

    public IProject getCovProj(IProject iProject) {
        TizenProjectType tizenProjectType = ProjectUtil.getTizenProjectType((IProject)iProject);
        if (tizenProjectType == null) {
            return null;
        }
        if (!tizenProjectType.isNativeProject()) {
            return null;
        }
        if (tizenProjectType.isNativeApplicationProject()) {
            return iProject;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        iProject = this.getReferencedUniTestProj(iProject, arrayList);
        return iProject;
    }

    public IProject getReferencedUniTestProj(IProject iProject, ArrayList<String> arrayList) {
        List<IProject> list = Arrays.asList(iProject.getReferencingProjects());
        for (IProject iProject2 : list) {
            String string = iProject2.getName();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
            if (CoverageUtil.isUnitTestProject(iProject2)) {
                return iProject2;
            }
            IProject iProject3 = this.getReferencedUniTestProj(iProject2, arrayList);
            if (iProject3 == null) continue;
            return iProject3;
        }
        return null;
    }
}

