/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.preference;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.nativecommon.Activator;

public class CoveragePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
    public static final String ANNOTATE_ONCLICK = "org.tizen.coverage.preferences.annotate.onclick";
    public static final String HTML_ONCLICK = "org.tizen.coverage.preferences.html.onclick";
    private Button fShowTod;
    private Button fShowHtml;

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        int n = 1;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setText("Code Coverage Preferences");
        this.fShowTod = new Button((Composite)group, 32);
        this.fShowTod.setText("Enable annotation when source files are opened");
        this.fShowTod.setSelection(CoveragePreferencePage.isCoverageEnabledOnClick());
        this.fShowHtml = new Button((Composite)group, 32);
        this.fShowHtml.setText("Enable HTML Report generation when code coverage is run");
        this.fShowHtml.setSelection(CoveragePreferencePage.isHtmlEnabledOnClick());
        return composite2;
    }

    public static boolean isCoverageEnabledOnClick() {
        return prefStore.getBoolean(ANNOTATE_ONCLICK);
    }

    public static boolean isHtmlEnabledOnClick() {
        return prefStore.getBoolean(HTML_ONCLICK);
    }

    protected void performDefaults() {
        this.fShowTod.setSelection(false);
        this.fShowHtml.setSelection(false);
        super.performDefaults();
    }

    protected void performApply() {
        prefStore.setValue(ANNOTATE_ONCLICK, this.fShowTod.getSelection());
        prefStore.setValue(HTML_ONCLICK, this.fShowHtml.getSelection());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public static void initializeDefaultValues(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(ANNOTATE_ONCLICK, false);
        iPreferenceStore.setDefault(HTML_ONCLICK, false);
    }
}

