/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.core.gputil;

import java.util.Map;

public class MacroUtil {
    public static final String DEFAULT_START_LITER = "${";
    public static final String DEFAULT_END_LITER = "}";

    public static String processMacro(String source, Map<String, String> macros, String startLiter, String endLiter) {
        int idx2;
        if (source == null || source.isEmpty() || macros == null || macros.isEmpty()) {
            return source;
        }
        if (source.indexOf(startLiter, 0) < 0) {
            return source;
        }
        int startLiterLen = startLiter.length();
        int endLiterLen = endLiter.length();
        String str = "";
        int len = source.length();
        int idx = 0;
        while (idx < len && (idx2 = source.indexOf(startLiter, idx)) >= 0) {
            int idx3;
            if (idx < idx2) {
                str = str + source.substring(idx, idx2);
            }
            if ((idx3 = source.indexOf(endLiter, idx2)) < 0) break;
            String label = source.substring(idx2 + startLiterLen, idx3);
            String macro = macros.get(label);
            if (macro != null) {
                macro = MacroUtil.processMacro(macro, macros, startLiter, endLiter);
                str = str + macro;
            }
            idx = idx3 + endLiterLen;
        }
        if (idx < len) {
            str = str + source.substring(idx);
        }
        return str;
    }

    public static String processMacro(String source, Map<String, String> macros) {
        return MacroUtil.processMacro(source, macros, DEFAULT_START_LITER, DEFAULT_END_LITER);
    }
}

