/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.core.gputil;

import java.io.File;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.tizen.core.gputil.PathUtil;

public class MarkupUtil {
    public static final char DEFAULT_FIRST_LITER = '?';
    public static final char DEFAULT_START_LITER = '(';
    public static final char DEFAULT_END_LITER = ')';
    private static Runner defaultMarkupRunner = null;

    public static String runMarkup(String source, char firstLiter, char startLiter, char endLiter, Runner[] runners) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        if (source.indexOf(firstLiter, 0) < 0) {
            return source;
        }
        String str = "";
        String tempStr = "";
        int stackIdx = 0;
        int len = source.length();
        FuncToken[] stack = new FuncToken[len];
        FuncToken func = null;
        int idx = 0;
        int mode = 0;
        while (idx < len) {
            char ch = source.charAt(idx);
            ++idx;
            switch (mode) {
                case 0: {
                    if (ch == firstLiter) {
                        func = new FuncToken();
                        mode = 1;
                        break;
                    }
                    str = str + ch;
                    break;
                }
                case 1: {
                    tempStr = tempStr + ch;
                    if (ch == startLiter) {
                        mode = 2;
                        break;
                    }
                    func.name = func.name + ch;
                    break;
                }
                case 2: {
                    tempStr = tempStr + ch;
                    if (ch == endLiter) {
                        Runner runner;
                        String[] params = func.param.split(",");
                        String runStr = null;
                        Runner[] arr$ = runners;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (runStr = (runner = arr$[i$]).run(func.name, params)) == null; ++i$) {
                        }
                        if (stackIdx > 0) {
                            func = stack[--stackIdx];
                            if (runStr != null) {
                                func.param = func.param + runStr;
                            }
                            mode = 2;
                            break;
                        }
                        str = str + runStr;
                        mode = 0;
                        func = null;
                        tempStr = "";
                        break;
                    }
                    if (ch == firstLiter) {
                        stack[stackIdx++] = func;
                        func = new FuncToken();
                        mode = 1;
                        break;
                    }
                    func.param = func.param + ch;
                }
            }
        }
        if (!tempStr.isEmpty()) {
            str = str + tempStr;
        }
        return str;
    }

    public static String runMarkup(String source, char firstLiter, char startLiter, char endLiter, Runner runner) {
        return MarkupUtil.runMarkup(source, firstLiter, startLiter, endLiter, new Runner[]{runner});
    }

    public static Runner getDefaultMarkupRunner() {
        if (defaultMarkupRunner == null) {
            defaultMarkupRunner = new Runner(){

                @Override
                public String run(String func, String[] param) {
                    String value;
                    block4: {
                        block6: {
                            block5: {
                                block3: {
                                    value = null;
                                    if (!func.equals("dir")) break block3;
                                    File file = new File(param[0]);
                                    if (!file.exists()) break block4;
                                    value = file.getParent();
                                    break block4;
                                }
                                if (!func.equals("file")) break block5;
                                File file = new File(param[0]);
                                if (!file.exists()) break block4;
                                value = file.toString();
                                break block4;
                            }
                            if (!func.equals("filename")) break block6;
                            File file = new File(param[0]);
                            if (!file.exists()) break block4;
                            value = file.getName();
                            break block4;
                        }
                        if (func.equals("relative")) {
                            return PathUtil.getRelativePath(param[0], param[1]);
                        }
                        if (func.equals("select")) {
                            for (String p : param) {
                                if (p == null || p.isEmpty()) continue;
                                value = p;
                                break;
                            }
                        }
                    }
                    return value;
                }
            };
        }
        return defaultMarkupRunner;
    }

    public static String processDefaultMarkup(String source) {
        return MarkupUtil.runMarkup(source, '?', '(', ')', MarkupUtil.getDefaultMarkupRunner());
    }

    public static Runner getJavaScriptMarkupRunner(String script) {
        ScriptEngine js = new ScriptEngineManager().getEngineByName("javascript");
        try {
            js.eval(script);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        final Invocable invocableEngine = (Invocable)((Object)js);
        Runner runner = new Runner(){

            @Override
            public String run(String func, String[] param) {
                String ret = null;
                try {
                    ret = (String)invocableEngine.invokeFunction(func, param);
                }
                catch (NoSuchMethodException e) {
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
                return ret;
            }
        };
        return runner;
    }

    public static String processMarkupByJavaScript(String source, String javaScript) {
        return MarkupUtil.runMarkup(source, '?', '(', ')', MarkupUtil.getJavaScriptMarkupRunner(javaScript));
    }

    public static String processDefaultMarkup2(String source, Runner[] extRunners) {
        Runner[] runners = new Runner[1 + extRunners.length];
        runners[0] = MarkupUtil.getDefaultMarkupRunner();
        for (int i = 0; i < extRunners.length; ++i) {
            runners[1 + i] = extRunners[i];
        }
        return MarkupUtil.runMarkup(source, '?', '(', ')', runners);
    }

    private static class FuncToken {
        public String name = "";
        public String param = "";

        private FuncToken() {
        }
    }

    public static interface Runner {
        public String run(String var1, String[] var2);
    }
}

