/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.sbilib.for_cli.ToolchainData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolchainManager {
    public static List<ToolchainData> getToolchainDataList(String sbiHomePath) {
        File sbiHomeFile = new File(sbiHomePath, "plugins");
        File[] xmlFiles = sbiHomeFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        String xpath = "/extension[@point='toolchainDefinition']";
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath expr = xpathFactory.newXPath();
        if (xmlFiles != null) {
            ArrayList<ToolchainData> ids = new ArrayList<ToolchainData>();
            for (File xmlFile : xmlFiles) {
                try {
                    Document doc = XMLUtil.readXML(new FileInputStream(xmlFile));
                    NodeList nodes = null;
                    Object nodeset = null;
                    try {
                        nodeset = expr.compile(xpath).evaluate(doc, XPathConstants.NODESET);
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (nodeset == null || !(nodeset instanceof NodeList)) continue;
                    nodes = (NodeList)nodeset;
                    int size = nodes.getLength();
                    for (int i = 0; i < size; ++i) {
                        Node node = nodes.item(i);
                        if (!(node instanceof Element)) continue;
                        NodeList rootStraps = ((Element)node).getElementsByTagName("toolchain");
                        int rootstrapSize = rootStraps.getLength();
                        for (int j = 0; j < rootstrapSize; ++j) {
                            Element propElem;
                            int k;
                            Element element = (Element)rootStraps.item(j);
                            String id = element.getAttribute("id");
                            String name = element.getAttribute("name");
                            String version = element.getAttribute("version");
                            String architecture = element.getAttribute("architecture");
                            String path = element.getAttribute("path");
                            ToolchainData toolchainData = new ToolchainData(id, name, version, architecture, path);
                            NodeList childNodes = element.getElementsByTagName("property");
                            int elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                toolchainData.addProperty(propElem.getAttribute("key"), propElem.getAttribute("value"));
                            }
                            childNodes = element.getElementsByTagName("tool");
                            elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                toolchainData.addTool(propElem.getAttribute("name"), propElem.getAttribute("version"), propElem.getAttribute("path"));
                            }
                            ids.add(toolchainData);
                        }
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return ids;
        }
        return null;
    }

    public static ToolchainData getToolchain(List<ToolchainData> toolchainList, String toolchainName, String arch, String projType) {
        if (toolchainName == null || arch == null || projType == null) {
            return null;
        }
        for (ToolchainData toolchain : toolchainList) {
            if (!toolchainName.equals(toolchain.getName()) || !arch.equals(toolchain.getArchitecture()) || !projType.equals(toolchain.getProperty("PROJECT_TYPE"))) continue;
            return toolchain;
        }
        return null;
    }
}

