/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.core.gputil;

import java.io.File;

public class PathUtil {
    public static boolean isAbsolutePath(String filePath) {
        return new File(filePath).isAbsolute();
    }

    public static String getFullPath(String rootPath, String filePath) {
        if (rootPath == null) {
            return filePath;
        }
        if (filePath == null) {
            return rootPath;
        }
        if (new File(filePath).isAbsolute()) {
            return filePath;
        }
        return new File(rootPath, filePath).toString();
    }

    public static String getRelativePath(String rootPath, String filePath) {
        int i;
        if (rootPath == null) {
            return filePath;
        }
        if (filePath == null) {
            return rootPath;
        }
        String sep = "/";
        if ((rootPath = rootPath.replace('\\', '/')).equals(filePath = filePath.replace('\\', '/'))) {
            return ".";
        }
        String[] rootPaths = rootPath.split(sep);
        String[] filePaths = filePath.split(sep);
        if (filePaths.length <= 0) {
            return filePath;
        }
        int len = 0;
        for (int i2 = 0; i2 < filePaths.length; ++i2) {
            len = i2;
            if (i2 >= rootPaths.length || !filePaths[i2].equalsIgnoreCase(rootPaths[i2])) break;
        }
        String pre = "";
        for (i = 0; i < rootPaths.length - len; ++i) {
            if (!pre.isEmpty()) {
                pre = pre + sep;
            }
            pre = pre + "..";
        }
        for (i = len; i < filePaths.length; ++i) {
            if (!pre.isEmpty()) {
                pre = pre + sep;
            }
            pre = pre + filePaths[i];
        }
        return pre;
    }

    public static String trim(String dir) {
        if (dir.endsWith("/.") || dir.endsWith("\\.")) {
            dir = dir.substring(0, dir.length() - 2);
        }
        if (dir.length() > 1 && dir.endsWith("/") || dir.endsWith("\\")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    public static String addPath(String path, String ... paths) {
        for (String p : paths) {
            path = path + File.separator + p;
        }
        return path;
    }
}

