/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.core.gputil.MarkupUtil;
import org.tizen.sbilib.for_cli.SBIBuildParamData;
import org.tizen.sbilib.for_cli.SBISysVar;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainData;

public class SBIMacro {
    protected final Logger logger = LoggerFactory.getLogger(SBIMacro.class);
    private List<MacroOrigin> macroOrgs = new ArrayList<MacroOrigin>();
    private Map<String, String> macros = new HashMap<String, String>();
    private Map<String, String> variables = new HashMap<String, String>();
    private String script;
    private MacroUtil.Runner macroRunner = new MacroRunner(this);
    private Runner runner = null;

    public String processValue(String src) {
        if (src != null && !src.isEmpty() && (src = this.runner != null ? MacroUtil.processMacro((String)src, (MacroUtil.Runner)this.macroRunner) : MacroUtil.processMacro((String)src, this.macros)) != null && !src.isEmpty()) {
            src = this.getScript() == null ? MarkupUtil.processDefaultMarkup((String)src) : MarkupUtil.processDefaultMarkup2((String)src, (MarkupUtil.Runner[])new MarkupUtil.Runner[]{MarkupUtil.getJavaScriptMarkupRunner((String)this.getScript())});
        }
        return src;
    }

    public Map<String, String> getMacroOrgs() {
        return this.macros;
    }

    public Map<String, String> getMacros() {
        return this.macros;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void addScript(String script) {
        this.script = this.script == null ? script : this.script + "\r\n" + script;
    }

    public String getScript() {
        return this.script;
    }

    public void setMacroRunner(Runner runner) {
        this.runner = runner;
    }

    public Runner getMacroRunner() {
        return this.runner;
    }

    public void addMacro(String name, String value) {
        this.macros.put(name, value);
    }

    public void addVariable(String name, String value) {
        this.variables.put(name, value);
    }

    public String getValue(String name) {
        String value = this.macros.get(name);
        if (value == null) {
            value = this.variables.get(name);
        }
        return value;
    }

    public void addMacroOrigin(String name, String method, String source, String valueOp, String sep, String pr, String sur, String attr) {
        this.macroOrgs.add(new MacroOrigin(name, method, source, valueOp, sep, pr, sur, attr));
    }

    public void prepareSystemVariables(SBIBuildParamData sysVarData) {
        sysVarData.putProperty("dir.separator", File.separator);
        sysVarData.putProperty("path.separator", File.pathSeparator);
        String osName = System.getProperty("os.name");
        sysVarData.putProperty("os.name", osName);
        if (osName.toLowerCase().startsWith("windows")) {
            sysVarData.putProperty("os.name.windows", osName);
        }
        if (osName.toLowerCase().startsWith("linux")) {
            sysVarData.putProperty("os.name.linux", osName);
        }
        if (osName.toLowerCase().startsWith("mac")) {
            sysVarData.putProperty("os.name.mac", osName);
        }
    }

    public void realizeAllMacros(SBIBuildParamData sysVarData, SBISysVar sysVarGetter, SBIToolchainData toolchain, SBIRootstrapData rootstrap, Map<String, List<String>> rootstrapParam) {
        this.prepareSystemVariables(sysVarData);
        for (MacroOrigin macroOrg : this.macroOrgs) {
            String name = macroOrg.name;
            String method = macroOrg.method;
            String source = macroOrg.source;
            String value0 = macroOrg.valueOp;
            String value = null;
            List<String> listValue = null;
            if (method.equals("sysvar")) {
                if (sysVarGetter != null) {
                    value = sysVarGetter.getSysVar(source, value0);
                }
                if (value == null) {
                    String[] values;
                    Object value2;
                    if (source.equals("OS")) {
                        value2 = sysVarData.getProperty(value0);
                        if (value2 != null && value2 instanceof String) {
                            value = (String)value2;
                        }
                    } else if (source.equals("SDK")) {
                        value2 = sysVarData.getProperty(value0);
                        if (value2 != null && value2 instanceof String) {
                            value = (String)value2;
                        }
                    } else if (source.equals("TOOLCHAIN")) {
                        if (toolchain != null) {
                            values = value0.split(":");
                            if (values[0].equals("tool")) {
                                SBIToolchainData.ToolData tool = toolchain.getTool(values[1]);
                                if (tool != null) {
                                    value = tool.path;
                                }
                            } else if (values[0].equals("property")) {
                                value = toolchain.getProperty(values[1]);
                            }
                        }
                    } else if (source.equals("ROOTSTRAP")) {
                        if (rootstrap != null) {
                            values = value0.split(":");
                            if (values[0].equals("tool")) {
                                SBIRootstrapData.ToolData tool = rootstrap.getTool(values[1]);
                                if (tool != null) {
                                    value = tool.path;
                                }
                            } else if (values[0].equals("property")) {
                                value = rootstrap.getProperty(values[1]);
                            } else if (values[0].equals("devpackage") && rootstrapParam != null) {
                                listValue = rootstrapParam.get(values[1]);
                            }
                        }
                    } else if (source.equals("PROJECT") && (value2 = sysVarData.getProperty(value0)) != null) {
                        if (value2 instanceof String) {
                            value = (String)value2;
                        } else if (value2 instanceof List) {
                            listValue = (List)value2;
                        }
                    }
                }
            } else if (!method.equals("xpath") && method.equals("user")) {
                value = value0;
            }
            if (listValue != null && !listValue.isEmpty()) {
                String sep = macroOrg.sep;
                sep = this.processValue(sep);
                String pr = macroOrg.pr;
                pr = this.processValue(pr);
                String sur = macroOrg.sur;
                sur = this.processValue(sur);
                value = "";
                for (String val : listValue) {
                    if (!value.isEmpty() && sep != null && !sep.isEmpty()) {
                        value = value + sep;
                    }
                    value = value + pr + val + sur;
                }
            }
            if (value == null) continue;
            if (macroOrg.attrs != null) {
                for (String attr : macroOrg.attrs) {
                    if (attr.equals("linuxsep")) {
                        value = value.replace('\\', '/');
                        continue;
                    }
                    if (attr.equals("windowssep")) {
                        value = value.replace('/', '\\');
                        continue;
                    }
                    if (!attr.equals("strip") || !value.isEmpty()) continue;
                    value = null;
                    break;
                }
            }
            if (value == null) continue;
            this.addMacro(name, value);
        }
    }

    public static class MacroRunner
    implements MacroUtil.Runner {
        private SBIMacro proc;

        public MacroRunner(SBIMacro proc) {
            this.proc = proc;
        }

        public String run(String macro) {
            String value = null;
            if (this.proc.getMacros() != null) {
                value = this.proc.getMacros().get(macro);
            }
            if (value == null && this.proc.getVariables() != null && this.proc.getMacroRunner() != null && (value = this.proc.getVariables().get(macro)) != null) {
                value = this.proc.getMacroRunner().getVariable(value);
            }
            return value;
        }
    }

    public static interface Runner {
        public String getVariable(String var1);
    }

    private class MacroOrigin {
        public String name;
        public String method;
        public String source;
        public String valueOp;
        public String sep;
        public String pr;
        public String sur;
        public String[] attrs;

        public MacroOrigin(String name, String method, String source, String valueOp, String sep, String pr, String sur, String attr) {
            this.name = name;
            this.method = method;
            this.source = source;
            this.valueOp = valueOp;
            this.sep = sep;
            this.pr = pr;
            this.sur = sur;
            this.attrs = attr != null && !attr.isEmpty() ? attr.split(",") : null;
        }
    }
}

