/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli.sbiplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.OSChecker;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapManager;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainManager;

public class SBIPluginManager {
    protected final Logger logger = LoggerFactory.getLogger(SBIPluginManager.class);
    private String sbiHomePath;
    private Map<String, String> macros = new HashMap<String, String>();
    private List<SBIRootstrapData> rootstrapList = null;
    private List<SBIToolchainData> toolchainList = null;

    public static List<SBIRootstrapData> loadRootstrapList(String sbiHomePath) {
        return SBIRootstrapManager.getRootstrapDataList(sbiHomePath);
    }

    public static SBIRootstrapData findRootstrap(List<SBIRootstrapData> rootstrapList, String rootstrapName) {
        SBIRootstrapData rootstrap = SBIRootstrapManager.getRootstrap(rootstrapList, rootstrapName);
        return rootstrap;
    }

    public static SBIRootstrapData findRootstrap(List<SBIRootstrapData> rootstrapList, String profileName, String profileVersion, String arch) {
        String platformName = profileName + " " + profileVersion;
        SBIRootstrapData rootstrap = SBIRootstrapManager.getRootstrap(rootstrapList, platformName, arch);
        return rootstrap;
    }

    public static List<SBIToolchainData> loadToolchainList(String sbiHomePath) {
        return SBIToolchainManager.getToolchainDataList(sbiHomePath);
    }

    public static SBIToolchainData findToolchain(List<SBIToolchainData> toolchainList, String toolchainName, String arch, String projType) {
        SBIToolchainData toolchain = SBIToolchainManager.getToolchain(toolchainList, toolchainName, arch);
        return toolchain;
    }

    public static SBIToolchainData findLatestToolchain(List<SBIToolchainData> toolchainList, String toolchainName, String arch, String projType) {
        SBIToolchainData toolchain = SBIToolchainManager.getLatestToolchain(toolchainList, toolchainName, arch);
        return toolchain;
    }

    public static SBIToolchainData findToolchainForPlatform(List<SBIToolchainData> toolchainList, String toolchainName, String arch, String platformVersion) {
        SBIToolchainData toolchain = SBIToolchainManager.getToolchainForPlatform(toolchainList, toolchainName, arch, platformVersion);
        return toolchain;
    }

    public SBIPluginManager(String sbiHomePath) {
        this.macros.put("SBI_HOME", sbiHomePath);
        if (OSChecker.isWindows()) {
            sbiHomePath = sbiHomePath.replace('\\', '/');
        }
        this.sbiHomePath = sbiHomePath;
        this.rootstrapList = SBIRootstrapManager.getRootstrapDataList(sbiHomePath);
        this.toolchainList = SBIToolchainManager.getToolchainDataList(sbiHomePath);
    }

    public void setRootstrapList(List<SBIRootstrapData> rootstrapList) {
        this.rootstrapList = rootstrapList;
    }

    public List<SBIRootstrapData> getRootstrapList() {
        return this.rootstrapList;
    }

    public void setToolchainList(List<SBIToolchainData> toolchainList) {
        this.toolchainList = toolchainList;
    }

    public List<SBIToolchainData> getToolchainList() {
        return this.toolchainList;
    }

    public String getSbiHomePath() {
        return this.sbiHomePath;
    }

    public SBIRootstrapData findRootstrap(String rootstrapName) {
        SBIRootstrapData rootstrap = SBIPluginManager.findRootstrap(this.rootstrapList, rootstrapName);
        return rootstrap;
    }

    public SBIRootstrapData findRootstrap(String profileName, String profileVersion, String arch) {
        return SBIPluginManager.findRootstrap(this.rootstrapList, profileName, profileVersion, arch);
    }

    public SBIToolchainData findToolchain(String toolchainName, String arch, String projType) {
        return SBIPluginManager.findToolchain(this.toolchainList, toolchainName, arch, projType);
    }

    public SBIToolchainData findLatestToolchain(String toolchainName, String arch, String projType) {
        return SBIPluginManager.findLatestToolchain(this.toolchainList, toolchainName, arch, projType);
    }

    public SBIToolchainData findToolchainForPlatform(String toolchainName, String arch, String platformVersion) {
        return SBIPluginManager.findToolchainForPlatform(this.toolchainList, toolchainName, arch, platformVersion);
    }

    public void realizePluginValue(SBIRootstrapData rootstrap, SBIToolchainData toolchain) {
        if (rootstrap != null) {
            rootstrap.processMacro(this.macros, "#{", "}");
        }
        if (toolchain != null) {
            String defGccPath = null;
            String defGccPrefix = null;
            if (toolchain.getName().toLowerCase().startsWith("llvm") && rootstrap != null) {
                SBIToolchainData platformDefGccToolchain;
                SBIRootstrapData.ToolchainData tool = rootstrap.getDefaultToolchain("gcc");
                String backendGccName = tool.name + "-" + tool.version;
                if (toolchain.getName().equalsIgnoreCase("llvm-3.7")) {
                    backendGccName = "gcc-4.9";
                }
                if ((platformDefGccToolchain = SBIToolchainManager.getToolchain(this.toolchainList, backendGccName, toolchain.getArchitecture())) != null) {
                    defGccPath = platformDefGccToolchain.getPath();
                    defGccPrefix = platformDefGccToolchain.getPropertyOrg("TOOLCHAIN_PREFIX");
                }
            }
            if (defGccPath != null && !defGccPath.isEmpty()) {
                this.macros.put("PLATFORM_DEFAULT_GCC_PATH", defGccPath);
                this.macros.put("PLATFORM_DEFAULT_GCC_PREFIX", defGccPrefix);
            } else {
                this.macros.remove("PLATFORM_DEFAULT_GCC_PATH");
                this.macros.remove("PLATFORM_DEFAULT_GCC_PREFIX");
            }
            toolchain.processMacro(this.macros, "#{", "}");
        }
    }
}

